/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.sqlsheet;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.pcal.sqlsheet.XlsResultSetMetaData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsResultSet
implements ResultSet {
    private static final double BAD_DOUBLE = 0.0;
    protected Statement statement;
    private Workbook workbook;
    private Sheet sheet;
    private XlsResultSetMetaData metadata;
    private int firstSheetRowOffset = 0;
    private int cursorSheetRow = this.firstSheetRowOffset - 1;
    private CellStyle dateStyle = null;
    private DataFormatter formatter;

    public XlsResultSet(Workbook wb, Sheet s) throws SQLException {
        if (s == null) {
            throw new IllegalArgumentException("null sheet");
        }
        if (wb == null) {
            throw new IllegalArgumentException("null workbook");
        }
        this.formatter = new DataFormatter();
        this.workbook = wb;
        this.sheet = s;
        this.firstSheetRowOffset = 1;
        this.cursorSheetRow = this.firstSheetRowOffset - 1;
        this.metadata = new XlsResultSetMetaData(s, this);
        this.dateStyle = this.workbook.createCellStyle();
        this.dateStyle.setDataFormat(this.workbook.createDataFormat().getFormat("yyyy-mm-dd"));
    }

    private static Object getObject(Cell cell) throws SQLException {
        try {
            if (cell == null) {
                return null;
            }
            switch (cell.getCellType()) {
                case 4: {
                    return cell.getBooleanCellValue();
                }
                case 1: {
                    return cell.getStringCellValue();
                }
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return cell.getDateCellValue();
                    }
                    return cell.getNumericCellValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw XlsResultSet.wrapped(e);
        }
    }

    private static SQLException wrapped(Throwable t) {
        SQLException out = new SQLException(t.getMessage());
        out.initCause(t);
        return out;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public boolean getBoolean(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return cell != null && cell.getBooleanCellValue();
    }

    @Override
    public boolean getBoolean(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return cell != null && cell.getBooleanCellValue();
    }

    @Override
    public double getDouble(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return cell == null ? 0.0 : cell.getNumericCellValue();
    }

    @Override
    public double getDouble(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return cell == null ? 0.0 : cell.getNumericCellValue();
    }

    @Override
    public byte getByte(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (byte)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public byte getByte(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (byte)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public float getFloat(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (float)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public float getFloat(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (float)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public int getInt(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (int)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public int getInt(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (int)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public long getLong(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (long)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public long getLong(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (long)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public Object getObject(String jdbcColumn) throws SQLException {
        return XlsResultSet.getObject(this.getCell(jdbcColumn));
    }

    @Override
    public Object getObject(int jdbcColumn) throws SQLException {
        return XlsResultSet.getObject(this.getCell(jdbcColumn));
    }

    @Override
    public <T> T getObject(int jdbcColumn, Class<T> type) throws SQLException {
        return (T)this.getObject(jdbcColumn);
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        return (T)this.getObject(columnName);
    }

    Object getNextRowObject(int jdbcColumn) throws SQLException {
        if (this.sheet.getRow(this.cursorSheetRow + 1) != null) {
            Cell cell = this.sheet.getRow(this.cursorSheetRow + 1).getCell((int)((short)(jdbcColumn - 1)));
            return XlsResultSet.getObject(cell);
        }
        return this.getObject(jdbcColumn);
    }

    @Override
    public Timestamp getTimestamp(int jdbcColumn) throws SQLException {
        return new Timestamp(((java.util.Date)this.getObject(jdbcColumn)).getTime());
    }

    @Override
    public Timestamp getTimestamp(String jdbcColumn) throws SQLException {
        return new Timestamp(((java.util.Date)this.getObject(jdbcColumn)).getTime());
    }

    @Override
    public Timestamp getTimestamp(int jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Timestamp getTimestamp(String jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public short getShort(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (short)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public short getShort(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return (short)(cell == null ? 0.0 : cell.getNumericCellValue());
    }

    @Override
    public String getString(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return cell == null ? null : this.formatter.formatCellValue(cell);
    }

    @Override
    public String getString(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        return cell == null ? null : this.formatter.formatCellValue(cell);
    }

    @Override
    public void updateBoolean(int jdbcColumn, boolean x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue(x);
        }
    }

    @Override
    public void updateBoolean(String jdbcColumn, boolean x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue(x);
        }
    }

    @Override
    public void updateByte(int jdbcColumn, byte x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateByte(String jdbcColumn, byte x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateDouble(int jdbcColumn, double x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue(x);
        }
    }

    @Override
    public void updateDouble(String jdbcColumn, double x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue(x);
        }
    }

    @Override
    public void updateFloat(int jdbcColumn, float x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateFloat(String jdbcColumn, float x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateInt(int jdbcColumn, int x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateInt(String jdbcColumn, int x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateLong(int jdbcColumn, long x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateLong(String jdbcColumn, long x) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateNull(int jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((String)null);
        }
    }

    @Override
    public void updateNull(String jdbcColumn) throws SQLException {
        Cell cell = this.getCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((String)null);
        }
    }

    @Override
    public void updateObject(int jdbcColumn, Object x) throws SQLException {
        this.updateObject(this.findOrCreateCell(jdbcColumn), x);
    }

    @Override
    public void updateObject(String jdbcColumn, Object x) throws SQLException {
        this.updateObject(this.findOrCreateCell(jdbcColumn), x);
    }

    @Override
    public void updateShort(int jdbcColumn, short x) throws SQLException {
        Cell cell = this.findOrCreateCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateShort(String jdbcColumn, short x) throws SQLException {
        Cell cell = this.findOrCreateCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue((double)x);
        }
    }

    @Override
    public void updateString(int jdbcColumn, String x) throws SQLException {
        Cell cell = this.findOrCreateCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue(x);
        }
    }

    @Override
    public void updateString(String jdbcColumn, String x) throws SQLException {
        Cell cell = this.findOrCreateCell(jdbcColumn);
        if (cell != null) {
            cell.setCellValue(x);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.cursorSheetRow = row - 1 + this.firstSheetRowOffset;
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.cursorSheetRow = this.sheet.getLastRowNum() + 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.cursorSheetRow = this.firstSheetRowOffset - 1;
    }

    @Override
    public boolean first() throws SQLException {
        this.cursorSheetRow = this.firstSheetRowOffset;
        return true;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw this.nyi();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getRow() throws SQLException {
        return this.cursorSheetRow - this.firstSheetRowOffset + 1;
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursorSheetRow > this.sheet.getLastRowNum();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursorSheetRow < this.firstSheetRowOffset;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.cursorSheetRow == this.firstSheetRowOffset;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.cursorSheetRow == this.sheet.getLastRowNum();
    }

    @Override
    public boolean last() throws SQLException {
        this.cursorSheetRow = this.sheet.getLastRowNum();
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isAfterLast()) {
            return false;
        }
        ++this.cursorSheetRow;
        return !this.isAfterLast() && this.sheet.getRow(this.cursorSheetRow) != null;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isBeforeFirst()) {
            return false;
        }
        --this.cursorSheetRow;
        return this.isBeforeFirst();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        while (true) {
            Row row;
            if ((row = this.sheet.getRow(this.cursorSheetRow)) == null || row.getCell(0) == null) {
                this.sheet.createRow(this.cursorSheetRow);
                return;
            }
            ++this.cursorSheetRow;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        ++this.cursorSheetRow;
    }

    private void updateObject(Cell cell, Object x) throws SQLException {
        if (x instanceof String) {
            cell.setCellValue((String)x);
        } else if (x instanceof char[]) {
            cell.setCellValue(new String((char[])x));
        } else if (x instanceof Double) {
            if (x.equals(Double.NEGATIVE_INFINITY) || x.equals(Double.POSITIVE_INFINITY) || x.equals(Double.NaN)) {
                cell.setCellValue(0.0);
            } else {
                cell.setCellValue(((Double)x).doubleValue());
            }
        } else if (x instanceof Number) {
            cell.setCellValue(((Number)x).doubleValue());
        } else if (x instanceof java.util.Date) {
            cell.setCellValue(DateUtil.getExcelDate((java.util.Date)((java.util.Date)x)));
            if (this.dateStyle != null) {
                cell.setCellStyle(this.dateStyle);
            }
        } else if (x instanceof Boolean) {
            cell.setCellValue(((Boolean)x).booleanValue());
        } else if (x == null) {
            cell.setCellValue((String)null);
        } else {
            throw new SQLException("Unknown value type for ExcelResultSet.updateObject: " + x + " (" + x.getClass().getName() + ")");
        }
    }

    private Row getCurrentRow() {
        if (this.sheet.getRow(this.cursorSheetRow) == null) {
            this.sheet.createRow(this.cursorSheetRow);
        }
        return this.sheet.getRow(this.cursorSheetRow);
    }

    private Cell findOrCreateCell(int jdbcColumn) {
        Cell cell = this.getCell(jdbcColumn);
        if (cell == null) {
            cell = this.getCurrentRow().createCell((int)((short)(jdbcColumn - 1)));
        }
        return cell;
    }

    private Cell findOrCreateCell(String jdbcColumn) {
        short col = this.getSheetColumnNamed(jdbcColumn);
        return this.findOrCreateCell(col);
    }

    private Cell getCell(int jdbcColumn) {
        return this.sheet.getRow(this.cursorSheetRow).getCell((int)((short)(jdbcColumn - 1)));
    }

    private Cell getCell(String named) {
        return this.sheet.getRow(this.cursorSheetRow).getCell((int)this.getSheetColumnNamed(named));
    }

    private short getSheetColumnNamed(String name) {
        short s = this.metadata.getColumnCount();
        for (short i = 0; i < s; i = (short)(i + 1)) {
            String col = this.metadata.getColumnName(i + 1);
            if (!col.equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    private IllegalStateException nyi() {
        return new IllegalStateException("NYI");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public int findColumn(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getAsciiStream(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getAsciiStream(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public BigDecimal getBigDecimal(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public BigDecimal getBigDecimal(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public BigDecimal getBigDecimal(int jdbcColumn, int scale) throws SQLException {
        throw this.nyi();
    }

    @Override
    public BigDecimal getBigDecimal(String jdbcColumn, int scale) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getBinaryStream(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getBinaryStream(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw this.nyi();
    }

    @Override
    public byte[] getBytes(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public byte[] getBytes(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Reader getCharacterStream(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Reader getCharacterStream(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw this.nyi();
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw this.nyi();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw this.nyi();
    }

    @Override
    public Date getDate(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Date getDate(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Date getDate(int jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Date getDate(String jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Time getTime(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Time getTime(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Time getTime(int jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Time getTime(String jdbcColumn, Calendar cal) throws SQLException {
        throw this.nyi();
    }

    @Override
    public URL getURL(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public URL getURL(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getUnicodeStream(int jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public InputStream getUnicodeStream(String jdbcColumn) throws SQLException {
        throw this.nyi();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateArray(int jdbcColumn, Array x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateArray(String jdbcColumn, Array x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw this.nyi();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw this.nyi();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw this.nyi();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(int jdbcColumn, InputStream x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateAsciiStream(String jdbcColumn, InputStream x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBigDecimal(int jdbcColumn, BigDecimal x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBigDecimal(String jdbcColumn, BigDecimal x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(int jdbcColumn, InputStream x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBinaryStream(String jdbcColumn, InputStream x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(int jdbcColumn, Blob x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBlob(String jdbcColumn, Blob x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBytes(int jdbcColumn, byte[] x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateBytes(String jdbcColumn, byte[] x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(int jdbcColumn, Reader x, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateCharacterStream(String jdbcColumn, Reader reader, int length) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(int jdbcColumn, Clob x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateClob(String jdbcColumn, Clob x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateDate(int jdbcColumn, Date x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateDate(String jdbcColumn, Date x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateObject(int jdbcColumn, Object x, int scale) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateObject(String jdbcColumn, Object x, int scale) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRef(int jdbcColumn, Ref x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRef(String jdbcColumn, Ref x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateRow() throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateTime(int jdbcColumn, Time x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateTime(String jdbcColumn, Time x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateTimestamp(int jdbcColumn, Timestamp x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public void updateTimestamp(String jdbcColumn, Timestamp x) throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw this.nyi();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw this.nyi();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw this.nyi();
    }
}

