/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.sqlsheet;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pcal.sqlsheet.XlsConnection;
import net.pcal.sqlsheet.XlsStatement;
import net.pcal.sqlsheet.parser.CreateTableStatement;
import net.pcal.sqlsheet.parser.InsertIntoStatement;
import net.pcal.sqlsheet.parser.JdbcParameter;
import net.pcal.sqlsheet.parser.ParsedStatement;
import net.pcal.sqlsheet.parser.SelectStarStatement;

public class XlsPreparedStatement
extends XlsStatement
implements PreparedStatement {
    private static final Logger logger = Logger.getLogger(XlsPreparedStatement.class.getName());
    private ParsedStatement statement;
    private List<Object> parameters = new ArrayList<Object>();

    public XlsPreparedStatement(XlsConnection conn, String sql) throws SQLException {
        super(conn);
        this.statement = super.parse(sql);
    }

    public void addBatch() throws SQLException {
        this.nyi();
    }

    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    public boolean execute() throws SQLException {
        this.executeQuery();
        return true;
    }

    public int executeUpdate() throws SQLException {
        this.executeQuery();
        return -1;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.statement == null) {
            throw new IllegalStateException("null statement");
        }
        if (this.statement instanceof SelectStarStatement) {
            return super.doSelect((SelectStarStatement)this.statement);
        }
        if (this.statement instanceof CreateTableStatement) {
            return super.doCreateTable((CreateTableStatement)this.statement);
        }
        if (this.statement instanceof InsertIntoStatement) {
            final InsertIntoStatement iis = (InsertIntoStatement)this.statement;
            final ArrayList<Object> substitutedValues = new ArrayList<Object>();
            substitutedValues.addAll(iis.getValues());
            int paramIndex = 0;
            for (int i = 0; i < substitutedValues.size(); ++i) {
                Object val = substitutedValues.get(i);
                logger.log(Level.FINE, "execute Query Insertintostatement: " + substitutedValues.get(i));
                if (!(val instanceof JdbcParameter)) continue;
                substitutedValues.set(i, this.parameters.get(paramIndex++));
            }
            return super.doInsert(new InsertIntoStatement(){

                @Override
                public List<String> getColumns() {
                    return iis.getColumns();
                }

                @Override
                public String getTable() {
                    return iis.getTable();
                }

                @Override
                public List<Object> getValues() {
                    return substitutedValues;
                }
            });
        }
        throw new IllegalStateException("Execute Query Exception: " + this.statement.getClass().getName());
    }

    private void setParameter(int p, Object val) {
        --p;
        while (this.parameters.size() <= p) {
            this.parameters.add(null);
        }
        this.parameters.set(p, val);
    }

    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setByte(int arg0, byte arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setDate(int arg0, Date arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setDouble(int arg0, double arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setFloat(int arg0, float arg1) throws SQLException {
        this.setParameter(arg0, Float.valueOf(arg1));
    }

    public void setInt(int arg0, int arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setLong(int arg0, long arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setNull(int arg0, int arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setShort(int arg0, short arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setString(int arg0, String arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setTime(int arg0, Time arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        char[] buff = new char[length];
        try {
            reader.read(buff, 0, length);
            this.setString(parameterIndex, new String(buff));
        }
        catch (IOException e) {
            SQLException sqe = new SQLException(e.getMessage());
            sqe.initCause(e);
            throw sqe;
        }
    }

    public void setObject(int arg0, Object arg1) throws SQLException {
        this.setParameter(arg0, arg1);
    }

    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        this.nyi();
    }

    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        this.nyi();
    }

    public void setArray(int arg0, Array arg1) throws SQLException {
        this.nyi();
    }

    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.nyi();
    }

    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        this.nyi();
    }

    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        this.nyi();
    }

    public void setClob(int arg0, Clob arg1) throws SQLException {
        this.nyi();
    }

    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        this.nyi();
    }

    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        this.nyi();
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.nyi();
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.nyi();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.nyi();
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.nyi();
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.nyi();
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.nyi();
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.nyi();
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.nyi();
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.nyi();
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.nyi();
    }

    public void setRef(int arg0, Ref arg1) throws SQLException {
        this.nyi();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.nyi();
        return null;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.nyi();
        return null;
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.nyi();
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.nyi();
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.nyi();
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.nyi();
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.nyi();
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.nyi();
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.nyi();
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.nyi();
    }

    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.nyi();
    }

    public void setBlob(int arg0, Blob arg1) throws SQLException {
        this.nyi();
    }

    public void setURL(int arg0, URL arg1) throws SQLException {
        this.nyi();
    }

    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.nyi();
    }

    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

