/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.sqlsheet;

import com.googlecode.sqlsheet.stream.XlsStreamConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pcal.sqlsheet.XlsConnection;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsDriver
implements Driver {
    private static final String URL_SCHEME = "jdbc:xls:";
    private static final String READ_STREAMING = "readStreaming";
    private static final String WRITE_STREAMING = "writeStreaming";
    private static final Logger logger = Logger.getLogger(XlsDriver.class.getName());

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    public Connection connect(String jdbcUrl, Properties info) throws SQLException {
        if (jdbcUrl == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (!this.acceptsURL(jdbcUrl)) {
            return null;
        }
        if (!jdbcUrl.toLowerCase().startsWith(URL_SCHEME)) {
            throw new IllegalArgumentException("URL is not jdbc:xls: (" + jdbcUrl + ")");
        }
        int questionIndex = jdbcUrl.indexOf(63);
        if (questionIndex >= 0) {
            String[] split;
            info = new Properties(info);
            String urlProperties = jdbcUrl.substring(questionIndex);
            for (String each : split = urlProperties.substring(1).split("&")) {
                String[] property = each.split("=");
                try {
                    String key;
                    if (property.length == 2) {
                        key = URLDecoder.decode(property[0], "UTF-8");
                        String value = URLDecoder.decode(property[1], "UTF-8");
                        info.setProperty(key, value);
                        continue;
                    }
                    if (property.length == 1) {
                        key = URLDecoder.decode(property[0], "UTF-8");
                        info.setProperty(key, Boolean.TRUE.toString());
                        continue;
                    }
                    throw new SQLException("Invalid property: " + each);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            jdbcUrl = jdbcUrl.substring(0, questionIndex);
        }
        try {
            URL workbookUrl = new URL(jdbcUrl.substring(URL_SCHEME.length()));
            if (info.get(READ_STREAMING) != null && info.get(READ_STREAMING).equals(Boolean.TRUE.toString())) {
                return new XlsStreamConnection(workbookUrl);
            }
            if (workbookUrl.getProtocol().equalsIgnoreCase("file")) {
                if (info.get(WRITE_STREAMING) != null && info.get(WRITE_STREAMING).equals(Boolean.TRUE.toString())) {
                    return new XlsConnection((Workbook)this.getOrCreateXlsxStream(workbookUrl), new File(workbookUrl.getPath()));
                }
                return new XlsConnection(this.getOrCreateWorkbook(workbookUrl), new File(workbookUrl.getPath()));
            }
            return new XlsConnection(WorkbookFactory.create((InputStream)workbookUrl.openStream()));
        }
        catch (Exception e) {
            SQLException sqe = new SQLException(e.getMessage());
            sqe.initCause(e);
            throw sqe;
        }
    }

    private SXSSFWorkbook getOrCreateXlsxStream(URL workbookUrl) throws IOException, InvalidFormatException {
        if (workbookUrl.getProtocol().equalsIgnoreCase("file")) {
            File source = new File(workbookUrl.getPath());
            if (source.exists() || source.length() != 0L) {
                logger.warning("File " + source.getPath() + " is not empty, and will parsed to memory!");
            } else {
                XSSFWorkbook workbook = new XSSFWorkbook();
                this.flushWorkbook((Workbook)workbook, source);
            }
        }
        return new SXSSFWorkbook(new XSSFWorkbook(workbookUrl.openStream()), 1000, false);
    }

    private Workbook getOrCreateWorkbook(URL workbookUrl) throws IOException, InvalidFormatException {
        File file;
        if (workbookUrl.getProtocol().equalsIgnoreCase("file") && (!(file = new File(workbookUrl.getPath())).exists() || file.length() == 0L)) {
            Object workbook = file.getPath().toLowerCase().endsWith("x") ? new XSSFWorkbook() : new HSSFWorkbook();
            this.flushWorkbook((Workbook)workbook, file);
        }
        return WorkbookFactory.create((InputStream)workbookUrl.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushWorkbook(Workbook workbook, File file) throws IOException {
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(file);
            workbook.write((OutputStream)fileOut);
            fileOut.flush();
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.trim().toLowerCase().startsWith(URL_SCHEME);
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        try {
            DriverManager.registerDriver(new XlsDriver());
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Couldn't register " + XlsDriver.class.getName(), e);
        }
    }
}

