/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sqlsheet.stream;

import com.googlecode.sqlsheet.stream.AbstractXlsSheetIterator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactoryInputStream;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class XlsSheetIterator
extends AbstractXlsSheetIterator
implements HSSFListener {
    NPOIFSFileSystem fileSystem;
    boolean inRequiredSheet;
    RecordFactoryInputStream recordStream;
    PublicMorozoffHSSFRequest requestPublic;
    int lastRowNumber;
    int lastColumnNumber;
    boolean outputFormulaValues;
    EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    HSSFWorkbook stubWorkbook;
    SSTRecord sstRecord;
    FormatTrackingHSSFListener formatListener;
    int sheetIndex;
    BoundSheetRecord[] orderedBSRs;
    ArrayList boundSheetRecords;
    int nextRow;
    int nextColumn;
    boolean outputNextStringRecord;

    public XlsSheetIterator(URL filename, String sheetName) throws SQLException {
        super(filename, sheetName);
    }

    public void postConstruct() throws SQLException {
        try {
            Record r;
            this.boundSheetRecords = new ArrayList();
            this.sheetIndex = -1;
            this.inRequiredSheet = false;
            this.outputFormulaValues = true;
            this.fileSystem = new NPOIFSFileSystem(this.fileName.openStream());
            this.recordStream = new RecordFactoryInputStream((InputStream)this.fileSystem.getRoot().createDocumentInputStream("Workbook"), false);
            MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
            this.formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
            this.requestPublic = new PublicMorozoffHSSFRequest();
            if (this.outputFormulaValues) {
                this.requestPublic.addListenerForAllRecords((HSSFListener)this.formatListener);
            } else {
                this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
                this.requestPublic.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
            }
            while (!this.inRequiredSheet && (r = this.recordStream.nextRecord()) != null) {
                try {
                    short userCode = this.requestPublic.processRecord(r);
                    if (userCode == 0) continue;
                    break;
                }
                catch (HSSFUserException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            this.currentSheetRowIndex = 0L;
            this.processNextRecords();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    protected void processNextRecords() throws SQLException {
        Record r;
        Long nextRowIndex = this.currentSheetRowIndex + 2L;
        while (this.inRequiredSheet && !this.currentSheetRowIndex.equals(nextRowIndex) && (r = this.recordStream.nextRecord()) != null) {
            try {
                short userCode = this.requestPublic.processRecord(r);
                if (userCode == 0) continue;
                break;
            }
            catch (HSSFUserException e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
    }

    public void processRecord(Record record) {
        int thisRow = -1;
        int thisColumn = -1;
        AbstractXlsSheetIterator.CellValueHolder thisCellValue = new AbstractXlsSheetIterator.CellValueHolder();
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add(record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                ++this.sheetIndex;
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition((List)this.boundSheetRecords);
                }
                this.inRequiredSheet = this.sheetName.equalsIgnoreCase(this.orderedBSRs[this.sheetIndex].getSheetname()) || ("\"" + this.orderedBSRs[this.sheetIndex].getSheetname() + "\"").equalsIgnoreCase(this.sheetName);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 513: {
                BlankRecord brec = (BlankRecord)record;
                thisRow = brec.getRow();
                thisColumn = brec.getColumn();
                thisCellValue.stringValue = "";
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                thisRow = berec.getRow();
                thisColumn = berec.getColumn();
                thisCellValue.stringValue = "";
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)record;
                thisRow = frec.getRow();
                thisColumn = frec.getColumn();
                if (this.outputFormulaValues) {
                    if (Double.isNaN(frec.getValue())) {
                        this.outputNextStringRecord = true;
                        this.nextRow = frec.getRow();
                        this.nextColumn = frec.getColumn();
                        break;
                    }
                    thisCellValue.stringValue = this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
                    thisCellValue.doubleValue = frec.getValue();
                    thisCellValue.dateValue = this.convertDateValue(frec.getValue(), this.formatListener.getFormatIndex((CellValueRecordInterface)frec), this.formatListener.getFormatString((CellValueRecordInterface)frec));
                    break;
                }
                thisCellValue.stringValue = HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])frec.getParsedExpression());
                thisCellValue.doubleValue = frec.getValue();
                thisCellValue.dateValue = this.convertDateValue(frec.getValue(), this.formatListener.getFormatIndex((CellValueRecordInterface)frec), this.formatListener.getFormatString((CellValueRecordInterface)frec));
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord srec = (StringRecord)record;
                thisCellValue.stringValue = srec.getString();
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                thisRow = lrec.getRow();
                thisColumn = lrec.getColumn();
                thisCellValue.stringValue = lrec.getValue();
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                thisRow = lsrec.getRow();
                thisColumn = lsrec.getColumn();
                if (this.sstRecord == null) {
                    thisCellValue.stringValue = "\"(No SST Record, can't identify string)\"";
                    break;
                }
                thisCellValue.stringValue = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                break;
            }
            case 28: {
                NoteRecord nrec = (NoteRecord)record;
                thisRow = nrec.getRow();
                thisColumn = nrec.getColumn();
                thisCellValue.stringValue = "\"(TODO)\"";
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                thisRow = numrec.getRow();
                thisColumn = numrec.getColumn();
                thisCellValue.stringValue = this.formatListener.formatNumberDateCell((CellValueRecordInterface)numrec);
                thisCellValue.doubleValue = numrec.getValue();
                thisCellValue.dateValue = this.convertDateValue(numrec.getValue(), this.formatListener.getFormatIndex((CellValueRecordInterface)numrec), this.formatListener.getFormatString((CellValueRecordInterface)numrec));
                break;
            }
            case 638: {
                RKRecord rkrec = (RKRecord)record;
                thisRow = rkrec.getRow();
                thisColumn = rkrec.getColumn();
                thisCellValue.stringValue = "\"(TODO)\"";
                break;
            }
        }
        if (thisRow != -1 && thisRow != this.lastRowNumber) {
            this.lastColumnNumber = -1;
        }
        if (record instanceof MissingCellDummyRecord) {
            MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
            thisRow = mc.getRow();
            thisColumn = mc.getColumn();
            thisCellValue.stringValue = "";
        }
        if (thisCellValue.stringValue != null) {
            if (this.currentSheetRowIndex.equals(0L) && this.inRequiredSheet) {
                this.columns.add(thisCellValue);
            } else if (this.inRequiredSheet) {
                this.addCurrentRowValue(thisCellValue);
            }
        }
        if (thisRow > -1) {
            this.lastRowNumber = thisRow;
        }
        if (thisColumn > -1) {
            this.lastColumnNumber = thisColumn;
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            this.lastColumnNumber = -1;
            Long l = this.currentSheetRowIndex;
            Long l2 = this.currentSheetRowIndex = Long.valueOf(this.currentSheetRowIndex + 1L);
        }
    }

    protected void onClose() throws SQLException {
        try {
            if (this.fileSystem != null) {
                this.fileSystem.close();
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    class PublicMorozoffHSSFRequest
    extends HSSFRequest {
        PublicMorozoffHSSFRequest() {
        }

        public short processRecord(Record rec) throws HSSFUserException {
            return super.processRecord(rec);
        }
    }
}

