/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sqlsheet.stream;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXlsSheetIterator
implements Iterable<Object>,
Iterator<Object> {
    URL fileName;
    String sheetName;
    List<CellValueHolder> columns = new ArrayList<CellValueHolder>();
    Map<Long, List<CellValueHolder>> rowValues = new HashMap<Long, List<CellValueHolder>>();
    Long currentSheetRowIndex = 0L;
    Long currentIteratorRowIndex = 0L;

    public AbstractXlsSheetIterator(URL filename, String sheetName) throws SQLException {
        this.fileName = filename;
        this.sheetName = sheetName;
        this.postConstruct();
    }

    protected abstract void postConstruct() throws SQLException;

    protected abstract void processNextRecords() throws SQLException;

    protected abstract void onClose() throws SQLException;

    @Override
    public Iterator<Object> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.rowValues.get(this.currentIteratorRowIndex + 1L) != null;
    }

    @Override
    public Object next() {
        try {
            this.rowValues.remove(this.currentIteratorRowIndex);
            Long l = this.currentIteratorRowIndex;
            Long l2 = this.currentIteratorRowIndex = Long.valueOf(this.currentIteratorRowIndex + 1L);
            this.processNextRecords();
            if (this.rowValues.get(this.currentIteratorRowIndex + 1L) == null) {
                this.processNextRecords();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.rowValues.get(this.currentIteratorRowIndex);
    }

    void addCurrentRowValue(CellValueHolder cellValue) {
        if (this.rowValues.get(this.currentSheetRowIndex) == null) {
            this.rowValues.put(this.currentSheetRowIndex, new ArrayList());
        }
        this.rowValues.get(this.currentSheetRowIndex).add(cellValue);
    }

    CellValueHolder getCurrentRowValue(int column) {
        CellValueHolder result = new CellValueHolder();
        if (this.rowValues.get(this.currentIteratorRowIndex) != null && column < this.rowValues.get(this.currentIteratorRowIndex).size()) {
            result = this.rowValues.get(this.currentIteratorRowIndex).get(column);
        }
        return result;
    }

    CellValueHolder getNextRowValue(int column) {
        CellValueHolder result = new CellValueHolder();
        if (this.rowValues.get(this.currentIteratorRowIndex + 1L) != null && column < this.rowValues.get(this.currentIteratorRowIndex + 1L).size()) {
            result = this.rowValues.get(this.currentIteratorRowIndex + 1L).get(column);
        }
        return result;
    }

    @Override
    public void remove() {
    }

    Date convertDateValue(double value, int formatIndex, String formatString) {
        if (DateUtil.isADateFormat((int)formatIndex, (String)formatString) && DateUtil.isValidExcelDate((double)value)) {
            return DateUtil.getJavaDate((double)value, (boolean)false);
        }
        return null;
    }

    class CellValueHolder {
        String stringValue;
        Double doubleValue;
        Date dateValue;

        CellValueHolder() {
        }

        public String toString() {
            return "CellValueHolder{stringValue='" + this.stringValue + '\'' + ", doubleValue=" + this.doubleValue + ", dateValue=" + this.dateValue + '}';
        }

        public Class getType() {
            if (this.dateValue != null) {
                return this.dateValue.getClass();
            }
            if (this.doubleValue != null) {
                return this.doubleValue.getClass();
            }
            if (this.stringValue != null) {
                return this.stringValue.getClass();
            }
            return Object.class;
        }
    }
}

