/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.IPSet;
import com.amazonaws.services.waf.model.IPSetDescriptor;
import com.amazonaws.services.waf.model.transform.IPSetDescriptorJsonMarshaller;
import java.util.List;

public class IPSetJsonMarshaller {
    private static IPSetJsonMarshaller instance;

    public void marshall(IPSet iPSet, StructuredJsonGenerator jsonGenerator) {
        if (iPSet == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<IPSetDescriptor> iPSetDescriptorsList;
            jsonGenerator.writeStartObject();
            if (iPSet.getIPSetId() != null) {
                jsonGenerator.writeFieldName("IPSetId").writeValue(iPSet.getIPSetId());
            }
            if (iPSet.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(iPSet.getName());
            }
            if ((iPSetDescriptorsList = iPSet.getIPSetDescriptors()) != null) {
                jsonGenerator.writeFieldName("IPSetDescriptors");
                jsonGenerator.writeStartArray();
                for (IPSetDescriptor iPSetDescriptorsListValue : iPSetDescriptorsList) {
                    if (iPSetDescriptorsListValue == null) continue;
                    IPSetDescriptorJsonMarshaller.getInstance().marshall(iPSetDescriptorsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IPSetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IPSetJsonMarshaller();
        }
        return instance;
    }
}

