/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.internal.SdkFunction;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientConfigurationFactory;
import com.amazonaws.services.s3.AmazonS3ClientParamsWrapper;
import com.amazonaws.services.s3.S3ClientOptions;

@NotThreadSafe
public final class AmazonS3ClientBuilder
extends AwsSyncClientBuilder<AmazonS3ClientBuilder, AmazonS3> {
    private static final AmazonS3ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new AmazonS3ClientConfigurationFactory();
    private static final SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> DEFAULT_CLIENT_FACTORY = new SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3>(){

        @Override
        public AmazonS3 apply(AmazonS3ClientParamsWrapper params) {
            return new AmazonS3Client(params);
        }
    };
    private final SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> clientFactory;
    private Boolean pathStyleAccessEnabled;
    private Boolean chunkedEncodingDisabled;
    private Boolean accelerateModeEnabled;
    private Boolean payloadSigningEnabled;

    public static AmazonS3ClientBuilder standard() {
        return new AmazonS3ClientBuilder();
    }

    public static AmazonS3 defaultClient() {
        return (AmazonS3)AmazonS3ClientBuilder.standard().build();
    }

    private AmazonS3ClientBuilder() {
        this(DEFAULT_CLIENT_FACTORY);
    }

    @SdkTestInternalApi
    AmazonS3ClientBuilder(SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> clientFactory) {
        super(CLIENT_CONFIG_FACTORY);
        this.clientFactory = clientFactory;
    }

    public Boolean isPathStyleAccessEnabled() {
        return this.pathStyleAccessEnabled;
    }

    public void setPathStyleAccessEnabled(Boolean pathStyleAccessEnabled) {
        this.pathStyleAccessEnabled = pathStyleAccessEnabled;
    }

    public AmazonS3ClientBuilder withPathStyleAccessEnabled(Boolean pathStyleAccessEnabled) {
        this.setPathStyleAccessEnabled(pathStyleAccessEnabled);
        return this;
    }

    public AmazonS3ClientBuilder enablePathStyleAccess() {
        this.setPathStyleAccessEnabled(Boolean.TRUE);
        return this;
    }

    public Boolean isChunkedEncodingDisabled() {
        return this.chunkedEncodingDisabled;
    }

    public void setChunkedEncodingDisabled(Boolean chunkedEncodingDisabled) {
        this.chunkedEncodingDisabled = chunkedEncodingDisabled;
    }

    public AmazonS3ClientBuilder withChunkedEncodingDisabled(Boolean chunkedEncodingDisabled) {
        this.setChunkedEncodingDisabled(chunkedEncodingDisabled);
        return this;
    }

    public AmazonS3ClientBuilder disableChunkedEncoding() {
        this.setChunkedEncodingDisabled(Boolean.TRUE);
        return this;
    }

    public Boolean isAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public void setAccelerateModeEnabled(Boolean accelerateModeEnabled) {
        this.accelerateModeEnabled = accelerateModeEnabled;
    }

    public AmazonS3ClientBuilder withAccelerateModeEnabled(Boolean accelerateModeEnabled) {
        this.setAccelerateModeEnabled(accelerateModeEnabled);
        return this;
    }

    public AmazonS3ClientBuilder enableAccelerateMode() {
        this.setAccelerateModeEnabled(Boolean.TRUE);
        return this;
    }

    public Boolean isPayloadSigningEnabled() {
        return this.payloadSigningEnabled;
    }

    public void setPayloadSigningEnabled(Boolean payloadSigningEnabled) {
        this.payloadSigningEnabled = payloadSigningEnabled;
    }

    public AmazonS3ClientBuilder withPayloadSigningEnabled(Boolean payloadSigningEnabled) {
        this.setPayloadSigningEnabled(payloadSigningEnabled);
        return this;
    }

    public AmazonS3ClientBuilder enablePayloadSigning() {
        this.setPayloadSigningEnabled(Boolean.TRUE);
        return this;
    }

    @Override
    protected AmazonS3 build(AwsSyncClientParams clientParams) {
        return this.clientFactory.apply(new AmazonS3ClientParamsWrapper(clientParams, this.resolveS3ClientOptions()));
    }

    private S3ClientOptions resolveS3ClientOptions() {
        S3ClientOptions.Builder builder = S3ClientOptions.builder();
        if (this.chunkedEncodingDisabled != null && this.chunkedEncodingDisabled.booleanValue()) {
            builder.disableChunkedEncoding();
        }
        if (this.payloadSigningEnabled != null) {
            builder.setPayloadSigningEnabled(this.payloadSigningEnabled);
        }
        if (this.accelerateModeEnabled != null) {
            builder.setAccelerateModeEnabled(this.accelerateModeEnabled);
        }
        if (this.pathStyleAccessEnabled != null) {
            builder.setPathStyleAccess(this.pathStyleAccessEnabled);
        }
        return builder.build();
    }
}

