/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.UpdateGameSessionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateGameSessionRequestMarshaller
implements Marshaller<Request<UpdateGameSessionRequest>, UpdateGameSessionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateGameSessionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateGameSessionRequest> marshall(UpdateGameSessionRequest updateGameSessionRequest) {
        if (updateGameSessionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateGameSessionRequest> request = new DefaultRequest<UpdateGameSessionRequest>(updateGameSessionRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateGameSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateGameSessionRequest.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(updateGameSessionRequest.getGameSessionId());
            }
            if (updateGameSessionRequest.getMaximumPlayerSessionCount() != null) {
                jsonGenerator.writeFieldName("MaximumPlayerSessionCount").writeValue(updateGameSessionRequest.getMaximumPlayerSessionCount());
            }
            if (updateGameSessionRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateGameSessionRequest.getName());
            }
            if (updateGameSessionRequest.getPlayerSessionCreationPolicy() != null) {
                jsonGenerator.writeFieldName("PlayerSessionCreationPolicy").writeValue(updateGameSessionRequest.getPlayerSessionCreationPolicy());
            }
            if (updateGameSessionRequest.getProtectionPolicy() != null) {
                jsonGenerator.writeFieldName("ProtectionPolicy").writeValue(updateGameSessionRequest.getProtectionPolicy());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

