/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;

@DynamoDBAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBAutoGeneratedTimestamp {
    public DynamoDBAutoGenerateStrategy strategy() default DynamoDBAutoGenerateStrategy.ALWAYS;

    public static final class Generator<T>
    implements DynamoDBAutoGenerator<T> {
        private final StandardTypeConverters.ConvertTo<Date, T> converter;
        private final DynamoDBAutoGenerateStrategy strategy;

        public Generator(Class<T> targetType, DynamoDBAutoGeneratedTimestamp annotation) {
            this.converter = StandardTypeConverters.Scalar.DATE.to(targetType, false);
            this.strategy = annotation.strategy();
        }

        @Override
        public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
            return this.strategy;
        }

        @Override
        public final T generate(T currentValue) {
            return this.converter.convertTo(new Date());
        }
    }
}

