/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutScheduledUpdateGroupActionRequestMarshaller
implements Marshaller<Request<PutScheduledUpdateGroupActionRequest>, PutScheduledUpdateGroupActionRequest> {
    @Override
    public Request<PutScheduledUpdateGroupActionRequest> marshall(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {
        if (putScheduledUpdateGroupActionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutScheduledUpdateGroupActionRequest> request = new DefaultRequest<PutScheduledUpdateGroupActionRequest>(putScheduledUpdateGroupActionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putScheduledUpdateGroupActionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(putScheduledUpdateGroupActionRequest.getAutoScalingGroupName()));
        }
        if (putScheduledUpdateGroupActionRequest.getScheduledActionName() != null) {
            request.addParameter("ScheduledActionName", StringUtils.fromString(putScheduledUpdateGroupActionRequest.getScheduledActionName()));
        }
        if (putScheduledUpdateGroupActionRequest.getTime() != null) {
            request.addParameter("Time", StringUtils.fromDate(putScheduledUpdateGroupActionRequest.getTime()));
        }
        if (putScheduledUpdateGroupActionRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(putScheduledUpdateGroupActionRequest.getStartTime()));
        }
        if (putScheduledUpdateGroupActionRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(putScheduledUpdateGroupActionRequest.getEndTime()));
        }
        if (putScheduledUpdateGroupActionRequest.getRecurrence() != null) {
            request.addParameter("Recurrence", StringUtils.fromString(putScheduledUpdateGroupActionRequest.getRecurrence()));
        }
        if (putScheduledUpdateGroupActionRequest.getMinSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger(putScheduledUpdateGroupActionRequest.getMinSize()));
        }
        if (putScheduledUpdateGroupActionRequest.getMaxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger(putScheduledUpdateGroupActionRequest.getMaxSize()));
        }
        if (putScheduledUpdateGroupActionRequest.getDesiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger(putScheduledUpdateGroupActionRequest.getDesiredCapacity()));
        }
        return request;
    }
}

