/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;

public class CreateTableDeParser {
    protected StringBuilder buffer;

    public CreateTableDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(CreateTable createTable) {
        this.buffer.append("CREATE TABLE " + createTable.getTable().getWholeTableName());
        if (createTable.getColumnDefinitions() != null) {
            Iterator<String> iterator;
            this.buffer.append(" (");
            Iterator<Object> iter = createTable.getColumnDefinitions().iterator();
            while (iter.hasNext()) {
                ColumnDefinition columnDefinition = iter.next();
                this.buffer.append(columnDefinition.getColumnName());
                this.buffer.append(" ");
                this.buffer.append(columnDefinition.getColDataType().toString());
                if (columnDefinition.getColumnSpecStrings() != null) {
                    iterator = columnDefinition.getColumnSpecStrings().iterator();
                    while (iterator.hasNext()) {
                        this.buffer.append(" ");
                        this.buffer.append(iterator.next());
                    }
                }
                if (!iter.hasNext()) continue;
                this.buffer.append(" , ");
            }
            if (createTable.getIndexes() != null) {
                iter = createTable.getIndexes().iterator();
                while (iter.hasNext()) {
                    this.buffer.append(",");
                    Index index = (Index)iter.next();
                    this.buffer.append(index.getType() + " " + index.getName());
                    this.buffer.append("(");
                    iterator = index.getColumnsNames().iterator();
                    while (iterator.hasNext()) {
                        this.buffer.append(iterator.next());
                        if (!iterator.hasNext()) continue;
                        this.buffer.append(", ");
                    }
                    this.buffer.append(")");
                    if (!iter.hasNext()) continue;
                    this.buffer.append(",");
                }
            }
            this.buffer.append(" )");
        }
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

