/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.util;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CircularBlockingQueue<E>
implements BlockingQueue<E> {
    private static final foe LOG = goe.a(CircularBlockingQueue.class);
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final ArrayDeque<E> queue;
    private final int maxSize;
    private long droppedCount;

    public CircularBlockingQueue(int n2) {
        this.queue = new ArrayDeque(n2);
        this.maxSize = n2;
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.droppedCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e2) {
        Objects.requireNonNull(e2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (this.queue.size() == this.maxSize) {
                E e3 = this.queue.remove();
                ++this.droppedCount;
                LOG.b("Queue is full. Discarding oldest element [count={}]: {}", (Object)this.droppedCount, (Object)e3);
            }
            this.queue.add(e2);
            this.notEmpty.signal();
        }
        finally {
            reentrantLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.queue.isEmpty()) {
                if (l3 <= 0L) {
                    E e2 = null;
                    return e2;
                }
                l3 = this.notEmpty.awaitNanos(l3);
            }
            E e3 = this.queue.poll();
            return e3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.queue.isEmpty()) {
                this.notEmpty.await();
            }
            E e2 = this.queue.poll();
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = this.queue.isEmpty();
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = this.queue.size();
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public long getDroppedCount() {
        return this.droppedCount;
    }

    boolean isConsumerThreadBlocked() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = reentrantLock.getWaitQueueLength(this.notEmpty) > 0;
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(E e2) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }
}

