/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.WatchedEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerWatcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.IWatchManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.PathParentIterator;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchStats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatcherMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesPathReport;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesReport;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesSummary;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WatchManager
implements IWatchManager {
    private static final foe LOG = goe.a(WatchManager.class);
    private final Map<String, Set<Watcher>> watchTable = new HashMap<String, Set<Watcher>>();
    private final Map<Watcher, Map<String, WatchStats>> watch2Paths = new HashMap<Watcher, Map<String, WatchStats>>();
    private int recursiveWatchQty = 0;

    @Override
    public synchronized int size() {
        int n2 = 0;
        for (Set<Watcher> set : this.watchTable.values()) {
            n2 += set.size();
        }
        return n2;
    }

    private boolean isDeadWatcher(Watcher watcher) {
        return watcher instanceof ServerCnxn && ((ServerCnxn)watcher).isStale();
    }

    @Override
    public boolean addWatch(String string, Watcher watcher) {
        return this.addWatch(string, watcher, WatcherMode.DEFAULT_WATCHER_MODE);
    }

    @Override
    public synchronized boolean addWatch(String string, Watcher watcher, WatcherMode watcherMode) {
        WatchStats watchStats;
        WatchStats watchStats2;
        if (this.isDeadWatcher(watcher)) {
            LOG.b("Ignoring addWatch with closed cnxn");
            return false;
        }
        Set<Watcher> set = this.watchTable.get(string);
        if (set == null) {
            set = new HashSet<Watcher>(4);
            this.watchTable.put(string, set);
        }
        set.add(watcher);
        Map<String, WatchStats> map = this.watch2Paths.get(watcher);
        if (map == null) {
            map = new HashMap<String, WatchStats>();
            this.watch2Paths.put(watcher, map);
        }
        if ((watchStats2 = (watchStats = map.getOrDefault(string, WatchStats.NONE)).addMode(watcherMode)) != watchStats) {
            map.put(string, watchStats2);
            if (watcherMode.isRecursive()) {
                ++this.recursiveWatchQty;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeWatcher(Watcher watcher) {
        Map<String, WatchStats> map = this.watch2Paths.remove(watcher);
        if (map == null) {
            return;
        }
        for (String object : map.keySet()) {
            Set<Watcher> set = this.watchTable.get(object);
            if (set == null) continue;
            set.remove(watcher);
            if (!set.isEmpty()) continue;
            this.watchTable.remove(object);
        }
        for (WatchStats watchStats : map.values()) {
            if (!watchStats.hasMode(WatcherMode.PERSISTENT_RECURSIVE)) continue;
            --this.recursiveWatchQty;
        }
    }

    @Override
    public WatcherOrBitSet triggerWatch(String string, Watcher.Event.EventType eventType, long l2, List<ACL> list) {
        return this.triggerWatch(string, eventType, l2, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatcherOrBitSet triggerWatch(String string, Watcher.Event.EventType eventType, long l2, List<ACL> list, WatcherOrBitSet watcherOrBitSet) {
        WatchedEvent watchedEvent = new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, string, l2);
        HashSet<Watcher> hashSet = new HashSet<Watcher>();
        WatchManager watchManager = this;
        synchronized (watchManager) {
            PathParentIterator object = this.getPathParentIterator(string);
            for (String string2 : object.asIterable()) {
                Set<Watcher> set = this.watchTable.get(string2);
                if (set == null || set.isEmpty()) continue;
                Iterator<Watcher> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Watcher watcher = iterator.next();
                    Map<String, WatchStats> map = this.watch2Paths.getOrDefault(watcher, Collections.emptyMap());
                    WatchStats watchStats = (WatchStats)map.get(string2);
                    if (watchStats == null) {
                        LOG.d("inconsistent watch table for watcher {}, {} not in path list", (Object)watcher, (Object)string2);
                        continue;
                    }
                    if (!object.atParentPath()) {
                        hashSet.add(watcher);
                        WatchStats watchStats2 = watchStats.removeMode(WatcherMode.STANDARD);
                        if (watchStats2 == WatchStats.NONE) {
                            iterator.remove();
                            map.remove(string2);
                            continue;
                        }
                        if (watchStats2 == watchStats) continue;
                        map.put(string2, watchStats2);
                        continue;
                    }
                    if (!watchStats.hasMode(WatcherMode.PERSISTENT_RECURSIVE)) continue;
                    hashSet.add(watcher);
                }
                if (!set.isEmpty()) continue;
                this.watchTable.remove(string2);
            }
        }
        if (hashSet.isEmpty()) {
            if (LOG.b()) {
                ZooTrace.logTraceMessage(LOG, 64L, "No watchers for " + string);
            }
            return null;
        }
        for (Watcher watcher : hashSet) {
            if (watcherOrBitSet != null && watcherOrBitSet.contains(watcher)) continue;
            if (watcher instanceof ServerWatcher) {
                ((ServerWatcher)watcher).process(watchedEvent, list);
                continue;
            }
            watcher.process(watchedEvent);
        }
        switch (eventType) {
            case NodeCreated: {
                ServerMetrics.getMetrics().NODE_CREATED_WATCHER.add(hashSet.size());
                break;
            }
            case NodeDeleted: {
                ServerMetrics.getMetrics().NODE_DELETED_WATCHER.add(hashSet.size());
                break;
            }
            case NodeDataChanged: {
                ServerMetrics.getMetrics().NODE_CHANGED_WATCHER.add(hashSet.size());
                break;
            }
            case NodeChildrenChanged: {
                ServerMetrics.getMetrics().NODE_CHILDREN_WATCHER.add(hashSet.size());
                break;
            }
        }
        return new WatcherOrBitSet(hashSet);
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.watch2Paths.size()).append(" connections watching ").append(this.watchTable.size()).append(" paths\n");
        int n2 = 0;
        for (Map<String, WatchStats> map : this.watch2Paths.values()) {
            n2 += map.size();
        }
        stringBuilder.append("Total watches:").append(n2);
        return stringBuilder.toString();
    }

    @Override
    public synchronized void dumpWatches(PrintWriter printWriter, boolean bl2) {
        if (bl2) {
            for (Map.Entry<String, Set<Watcher>> entry : this.watchTable.entrySet()) {
                printWriter.println(entry.getKey());
                for (Watcher watcher : entry.getValue()) {
                    printWriter.print("\t0x");
                    printWriter.print(Long.toHexString(((ServerCnxn)watcher).getSessionId()));
                    printWriter.print("\n");
                }
            }
        } else {
            for (Map.Entry<Watcher, Map<String, WatchStats>> entry : this.watch2Paths.entrySet()) {
                printWriter.print("0x");
                printWriter.println(Long.toHexString(((ServerCnxn)entry.getKey()).getSessionId()));
                for (String string : entry.getValue().keySet()) {
                    printWriter.print("\t");
                    printWriter.println(string);
                }
            }
        }
    }

    @Override
    public synchronized boolean containsWatcher(String string, Watcher watcher) {
        return this.containsWatcher(string, watcher, null);
    }

    @Override
    public synchronized boolean containsWatcher(String string, Watcher watcher, WatcherMode watcherMode) {
        Map<String, WatchStats> map = this.watch2Paths.get(watcher);
        if (map == null) {
            return false;
        }
        WatchStats watchStats = map.get(string);
        return watchStats != null && (watcherMode == null || watchStats.hasMode(watcherMode));
    }

    private WatchStats unwatch(String string, Watcher watcher, Map<String, WatchStats> map, Set<Watcher> set) {
        WatchStats watchStats = map.remove(string);
        if (watchStats == null) {
            return WatchStats.NONE;
        }
        if (map.isEmpty()) {
            this.watch2Paths.remove(watcher);
        }
        set.remove(watcher);
        if (set.isEmpty()) {
            this.watchTable.remove(string);
        }
        return watchStats;
    }

    @Override
    public synchronized boolean removeWatcher(String string, Watcher watcher, WatcherMode watcherMode) {
        WatchStats watchStats;
        WatchStats watchStats2;
        Map<String, WatchStats> map = this.watch2Paths.get(watcher);
        Set<Watcher> set = this.watchTable.get(string);
        if (map == null || set == null) {
            return false;
        }
        if (watcherMode != null) {
            watchStats2 = map.getOrDefault(string, WatchStats.NONE);
            watchStats = watchStats2.removeMode(watcherMode);
            if (watchStats != WatchStats.NONE) {
                if (watchStats != watchStats2) {
                    map.put(string, watchStats);
                }
            } else if (watchStats2 != WatchStats.NONE) {
                this.unwatch(string, watcher, map, set);
            }
        } else {
            watchStats2 = this.unwatch(string, watcher, map, set);
            watchStats = WatchStats.NONE;
        }
        if (watchStats2.hasMode(WatcherMode.PERSISTENT_RECURSIVE) && !watchStats.hasMode(WatcherMode.PERSISTENT_RECURSIVE)) {
            --this.recursiveWatchQty;
        }
        return watchStats2 != watchStats;
    }

    @Override
    public synchronized boolean removeWatcher(String string, Watcher watcher) {
        return this.removeWatcher(string, watcher, null);
    }

    Map<Watcher, Map<String, WatchStats>> getWatch2Paths() {
        return this.watch2Paths;
    }

    @Override
    public synchronized WatchesReport getWatches() {
        HashMap<Long, Set<String>> hashMap = new HashMap<Long, Set<String>>();
        for (Map.Entry<Watcher, Map<String, WatchStats>> entry : this.watch2Paths.entrySet()) {
            Long l2 = ((ServerCnxn)entry.getKey()).getSessionId();
            HashSet<String> hashSet = new HashSet<String>(entry.getValue().keySet());
            hashMap.put(l2, hashSet);
        }
        return new WatchesReport(hashMap);
    }

    @Override
    public synchronized WatchesPathReport getWatchesByPath() {
        HashMap<String, Set<Long>> hashMap = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, Set<Watcher>> entry : this.watchTable.entrySet()) {
            HashSet<Long> hashSet = new HashSet<Long>(entry.getValue().size());
            hashMap.put(entry.getKey(), hashSet);
            for (Watcher watcher : entry.getValue()) {
                hashSet.add(((ServerCnxn)watcher).getSessionId());
            }
        }
        return new WatchesPathReport(hashMap);
    }

    @Override
    public synchronized WatchesSummary getWatchesSummary() {
        int n2 = 0;
        for (Map<String, WatchStats> map : this.watch2Paths.values()) {
            n2 += map.size();
        }
        return new WatchesSummary(this.watch2Paths.size(), this.watchTable.size(), n2);
    }

    @Override
    public void shutdown() {
    }

    synchronized int getRecursiveWatchQty() {
        return this.recursiveWatchQty;
    }

    private PathParentIterator getPathParentIterator(String string) {
        if (this.getRecursiveWatchQty() == 0) {
            return PathParentIterator.forPathOnly(string);
        }
        return PathParentIterator.forAll(string);
    }
}

