/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RateLimiter {
    private final int rate;
    private final long intervalInMs;
    private long lastTimeReset;
    private final AtomicInteger remained;

    public RateLimiter(int n2, long l2, TimeUnit timeUnit) {
        this.rate = n2;
        this.intervalInMs = timeUnit.toMillis(l2);
        this.lastTimeReset = Time.currentElapsedTime();
        this.remained = new AtomicInteger(n2);
    }

    public boolean allow() {
        long l2 = Time.currentElapsedTime();
        if (l2 > this.lastTimeReset + this.intervalInMs) {
            this.remained.set(this.rate);
            this.lastTimeReset = l2;
        }
        int n2 = this.remained.get();
        boolean bl2 = false;
        while (!bl2 && n2 > 0) {
            bl2 = this.remained.compareAndSet(n2, n2 - 1);
            n2 = this.remained.get();
        }
        return bl2;
    }
}

