/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.Quotas;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.StatsTrack;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class QuotaMetricsUtils {
    public static final String QUOTA_COUNT_LIMIT_PER_NAMESPACE = "quota_count_limit_per_namespace";
    public static final String QUOTA_BYTES_LIMIT_PER_NAMESPACE = "quota_bytes_limit_per_namespace";
    public static final String QUOTA_COUNT_USAGE_PER_NAMESPACE = "quota_count_usage_per_namespace";
    public static final String QUOTA_BYTES_USAGE_PER_NAMESPACE = "quota_bytes_usage_per_namespace";
    public static final String QUOTA_EXCEEDED_ERROR_PER_NAMESPACE = "quota_exceeded_error_per_namespace";
    static final String LIMIT_END_STRING = "/zookeeper_limits";
    static final String STATS_END_STRING = "/zookeeper_stats";

    private QuotaMetricsUtils() {
    }

    public static Map<String, Number> getQuotaCountLimit(DataTree dataTree) {
        return QuotaMetricsUtils.getQuotaLimitOrUsage(dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_LIMIT);
    }

    public static Map<String, Number> getQuotaBytesLimit(DataTree dataTree) {
        return QuotaMetricsUtils.getQuotaLimitOrUsage(dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT);
    }

    public static Map<String, Number> getQuotaCountUsage(DataTree dataTree) {
        return QuotaMetricsUtils.getQuotaLimitOrUsage(dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_USAGE);
    }

    public static Map<String, Number> getQuotaBytesUsage(DataTree dataTree) {
        return QuotaMetricsUtils.getQuotaLimitOrUsage(dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_USAGE);
    }

    private static Map<String, Number> getQuotaLimitOrUsage(DataTree dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE qUOTA_LIMIT_USAGE_METRIC_TYPE) {
        ConcurrentHashMap<String, Number> concurrentHashMap = new ConcurrentHashMap<String, Number>();
        if (dataTree != null) {
            QuotaMetricsUtils.getQuotaLimitOrUsage("/zookeeper/quota", concurrentHashMap, qUOTA_LIMIT_USAGE_METRIC_TYPE, dataTree);
        }
        return concurrentHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getQuotaLimitOrUsage(String string, Map<String, Number> map, QUOTA_LIMIT_USAGE_METRIC_TYPE qUOTA_LIMIT_USAGE_METRIC_TYPE, DataTree dataTree) {
        String[] stringArray = dataTree.getNode(string);
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            String[] stringArray3 = stringArray.getChildren().toArray(new String[0]);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (stringArray3.length == 0) {
                if (QuotaMetricsUtils.shouldCollect(string, qUOTA_LIMIT_USAGE_METRIC_TYPE)) {
                    QuotaMetricsUtils.collectQuotaLimitOrUsage(string, (DataNode)stringArray, map, qUOTA_LIMIT_USAGE_METRIC_TYPE);
                }
                return;
            }
            for (String string2 : stringArray3) {
                QuotaMetricsUtils.getQuotaLimitOrUsage(string + "/" + string2, map, qUOTA_LIMIT_USAGE_METRIC_TYPE, dataTree);
            }
            return;
        }
    }

    static boolean shouldCollect(String string, QUOTA_LIMIT_USAGE_METRIC_TYPE qUOTA_LIMIT_USAGE_METRIC_TYPE) {
        return string.endsWith(LIMIT_END_STRING) && (QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_LIMIT == qUOTA_LIMIT_USAGE_METRIC_TYPE || QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT == qUOTA_LIMIT_USAGE_METRIC_TYPE) || string.endsWith(STATS_END_STRING) && (QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_USAGE == qUOTA_LIMIT_USAGE_METRIC_TYPE || QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_USAGE == qUOTA_LIMIT_USAGE_METRIC_TYPE);
    }

    static void collectQuotaLimitOrUsage(String string, DataNode dataNode, Map<String, Number> map, QUOTA_LIMIT_USAGE_METRIC_TYPE qUOTA_LIMIT_USAGE_METRIC_TYPE) {
        String string2 = PathUtils.getTopNamespace(Quotas.trimQuotaPath(string));
        if (string2 == null) {
            return;
        }
        byte[] byArray = dataNode.getData();
        if (byArray == null) {
            return;
        }
        StatsTrack statsTrack = new StatsTrack(byArray);
        switch (qUOTA_LIMIT_USAGE_METRIC_TYPE) {
            case QUOTA_COUNT_LIMIT: {
                QuotaMetricsUtils.aggregateQuotaLimitOrUsage(string2, map, QuotaMetricsUtils.getQuotaLimit(statsTrack.getCountHardLimit(), statsTrack.getCount()));
                break;
            }
            case QUOTA_BYTES_LIMIT: {
                QuotaMetricsUtils.aggregateQuotaLimitOrUsage(string2, map, QuotaMetricsUtils.getQuotaLimit(statsTrack.getByteHardLimit(), statsTrack.getBytes()));
                break;
            }
            case QUOTA_COUNT_USAGE: {
                QuotaMetricsUtils.aggregateQuotaLimitOrUsage(string2, map, statsTrack.getCount());
                break;
            }
            case QUOTA_BYTES_USAGE: {
                QuotaMetricsUtils.aggregateQuotaLimitOrUsage(string2, map, statsTrack.getBytes());
                break;
            }
        }
    }

    static long getQuotaLimit(long l2, long l3) {
        return l2 > -1L ? l2 : l3;
    }

    private static void aggregateQuotaLimitOrUsage(String string, Map<String, Number> map, long l2) {
        map.put(string, map.getOrDefault(string, 0).longValue() + l2);
    }

    static enum QUOTA_LIMIT_USAGE_METRIC_TYPE {
        QUOTA_COUNT_LIMIT,
        QUOTA_BYTES_LIMIT,
        QUOTA_COUNT_USAGE,
        QUOTA_BYTES_USAGE;

    }
}

