/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class JvmPauseMonitor {
    private static final foe LOG = goe.a(JvmPauseMonitor.class);
    public static final String JVM_PAUSE_MONITOR_FEATURE_SWITCH_KEY = "jvm.pause.monitor";
    protected long sleepTimeMs;
    public static final String SLEEP_TIME_MS_KEY = "jvm.pause.sleep.time.ms";
    public static final long SLEEP_TIME_MS_DEFAULT = 500L;
    protected long warnThresholdMs;
    public static final String WARN_THRESHOLD_KEY = "jvm.pause.warn-threshold.ms";
    public static final long WARN_THRESHOLD_DEFAULT = 10000L;
    protected long infoThresholdMs;
    public static final String INFO_THRESHOLD_KEY = "jvm.pause.info-threshold.ms";
    public static final long INFO_THRESHOLD_DEFAULT = 1000L;
    private long numGcWarnThresholdExceeded = 0L;
    private long numGcInfoThresholdExceeded = 0L;
    private long totalGcExtraSleepTime = 0L;
    private Thread monitorThread;
    private volatile boolean shouldRun = true;

    public JvmPauseMonitor(QuorumPeerConfig quorumPeerConfig) {
        this.warnThresholdMs = quorumPeerConfig.getJvmPauseWarnThresholdMs();
        this.infoThresholdMs = quorumPeerConfig.getJvmPauseInfoThresholdMs();
        this.sleepTimeMs = quorumPeerConfig.getJvmPauseSleepTimeMs();
    }

    public JvmPauseMonitor(ServerConfig serverConfig) {
        this.warnThresholdMs = serverConfig.getJvmPauseWarnThresholdMs();
        this.infoThresholdMs = serverConfig.getJvmPauseInfoThresholdMs();
        this.sleepTimeMs = serverConfig.getJvmPauseSleepTimeMs();
    }

    public void serviceStart() {
        this.monitorThread = new Thread(new JVMMonitor());
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    public void serviceStop() {
        this.shouldRun = false;
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
            try {
                this.monitorThread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isStarted() {
        return this.monitorThread != null;
    }

    public long getNumGcWarnThresholdExceeded() {
        return this.numGcWarnThresholdExceeded;
    }

    public long getNumGcInfoThresholdExceeded() {
        return this.numGcInfoThresholdExceeded;
    }

    public long getTotalGcExtraSleepTime() {
        return this.totalGcExtraSleepTime;
    }

    private String formatMessage(long l2, Map<String, GcTimes> map, Map<String, GcTimes> map2) {
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        hashSet.retainAll(map2.keySet());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : hashSet) {
            GcTimes gcTimes = map.get(string).subtract(map2.get(string));
            if (gcTimes.gcCount == 0L) continue;
            arrayList.add("GC pool '" + string + "' had collection(s): " + gcTimes.toString());
        }
        Object object = String.format("Detected pause in JVM or host machine (eg GC): pause of approximately %d ms, total pause: info level: %d, warn level: %d %n", l2, this.numGcInfoThresholdExceeded, this.numGcWarnThresholdExceeded);
        object = arrayList.isEmpty() ? (String)object + "No GCs detected" : (String)object + String.join((CharSequence)"\n", arrayList);
        return object;
    }

    private Map<String, GcTimes> getGcTimes() {
        HashMap<String, GcTimes> hashMap = new HashMap<String, GcTimes>();
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : list) {
            hashMap.put(garbageCollectorMXBean.getName(), new GcTimes(garbageCollectorMXBean));
        }
        return hashMap;
    }

    class JVMMonitor
    implements Runnable {
        private JVMMonitor() {
        }

        @Override
        public void run() {
            Map map = JvmPauseMonitor.this.getGcTimes();
            LOG.c("Starting JVM Pause Monitor with infoThresholdMs:{} warnThresholdMs:{} and sleepTimeMs:{}", JvmPauseMonitor.this.infoThresholdMs, JvmPauseMonitor.this.warnThresholdMs, JvmPauseMonitor.this.sleepTimeMs);
            while (JvmPauseMonitor.this.shouldRun) {
                long l2 = Instant.now().toEpochMilli();
                try {
                    Thread.sleep(JvmPauseMonitor.this.sleepTimeMs);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                long l3 = Instant.now().toEpochMilli();
                long l4 = l3 - l2 - JvmPauseMonitor.this.sleepTimeMs;
                if (l4 >= 0L) {
                    ServerMetrics.getMetrics().JVM_PAUSE_TIME.add(l4);
                }
                Map map2 = JvmPauseMonitor.this.getGcTimes();
                if (l4 > JvmPauseMonitor.this.warnThresholdMs) {
                    ++JvmPauseMonitor.this.numGcWarnThresholdExceeded;
                    LOG.d(JvmPauseMonitor.this.formatMessage(l4, map2, map));
                } else if (l4 > JvmPauseMonitor.this.infoThresholdMs) {
                    ++JvmPauseMonitor.this.numGcInfoThresholdExceeded;
                    LOG.c(JvmPauseMonitor.this.formatMessage(l4, map2, map));
                }
                JvmPauseMonitor.this.totalGcExtraSleepTime += l4;
                map = map2;
            }
        }
    }

    static class GcTimes {
        private long gcCount;
        private long gcTimeMillis;

        private GcTimes(GarbageCollectorMXBean garbageCollectorMXBean) {
            this.gcCount = garbageCollectorMXBean.getCollectionCount();
            this.gcTimeMillis = garbageCollectorMXBean.getCollectionTime();
        }

        private GcTimes(long l2, long l3) {
            this.gcCount = l2;
            this.gcTimeMillis = l3;
        }

        private GcTimes subtract(GcTimes gcTimes) {
            return new GcTimes(this.gcCount - gcTimes.gcCount, this.gcTimeMillis - gcTimes.gcTimeMillis);
        }

        public String toString() {
            return "count=" + this.gcCount + " time=" + this.gcTimeMillis + "ms";
        }
    }
}

