/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util;

import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicInteger;

public class CircularBuffer<T> {
    private final T[] buffer;
    private final int capacity;
    private int oldest;
    private AtomicInteger numberOfElements = new AtomicInteger();

    public CircularBuffer(Class<T> clazz, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("CircularBuffer capacity should be greater than 0");
        }
        this.buffer = (Object[])Array.newInstance(clazz, n2);
        this.capacity = n2;
    }

    public synchronized void write(T t2) {
        int n2 = this.numberOfElements.incrementAndGet();
        if (n2 > this.capacity) {
            this.buffer[this.oldest] = t2;
            ++this.oldest;
            this.oldest %= this.capacity;
            this.numberOfElements.decrementAndGet();
        } else {
            int n3 = (this.oldest + this.numberOfElements.get() - 1) % this.capacity;
            this.buffer[n3] = t2;
        }
    }

    public synchronized T take() {
        int n2 = this.numberOfElements.decrementAndGet();
        if (n2 < 0) {
            this.numberOfElements.incrementAndGet();
            return null;
        }
        T t2 = this.buffer[this.oldest];
        ++this.oldest;
        this.oldest %= this.capacity;
        return t2;
    }

    public synchronized T peek() {
        if (this.numberOfElements.get() <= 0) {
            return null;
        }
        return this.buffer[this.oldest];
    }

    public int size() {
        return this.numberOfElements.get();
    }

    public boolean isEmpty() {
        return this.numberOfElements.get() <= 0;
    }

    public boolean isFull() {
        return this.numberOfElements.get() >= this.capacity;
    }

    public synchronized void reset() {
        this.numberOfElements.set(0);
    }
}

