/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BitHashSet
implements Iterable<Integer> {
    private final BitSet elementBits = new BitSet();
    private final Set<Integer> cache = new HashSet<Integer>();
    private final int cacheSize;
    private int elementCount = 0;

    public BitHashSet() {
        this(Integer.getInteger("zookeeper.bitHashCacheSize", 10));
    }

    public BitHashSet(int n2) {
        this.cacheSize = n2;
    }

    public synchronized boolean add(Integer n2) {
        if (n2 == null || this.elementBits.get(n2)) {
            return false;
        }
        if (this.cache.size() < this.cacheSize) {
            this.cache.add(n2);
        }
        this.elementBits.set(n2);
        ++this.elementCount;
        return true;
    }

    public synchronized int remove(Set<Integer> set, BitSet bitSet) {
        this.cache.removeAll(set);
        this.elementBits.andNot(bitSet);
        int n2 = this.elementCount;
        this.elementCount = this.elementBits.cardinality();
        return n2 - this.elementCount;
    }

    public synchronized boolean remove(Integer n2) {
        if (n2 == null || !this.elementBits.get(n2)) {
            return false;
        }
        this.cache.remove(n2);
        this.elementBits.clear(n2);
        --this.elementCount;
        return true;
    }

    public synchronized boolean contains(Integer n2) {
        if (n2 == null) {
            return false;
        }
        return this.elementBits.get(n2);
    }

    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public Iterator<Integer> iterator() {
        final int n2 = this.size();
        if (this.cache.size() == n2) {
            return this.cache.iterator();
        }
        return new Iterator<Integer>(){
            int returnedCount = 0;
            int bitIndex = 0;

            @Override
            public boolean hasNext() {
                return this.returnedCount < n2;
            }

            @Override
            public Integer next() {
                int n22 = BitHashSet.this.elementBits.nextSetBit(this.bitIndex);
                this.bitIndex = n22 + 1;
                ++this.returnedCount;
                return n22;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized int cachedSize() {
        return this.cache.size();
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }
}

