/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class QuorumMaj
implements QuorumVerifier {
    private static final foe LOG = goe.a(QuorumMaj.class);
    private Map<Long, QuorumPeer.QuorumServer> allMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> votingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> observingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private long version = 0L;
    protected int half;

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof QuorumMaj)) {
            return false;
        }
        QuorumMaj quorumMaj = (QuorumMaj)object;
        if (quorumMaj.getVersion() == this.version) {
            return true;
        }
        if (this.allMembers.size() != quorumMaj.getAllMembers().size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer quorumServer : this.allMembers.values()) {
            QuorumPeer.QuorumServer quorumServer2 = quorumMaj.getAllMembers().get(quorumServer.id);
            if (quorumServer2 != null && quorumServer.equals(quorumServer2)) continue;
            return false;
        }
        return true;
    }

    public QuorumMaj(Map<Long, QuorumPeer.QuorumServer> map) {
        this.allMembers = map;
        for (QuorumPeer.QuorumServer quorumServer : map.values()) {
            if (quorumServer.type == QuorumPeer.LearnerType.PARTICIPANT) {
                this.votingMembers.put(quorumServer.id, quorumServer);
                continue;
            }
            this.observingMembers.put(quorumServer.id, quorumServer);
        }
        this.half = this.votingMembers.size() / 2;
    }

    public QuorumMaj(Properties properties) throws QuorumPeerConfig.ConfigException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            if (string.startsWith("server.")) {
                int n2 = string.indexOf(46);
                long l2 = Long.parseLong(string.substring(n2 + 1));
                QuorumPeer.QuorumServer quorumServer = new QuorumPeer.QuorumServer(l2, string2);
                this.allMembers.put(l2, quorumServer);
                if (quorumServer.type == QuorumPeer.LearnerType.PARTICIPANT) {
                    this.votingMembers.put(l2, quorumServer);
                    continue;
                }
                this.observingMembers.put(l2, quorumServer);
                continue;
            }
            if (!string.equals("version")) continue;
            this.version = Long.parseLong(string2, 16);
        }
        this.half = this.votingMembers.size() / 2;
    }

    @Override
    public long getWeight(long l2) {
        return 1L;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (QuorumPeer.QuorumServer quorumServer : this.getAllMembers().values()) {
            String string = "server." + quorumServer.id;
            String string2 = quorumServer.toString();
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
            stringBuilder.append('\n');
        }
        String string = Long.toHexString(this.version);
        stringBuilder.append("version=");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public boolean containsQuorum(Set<Long> set) {
        return set.size() > this.half;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getAllMembers() {
        return this.allMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getVotingMembers() {
        return this.votingMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getObservingMembers() {
        return this.observingMembers;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long l2) {
        this.version = l2;
    }
}

