/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class QuorumHierarchical
implements QuorumVerifier {
    private static final foe LOG = goe.a(QuorumHierarchical.class);
    private HashMap<Long, Long> serverWeight = new HashMap();
    private HashMap<Long, Long> serverGroup = new HashMap();
    private HashMap<Long, Long> groupWeight = new HashMap();
    private int numGroups = 0;
    private Map<Long, QuorumPeer.QuorumServer> allMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> participatingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> observingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private long version = 0L;

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof QuorumHierarchical)) {
            return false;
        }
        QuorumHierarchical quorumHierarchical = (QuorumHierarchical)object;
        if (quorumHierarchical.getVersion() == this.version) {
            return true;
        }
        if (this.allMembers.size() != quorumHierarchical.getAllMembers().size() || this.serverWeight.size() != quorumHierarchical.serverWeight.size() || this.groupWeight.size() != quorumHierarchical.groupWeight.size() || this.serverGroup.size() != quorumHierarchical.serverGroup.size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer object2 : this.allMembers.values()) {
            QuorumPeer.QuorumServer quorumServer = quorumHierarchical.getAllMembers().get(object2.id);
            if (quorumServer != null && object2.equals(quorumServer)) continue;
            return false;
        }
        for (Map.Entry entry : this.serverWeight.entrySet()) {
            if (((Long)entry.getValue()).equals(quorumHierarchical.serverWeight.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry entry : this.groupWeight.entrySet()) {
            if (((Long)entry.getValue()).equals(quorumHierarchical.groupWeight.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry entry : this.serverGroup.entrySet()) {
            if (((Long)entry.getValue()).equals(quorumHierarchical.serverGroup.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public QuorumHierarchical(String string) throws QuorumPeerConfig.ConfigException {
        this.readConfigFile(string);
    }

    public QuorumHierarchical(Properties properties) throws QuorumPeerConfig.ConfigException {
        this.parse(properties);
        LOG.c("{}, {}, {}", this.serverWeight.size(), this.serverGroup.size(), this.groupWeight.size());
    }

    @Override
    public long getWeight(long l2) {
        return this.serverWeight.get(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(String string) throws QuorumPeerConfig.ConfigException {
        File file = new File(string);
        LOG.c("Reading configuration from: {}", (Object)file);
        try {
            if (!file.exists()) {
                throw new IllegalArgumentException(file.toString() + " file is missing");
            }
            Properties properties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
            }
            this.parse(properties);
        }
        catch (IOException iOException) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + string, iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + string, illegalArgumentException);
        }
    }

    private void parse(Properties properties) throws QuorumPeerConfig.ConfigException {
        Object object;
        for (Map.Entry<Object, Object> object2 : properties.entrySet()) {
            String[] stringArray;
            long l2;
            int n2;
            object = object2.getKey().toString();
            String string = object2.getValue().toString();
            if (((String)object).startsWith("server.")) {
                n2 = ((String)object).indexOf(46);
                l2 = Long.parseLong(((String)object).substring(n2 + 1));
                stringArray = new QuorumPeer.QuorumServer(l2, string);
                this.allMembers.put(l2, (QuorumPeer.QuorumServer)stringArray);
                if (stringArray.type == QuorumPeer.LearnerType.PARTICIPANT) {
                    this.participatingMembers.put(l2, (QuorumPeer.QuorumServer)stringArray);
                    continue;
                }
                this.observingMembers.put(l2, (QuorumPeer.QuorumServer)stringArray);
                continue;
            }
            if (((String)object).startsWith("group")) {
                n2 = ((String)object).indexOf(46);
                l2 = Long.parseLong(((String)object).substring(n2 + 1));
                ++this.numGroups;
                for (String string2 : stringArray = string.split(":")) {
                    long l3 = Long.parseLong(string2);
                    if (this.serverGroup.containsKey(l3)) {
                        throw new QuorumPeerConfig.ConfigException("Server " + l3 + "is in multiple groups");
                    }
                    this.serverGroup.put(l3, l2);
                }
                continue;
            }
            if (((String)object).startsWith("weight")) {
                n2 = ((String)object).indexOf(46);
                l2 = Long.parseLong(((String)object).substring(n2 + 1));
                this.serverWeight.put(l2, Long.parseLong(string));
                continue;
            }
            if (!((String)object).equals("version")) continue;
            this.version = Long.parseLong(string, 16);
        }
        for (QuorumPeer.QuorumServer quorumServer : this.allMembers.values()) {
            object = quorumServer.id;
            if (quorumServer.type != QuorumPeer.LearnerType.PARTICIPANT) continue;
            if (!this.serverGroup.containsKey(object)) {
                throw new QuorumPeerConfig.ConfigException("Server " + object + "is not in a group");
            }
            if (this.serverWeight.containsKey(object)) continue;
            this.serverWeight.put((Long)object, 1L);
        }
        this.computeGroupWeight();
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getAllMembers() {
        return this.allMembers;
    }

    @Override
    public String toString() {
        String string;
        Object object;
        Object object2;
        StringWriter stringWriter = new StringWriter();
        for (QuorumPeer.QuorumServer iterator : this.getAllMembers().values()) {
            String string2 = "server." + iterator.id;
            object2 = iterator.toString();
            stringWriter.append(string2);
            stringWriter.append('=');
            stringWriter.append((CharSequence)object2);
            stringWriter.append('\n');
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            object2 = entry.getKey();
            object = entry.getValue();
            string = (String)hashMap.get(object);
            string = string == null ? ((Long)object2).toString() : string.concat(":").concat(((Long)object2).toString());
            hashMap.put(object, string);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Long)entry.getKey();
            object = "group." + ((Long)object2).toString();
            string = (String)entry.getValue();
            stringWriter.append((CharSequence)object);
            stringWriter.append('=');
            stringWriter.append(string);
            stringWriter.append('\n');
        }
        for (Map.Entry<Long, Long> entry : this.serverWeight.entrySet()) {
            object2 = entry.getKey();
            object = "weight." + ((Long)object2).toString();
            string = entry.getValue().toString();
            stringWriter.append((CharSequence)object);
            stringWriter.append('=');
            stringWriter.append(string);
            stringWriter.append('\n');
        }
        stringWriter.append("version=" + Long.toHexString(this.version));
        return stringWriter.toString();
    }

    private void computeGroupWeight() {
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            Long l2 = entry.getKey();
            Long l3 = entry.getValue();
            if (!this.groupWeight.containsKey(l3)) {
                this.groupWeight.put(l3, this.serverWeight.get(l2));
                continue;
            }
            long l4 = this.serverWeight.get(l2) + this.groupWeight.get(l3);
            this.groupWeight.put(l3, l4);
        }
        Iterator<Object> iterator = this.groupWeight.values().iterator();
        while (iterator.hasNext()) {
            long l5 = (Long)iterator.next();
            LOG.b("Group weight: {}", (Object)l5);
            if (l5 != 0L) continue;
            --this.numGroups;
            LOG.b("One zero-weight group: 1, {}", (Object)this.numGroups);
        }
    }

    @Override
    public boolean containsQuorum(Set<Long> set) {
        Long l2;
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        LOG.b("Set size: {}", (Object)set.size());
        if (set.size() == 0) {
            return false;
        }
        for (long l3 : set) {
            l2 = this.serverGroup.get(l3);
            if (l2 == null) continue;
            if (!hashMap.containsKey(l2)) {
                hashMap.put(l2, this.serverWeight.get(l3));
                continue;
            }
            long l4 = this.serverWeight.get(l3) + (Long)hashMap.get(l2);
            hashMap.put(l2, l4);
        }
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            l2 = (Long)entry.getKey();
            LOG.b("Group info: {}, {}, {}", entry.getValue(), l2, this.groupWeight.get(l2));
            if ((Long)entry.getValue() <= this.groupWeight.get(l2) / 2L) continue;
            ++n2;
        }
        LOG.b("Majority group counter: {}, {}", (Object)n2, (Object)this.numGroups);
        if (n2 > this.numGroups / 2) {
            LOG.b("Positive set size: {}", (Object)set.size());
            return true;
        }
        LOG.b("Negative set size: {}", (Object)set.size());
        return false;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getVotingMembers() {
        return this.participatingMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getObservingMembers() {
        return this.observingMembers;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long l2) {
        this.version = l2;
    }
}

