/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Exception;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.PrependableSocket;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLSocket;

public class UnifiedServerSocket
extends ServerSocket {
    private static final foe LOG = goe.a(UnifiedServerSocket.class);
    private X509Util x509Util;
    private final boolean allowInsecureConnection;

    public UnifiedServerSocket(X509Util x509Util, boolean bl2) throws IOException {
        this.x509Util = x509Util;
        this.allowInsecureConnection = bl2;
    }

    public UnifiedServerSocket(X509Util x509Util, boolean bl2, int n2) throws IOException {
        super(n2);
        this.x509Util = x509Util;
        this.allowInsecureConnection = bl2;
    }

    public UnifiedServerSocket(X509Util x509Util, boolean bl2, int n2, int n3) throws IOException {
        super(n2, n3);
        this.x509Util = x509Util;
        this.allowInsecureConnection = bl2;
    }

    public UnifiedServerSocket(X509Util x509Util, boolean bl2, int n2, int n3, InetAddress inetAddress) throws IOException {
        super(n2, n3, inetAddress);
        this.x509Util = x509Util;
        this.allowInsecureConnection = bl2;
    }

    @Override
    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        PrependableSocket prependableSocket = new PrependableSocket(null);
        this.implAccept(prependableSocket);
        return new UnifiedSocket(this.x509Util, this.allowInsecureConnection, prependableSocket);
    }

    static class UnifiedOutputStream
    extends OutputStream {
        private final UnifiedSocket unifiedSocket;
        private OutputStream realOutputStream;

        private UnifiedOutputStream(UnifiedSocket unifiedSocket) {
            this.unifiedSocket = unifiedSocket;
            this.realOutputStream = null;
        }

        @Override
        public void write(int n2) throws IOException {
            this.getRealOutputStream().write(n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.getRealOutputStream().write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.getRealOutputStream().write(byArray, n2, n3);
        }

        @Override
        public void flush() throws IOException {
            this.getRealOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
            this.getRealOutputStream().close();
        }

        private OutputStream getRealOutputStream() throws IOException {
            if (this.realOutputStream == null) {
                this.realOutputStream = this.unifiedSocket.getSocket().getOutputStream();
            }
            return this.realOutputStream;
        }
    }

    static class UnifiedInputStream
    extends InputStream {
        private final UnifiedSocket unifiedSocket;
        private InputStream realInputStream;

        private UnifiedInputStream(UnifiedSocket unifiedSocket) {
            this.unifiedSocket = unifiedSocket;
            this.realInputStream = null;
        }

        @Override
        public int read() throws IOException {
            return this.getRealInputStream().read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.getRealInputStream().read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.getRealInputStream().read(byArray, n2, n3);
        }

        private InputStream getRealInputStream() throws IOException {
            if (this.realInputStream == null) {
                this.realInputStream = this.unifiedSocket.getSocket().getInputStream();
            }
            return this.realInputStream;
        }

        @Override
        public long skip(long l2) throws IOException {
            return this.getRealInputStream().skip(l2);
        }

        @Override
        public int available() throws IOException {
            return this.getRealInputStream().available();
        }

        @Override
        public void close() throws IOException {
            this.getRealInputStream().close();
        }

        @Override
        public synchronized void mark(int n2) {
            try {
                this.getRealInputStream().mark(n2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            this.getRealInputStream().reset();
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getRealInputStream().markSupported();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static class UnifiedSocket
    extends Socket {
        private final X509Util x509Util;
        private final boolean allowInsecureConnection;
        private PrependableSocket prependableSocket;
        private SSLSocket sslSocket;
        private Mode mode;

        private UnifiedSocket(X509Util x509Util, boolean bl2, PrependableSocket prependableSocket) {
            this.x509Util = x509Util;
            this.allowInsecureConnection = bl2;
            this.prependableSocket = prependableSocket;
            this.sslSocket = null;
            this.mode = Mode.UNKNOWN;
        }

        public boolean isSecureSocket() {
            return this.mode == Mode.TLS;
        }

        public boolean isPlaintextSocket() {
            return this.mode == Mode.PLAINTEXT;
        }

        public boolean isModeKnown() {
            return this.mode != Mode.UNKNOWN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void detectMode() throws IOException {
            byte[] byArray = new byte[5];
            int n2 = -1;
            int n3 = 0;
            int n4 = this.x509Util.getSslHandshakeTimeoutMillis();
            try {
                n2 = this.prependableSocket.getSoTimeout();
                this.prependableSocket.setSoTimeout(n4);
                n3 = this.prependableSocket.getInputStream().read(byArray, 0, byArray.length);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                LOG.d("Socket mode detection timed out after {} ms, assuming PLAINTEXT", (Object)n4);
            }
            finally {
                try {
                    if (n2 != -1) {
                        this.prependableSocket.setSoTimeout(n2);
                    }
                }
                catch (Exception exception) {
                    LOG.d("Failed to restore old socket timeout value of {} ms", (Object)n2, (Object)exception);
                }
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 == byArray.length && SslHandler.isEncrypted(Unpooled.wrappedBuffer((byte[])byArray))) {
                try {
                    this.sslSocket = this.x509Util.createSSLSocket(this.prependableSocket, byArray);
                }
                catch (X509Exception x509Exception) {
                    throw new IOException("failed to create SSL context", x509Exception);
                }
                this.prependableSocket = null;
                this.mode = Mode.TLS;
                LOG.c("Accepted TLS connection from {} - {} - {}", this.sslSocket.getRemoteSocketAddress(), this.sslSocket.getSession().getProtocol(), this.sslSocket.getSession().getCipherSuite());
            } else if (this.allowInsecureConnection) {
                this.prependableSocket.prependToInputStream(byArray, 0, n3);
                this.mode = Mode.PLAINTEXT;
                LOG.c("Accepted plaintext connection from {}", (Object)this.prependableSocket.getRemoteSocketAddress());
            } else {
                this.prependableSocket.close();
                this.mode = Mode.PLAINTEXT;
                throw new IOException("Blocked insecure connection attempt");
            }
        }

        private Socket getSocketAllowUnknownMode() {
            if (this.isSecureSocket()) {
                return this.sslSocket;
            }
            return this.prependableSocket;
        }

        private Socket getSocket() throws IOException {
            if (!this.isModeKnown()) {
                this.detectMode();
            }
            if (this.mode == Mode.TLS) {
                return this.sslSocket;
            }
            return this.prependableSocket;
        }

        public SSLSocket getSslSocket() throws IOException {
            if (!this.isModeKnown()) {
                this.detectMode();
            }
            if (!this.isSecureSocket()) {
                throw new SocketException("Socket mode is not TLS");
            }
            return this.sslSocket;
        }

        @Override
        public void connect(SocketAddress socketAddress) throws IOException {
            this.getSocketAllowUnknownMode().connect(socketAddress);
        }

        @Override
        public void connect(SocketAddress socketAddress, int n2) throws IOException {
            this.getSocketAllowUnknownMode().connect(socketAddress, n2);
        }

        @Override
        public void bind(SocketAddress socketAddress) throws IOException {
            this.getSocketAllowUnknownMode().bind(socketAddress);
        }

        @Override
        public InetAddress getInetAddress() {
            return this.getSocketAllowUnknownMode().getInetAddress();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.getSocketAllowUnknownMode().getLocalAddress();
        }

        @Override
        public int getPort() {
            return this.getSocketAllowUnknownMode().getPort();
        }

        @Override
        public int getLocalPort() {
            return this.getSocketAllowUnknownMode().getLocalPort();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.getSocketAllowUnknownMode().getRemoteSocketAddress();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.getSocketAllowUnknownMode().getLocalSocketAddress();
        }

        @Override
        public SocketChannel getChannel() {
            return this.getSocketAllowUnknownMode().getChannel();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new UnifiedInputStream(this);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new UnifiedOutputStream(this);
        }

        @Override
        public void setTcpNoDelay(boolean bl2) throws SocketException {
            this.getSocketAllowUnknownMode().setTcpNoDelay(bl2);
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.getSocketAllowUnknownMode().getTcpNoDelay();
        }

        @Override
        public void setSoLinger(boolean bl2, int n2) throws SocketException {
            this.getSocketAllowUnknownMode().setSoLinger(bl2, n2);
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.getSocketAllowUnknownMode().getSoLinger();
        }

        @Override
        public void sendUrgentData(int n2) throws IOException {
            this.getSocket().sendUrgentData(n2);
        }

        @Override
        public void setOOBInline(boolean bl2) throws SocketException {
            this.getSocketAllowUnknownMode().setOOBInline(bl2);
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.getSocketAllowUnknownMode().getOOBInline();
        }

        @Override
        public synchronized void setSoTimeout(int n2) throws SocketException {
            this.getSocketAllowUnknownMode().setSoTimeout(n2);
        }

        @Override
        public synchronized int getSoTimeout() throws SocketException {
            return this.getSocketAllowUnknownMode().getSoTimeout();
        }

        @Override
        public synchronized void setSendBufferSize(int n2) throws SocketException {
            this.getSocketAllowUnknownMode().setSendBufferSize(n2);
        }

        @Override
        public synchronized int getSendBufferSize() throws SocketException {
            return this.getSocketAllowUnknownMode().getSendBufferSize();
        }

        @Override
        public synchronized void setReceiveBufferSize(int n2) throws SocketException {
            this.getSocketAllowUnknownMode().setReceiveBufferSize(n2);
        }

        @Override
        public synchronized int getReceiveBufferSize() throws SocketException {
            return this.getSocketAllowUnknownMode().getReceiveBufferSize();
        }

        @Override
        public void setKeepAlive(boolean bl2) throws SocketException {
            this.getSocketAllowUnknownMode().setKeepAlive(bl2);
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.getSocketAllowUnknownMode().getKeepAlive();
        }

        @Override
        public void setTrafficClass(int n2) throws SocketException {
            this.getSocketAllowUnknownMode().setTrafficClass(n2);
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.getSocketAllowUnknownMode().getTrafficClass();
        }

        @Override
        public void setReuseAddress(boolean bl2) throws SocketException {
            this.getSocketAllowUnknownMode().setReuseAddress(bl2);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.getSocketAllowUnknownMode().getReuseAddress();
        }

        @Override
        public synchronized void close() throws IOException {
            this.getSocketAllowUnknownMode().close();
        }

        @Override
        public void shutdownInput() throws IOException {
            this.getSocketAllowUnknownMode().shutdownInput();
        }

        @Override
        public void shutdownOutput() throws IOException {
            this.getSocketAllowUnknownMode().shutdownOutput();
        }

        @Override
        public String toString() {
            return "UnifiedSocket[mode=" + this.mode.toString() + "socket=" + this.getSocketAllowUnknownMode().toString() + "]";
        }

        @Override
        public boolean isConnected() {
            return this.getSocketAllowUnknownMode().isConnected();
        }

        @Override
        public boolean isBound() {
            return this.getSocketAllowUnknownMode().isBound();
        }

        @Override
        public boolean isClosed() {
            return this.getSocketAllowUnknownMode().isClosed();
        }

        @Override
        public boolean isInputShutdown() {
            return this.getSocketAllowUnknownMode().isInputShutdown();
        }

        @Override
        public boolean isOutputShutdown() {
            return this.getSocketAllowUnknownMode().isOutputShutdown();
        }

        @Override
        public void setPerformancePreferences(int n2, int n3, int n4) {
            this.getSocketAllowUnknownMode().setPerformancePreferences(n2, n3, n4);
        }

        static enum Mode {
            UNKNOWN,
            PLAINTEXT,
            TLS;

        }
    }
}

