/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ReplyHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class ReadOnlyRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final foe LOG = goe.a(ReadOnlyRequestProcessor.class);
    private final LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    private volatile boolean finished = false;
    private final RequestProcessor nextProcessor;
    private final ZooKeeperServer zks;

    public ReadOnlyRequestProcessor(ZooKeeperServer zooKeeperServer, RequestProcessor requestProcessor) {
        super("ReadOnlyRequestProcessor:" + zooKeeperServer.getServerId(), zooKeeperServer.getZooKeeperServerListener());
        this.zks = zooKeeperServer;
        this.nextProcessor = requestProcessor;
    }

    @Override
    public void run() {
        try {
            block6: while (!this.finished) {
                Request request = this.queuedRequests.take();
                if (LOG.b()) {
                    long l2 = 2L;
                    if (request.type == 11) {
                        l2 = 8L;
                    }
                    ZooTrace.logRequest(LOG, l2, 'R', request, "");
                }
                if (Request.requestOfDeath != request) {
                    switch (request.type) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 9: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 19: 
                        case 20: 
                        case 21: {
                            this.sendErrorResponse(request);
                            continue block6;
                        }
                        case -11: 
                        case -10: {
                            if (request.isLocalSession()) break;
                            this.sendErrorResponse(request);
                            continue block6;
                        }
                    }
                    if (this.nextProcessor == null) continue;
                    this.nextProcessor.processRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.handleException(this.getName(), exception);
        }
        LOG.c("ReadOnlyRequestProcessor exited loop!");
    }

    private void sendErrorResponse(Request request) {
        ReplyHeader replyHeader = new ReplyHeader(request.cxid, this.zks.getZKDatabase().getDataTreeLastProcessedZxid(), KeeperException.Code.NOTREADONLY.intValue());
        try {
            request.cnxn.sendResponse(replyHeader, null, null);
        }
        catch (IOException iOException) {
            LOG.d("IO exception while sending response", iOException);
        }
    }

    @Override
    public void processRequest(Request request) {
        if (!this.finished) {
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

