/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

public class QuorumStats {
    private final Provider provider;

    protected QuorumStats(Provider provider) {
        this.provider = provider;
    }

    public String getServerState() {
        return this.provider.getServerState();
    }

    public String[] getQuorumPeers() {
        return this.provider.getQuorumPeers();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        String string = this.getServerState();
        if (string.equals("leading")) {
            stringBuilder.append("Followers:");
            for (String string2 : this.getQuorumPeers()) {
                stringBuilder.append(" ").append(string2);
            }
            stringBuilder.append("\n");
        } else if (string.equals("following") || string.equals("observing")) {
            stringBuilder.append("Leader: ");
            String[] stringArray = this.getQuorumPeers();
            if (stringArray.length > 0) {
                stringBuilder.append(stringArray[0]);
            } else {
                stringBuilder.append("not connected");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static interface Provider {
        public static final String UNKNOWN_STATE = "unknown";
        public static final String LOOKING_STATE = "leaderelection";
        public static final String LEADING_STATE = "leading";
        public static final String FOLLOWING_STATE = "following";
        public static final String OBSERVING_STATE = "observing";

        public String[] getQuorumPeers();

        public String getServerState();
    }
}

