/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.hoe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.AtomicFileWritingIdiom;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ClientX509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.NetUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.StringUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.impl.DefaultMetricsProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.MultipleAddresses;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumOracleMaj;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.VerifyingFileFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class QuorumPeerConfig {
    private static final foe LOG = goe.a(QuorumPeerConfig.class);
    private static final int UNSET_SERVERID = -1;
    public static final String nextDynamicConfigFileSuffix = ".dynamic.next";
    private static boolean standaloneEnabled = true;
    private static boolean reconfigEnabled = false;
    public InetSocketAddress clientPortAddress;
    protected InetSocketAddress secureClientPortAddress;
    protected boolean sslQuorum = false;
    protected boolean shouldUsePortUnification = false;
    protected int observerMasterPort;
    protected boolean sslQuorumReloadCertFiles = false;
    public File dataDir;
    public File dataLogDir;
    protected String dynamicConfigFileStr = null;
    protected String configFileStr = null;
    protected int tickTime = 3000;
    protected int maxClientCnxns = 60;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected String metricsProviderClassName = DefaultMetricsProvider.class.getName();
    protected Properties metricsProviderConfiguration = new Properties();
    protected boolean localSessionsEnabled = false;
    protected boolean localSessionsUpgradingEnabled = false;
    protected int clientPortListenBacklog = -1;
    protected int initLimit;
    protected int syncLimit;
    protected int connectToLearnerMasterLimit;
    protected int electionAlg = 3;
    protected int electionPort = 2182;
    protected boolean quorumListenOnAllIPs = false;
    public long serverId = -1L;
    public QuorumVerifier quorumVerifier = null;
    protected QuorumVerifier lastSeenQuorumVerifier = null;
    protected int snapRetainCount = 3;
    protected int purgeInterval = 0;
    protected boolean syncEnabled = true;
    protected String initialConfig;
    protected QuorumPeer.LearnerType peerType = QuorumPeer.LearnerType.PARTICIPANT;
    protected boolean quorumServerRequireSasl = false;
    protected boolean quorumLearnerRequireSasl = false;
    protected boolean quorumEnableSasl = false;
    protected String quorumServicePrincipal = "zkquorum/localhost";
    protected String quorumLearnerLoginContext = "QuorumLearner";
    protected String quorumServerLoginContext = "QuorumServer";
    protected int quorumCnxnThreadsSize;
    private boolean multiAddressEnabled = Boolean.parseBoolean(System.getProperty("zookeeper.multiAddress.enabled", "false"));
    private boolean multiAddressReachabilityCheckEnabled = Boolean.parseBoolean(System.getProperty("zookeeper.multiAddress.reachabilityCheckEnabled", "true"));
    private int multiAddressReachabilityCheckTimeoutMs = Integer.parseInt(System.getProperty("zookeeper.multiAddress.reachabilityCheckTimeoutMs", String.valueOf(MultipleAddresses.DEFAULT_TIMEOUT.toMillis())));
    protected String oraclePath;
    private final int MIN_SNAP_RETAIN_COUNT = 3;
    protected boolean jvmPauseMonitorToRun = false;
    protected long jvmPauseWarnThresholdMs = 10000L;
    protected long jvmPauseInfoThresholdMs = 1000L;
    protected long jvmPauseSleepTimeMs = 500L;

    public void parse(String string) throws ConfigException {
        Object object;
        Object object2;
        Serializable serializable;
        LOG.c("Reading configuration from: " + string);
        try {
            serializable = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().create(string);
            object2 = new Properties();
            object = new FileInputStream((File)serializable);
            try {
                ((Properties)object2).load((InputStream)object);
                this.configFileStr = string;
            }
            finally {
                ((FileInputStream)object).close();
            }
            this.initialConfig = new String(Files.readAllBytes(((File)serializable).toPath()));
            this.parseProperties((Properties)object2);
        }
        catch (IOException iOException) {
            throw new ConfigException("Error processing " + string, iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConfigException("Error processing " + string, illegalArgumentException);
        }
        if (this.dynamicConfigFileStr != null) {
            try {
                serializable = new Properties();
                object2 = new FileInputStream(this.dynamicConfigFileStr);
                try {
                    ((Properties)serializable).load((InputStream)object2);
                    if (((Properties)serializable).getProperty("version") != null) {
                        throw new ConfigException("dynamic file shouldn't have version inside");
                    }
                    object = QuorumPeerConfig.getVersionFromFilename(this.dynamicConfigFileStr);
                    if (object != null) {
                        ((Properties)serializable).setProperty("version", (String)object);
                    }
                }
                finally {
                    ((FileInputStream)object2).close();
                }
                this.setupQuorumPeerConfig((Properties)serializable, false);
            }
            catch (IOException iOException) {
                throw new ConfigException("Error processing " + this.dynamicConfigFileStr, iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigException("Error processing " + this.dynamicConfigFileStr, illegalArgumentException);
            }
            serializable = new File(this.configFileStr + nextDynamicConfigFileSuffix);
            if (((File)serializable).exists()) {
                try {
                    object2 = new Properties();
                    object = new FileInputStream((File)serializable);
                    try {
                        ((Properties)object2).load((InputStream)object);
                    }
                    finally {
                        ((FileInputStream)object).close();
                    }
                    boolean bl2 = false;
                    for (Map.Entry<Object, Object> entry : ((Properties)object2).entrySet()) {
                        String string2 = entry.getKey().toString().trim();
                        if (!string2.startsWith("group") && !string2.startsWith("weight")) continue;
                        bl2 = true;
                        break;
                    }
                    this.lastSeenQuorumVerifier = QuorumPeerConfig.createQuorumVerifier((Properties)object2, bl2);
                }
                catch (IOException iOException) {
                    LOG.d("NextQuorumVerifier is initiated to null");
                }
            }
        }
    }

    public static String getVersionFromFilename(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 < 0 || n2 >= string.length()) {
            return null;
        }
        String string2 = string.substring(n2 + 1);
        try {
            long l2 = Long.parseLong(string2, 16);
            return Long.toHexString(l2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void parseProperties(Properties properties) throws IOException, ConfigException {
        Integer n2 = null;
        Integer n3 = null;
        int n4 = 0;
        String string = null;
        String string2 = null;
        VerifyingFileFactory verifyingFileFactory = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().build();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string3 = entry.getKey().toString().trim();
            String string4 = entry.getValue().toString().trim();
            if (string3.equals("dataDir")) {
                this.dataDir = verifyingFileFactory.create(string4);
                continue;
            }
            if (string3.equals("dataLogDir")) {
                this.dataLogDir = verifyingFileFactory.create(string4);
                continue;
            }
            if (string3.equals("clientPort")) {
                n2 = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("localSessionsEnabled")) {
                this.localSessionsEnabled = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("localSessionsUpgradingEnabled")) {
                this.localSessionsUpgradingEnabled = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("clientPortAddress")) {
                string = string4.trim();
                continue;
            }
            if (string3.equals("secureClientPort")) {
                n3 = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("secureClientPortAddress")) {
                string2 = string4.trim();
                continue;
            }
            if (string3.equals("observerMasterPort")) {
                n4 = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("clientPortListenBacklog")) {
                this.clientPortListenBacklog = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("tickTime")) {
                this.tickTime = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("maxClientCnxns")) {
                this.maxClientCnxns = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("minSessionTimeout")) {
                this.minSessionTimeout = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("maxSessionTimeout")) {
                this.maxSessionTimeout = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("initLimit")) {
                this.initLimit = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("syncLimit")) {
                this.syncLimit = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("connectToLearnerMasterLimit")) {
                this.connectToLearnerMasterLimit = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("electionAlg")) {
                this.electionAlg = Integer.parseInt(string4);
                if (this.electionAlg == 3) continue;
                throw new ConfigException("Invalid electionAlg value. Only 3 is supported.");
            }
            if (string3.equals("quorumListenOnAllIPs")) {
                this.quorumListenOnAllIPs = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("peerType")) {
                if (string4.toLowerCase().equals("observer")) {
                    this.peerType = QuorumPeer.LearnerType.OBSERVER;
                    continue;
                }
                if (string4.toLowerCase().equals("participant")) {
                    this.peerType = QuorumPeer.LearnerType.PARTICIPANT;
                    continue;
                }
                throw new ConfigException("Unrecognised peertype: " + string4);
            }
            if (string3.equals("syncEnabled")) {
                this.syncEnabled = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("dynamicConfigFile")) {
                this.dynamicConfigFileStr = string4;
                continue;
            }
            if (string3.equals("autopurge.snapRetainCount")) {
                this.snapRetainCount = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("autopurge.purgeInterval")) {
                this.purgeInterval = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("standaloneEnabled")) {
                QuorumPeerConfig.setStandaloneEnabled(this.parseBoolean(string3, string4));
                continue;
            }
            if (string3.equals("reconfigEnabled")) {
                QuorumPeerConfig.setReconfigEnabled(this.parseBoolean(string3, string4));
                continue;
            }
            if (string3.equals("sslQuorum")) {
                this.sslQuorum = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("portUnification")) {
                this.shouldUsePortUnification = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("sslQuorumReloadCertFiles")) {
                this.sslQuorumReloadCertFiles = this.parseBoolean(string3, string4);
                continue;
            }
            if ((string3.startsWith("server.") || string3.startsWith("group") || string3.startsWith("weight")) && properties.containsKey("dynamicConfigFile")) {
                throw new ConfigException("parameter: " + string3 + " must be in a separate dynamic config file");
            }
            if (string3.equals("quorum.auth.enableSasl")) {
                this.quorumEnableSasl = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("quorum.auth.serverRequireSasl")) {
                this.quorumServerRequireSasl = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("quorum.auth.learnerRequireSasl")) {
                this.quorumLearnerRequireSasl = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("quorum.auth.learner.saslLoginContext")) {
                this.quorumLearnerLoginContext = string4;
                continue;
            }
            if (string3.equals("quorum.auth.server.saslLoginContext")) {
                this.quorumServerLoginContext = string4;
                continue;
            }
            if (string3.equals("quorum.auth.kerberos.servicePrincipal")) {
                this.quorumServicePrincipal = string4;
                continue;
            }
            if (string3.equals("quorum.cnxn.threads.size")) {
                this.quorumCnxnThreadsSize = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("jvm.pause.info-threshold.ms")) {
                this.jvmPauseInfoThresholdMs = Long.parseLong(string4);
                continue;
            }
            if (string3.equals("jvm.pause.warn-threshold.ms")) {
                this.jvmPauseWarnThresholdMs = Long.parseLong(string4);
                continue;
            }
            if (string3.equals("jvm.pause.sleep.time.ms")) {
                this.jvmPauseSleepTimeMs = Long.parseLong(string4);
                continue;
            }
            if (string3.equals("jvm.pause.monitor")) {
                this.jvmPauseMonitorToRun = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("metricsProvider.className")) {
                this.metricsProviderClassName = string4;
                continue;
            }
            if (string3.startsWith("metricsProvider.")) {
                String string5 = string3.substring(16);
                this.metricsProviderConfiguration.put(string5, string4);
                continue;
            }
            if (string3.equals("multiAddress.enabled")) {
                this.multiAddressEnabled = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("multiAddress.reachabilityCheckTimeoutMs")) {
                this.multiAddressReachabilityCheckTimeoutMs = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("multiAddress.reachabilityCheckEnabled")) {
                this.multiAddressReachabilityCheckEnabled = this.parseBoolean(string3, string4);
                continue;
            }
            if (string3.equals("oraclePath")) {
                this.oraclePath = string4;
                continue;
            }
            System.setProperty("zookeeper." + string3, string4);
        }
        if (!this.quorumEnableSasl && this.quorumServerRequireSasl) {
            throw new IllegalArgumentException("quorum.auth.enableSasl is disabled, so cannot enable quorum.auth.serverRequireSasl");
        }
        if (!this.quorumEnableSasl && this.quorumLearnerRequireSasl) {
            throw new IllegalArgumentException("quorum.auth.enableSasl is disabled, so cannot enable quorum.auth.learnerRequireSasl");
        }
        if (!this.quorumLearnerRequireSasl && this.quorumServerRequireSasl) {
            throw new IllegalArgumentException("quorum.auth.learnerRequireSasl is disabled, so cannot enable quorum.auth.serverRequireSasl");
        }
        if (this.snapRetainCount < 3) {
            LOG.d("Invalid autopurge.snapRetainCount: " + this.snapRetainCount + ". Defaulting to " + 3);
            this.snapRetainCount = 3;
        }
        if (this.dataDir == null) {
            throw new IllegalArgumentException("dataDir is not set");
        }
        if (this.dataLogDir == null) {
            this.dataLogDir = this.dataDir;
        }
        if (n2 == null) {
            LOG.c("clientPort is not set");
            if (string != null) {
                throw new IllegalArgumentException("clientPortAddress is set but clientPort is not set");
            }
        } else if (string != null) {
            this.clientPortAddress = new InetSocketAddress(InetAddress.getByName(string), (int)n2);
            LOG.c("clientPortAddress is {}", (Object)NetUtils.formatInetAddr(this.clientPortAddress));
        } else {
            this.clientPortAddress = new InetSocketAddress(n2);
            LOG.c("clientPortAddress is {}", (Object)NetUtils.formatInetAddr(this.clientPortAddress));
        }
        if (n3 == null) {
            LOG.c("secureClientPort is not set");
            if (string2 != null) {
                throw new IllegalArgumentException("secureClientPortAddress is set but secureClientPort is not set");
            }
        } else if (string2 != null) {
            this.secureClientPortAddress = new InetSocketAddress(InetAddress.getByName(string2), (int)n3);
            LOG.c("secureClientPortAddress is {}", (Object)NetUtils.formatInetAddr(this.secureClientPortAddress));
        } else {
            this.secureClientPortAddress = new InetSocketAddress(n3);
            LOG.c("secureClientPortAddress is {}", (Object)NetUtils.formatInetAddr(this.secureClientPortAddress));
        }
        if (this.secureClientPortAddress != null) {
            QuorumPeerConfig.configureSSLAuth();
        }
        if (n4 <= 0) {
            LOG.c("observerMasterPort is not set");
        } else {
            this.observerMasterPort = n4;
            LOG.c("observerMasterPort is {}", (Object)n4);
        }
        if (this.tickTime == 0) {
            throw new IllegalArgumentException("tickTime is not set");
        }
        this.minSessionTimeout = this.minSessionTimeout == -1 ? this.tickTime * 2 : this.minSessionTimeout;
        int n5 = this.maxSessionTimeout = this.maxSessionTimeout == -1 ? this.tickTime * 20 : this.maxSessionTimeout;
        if (this.minSessionTimeout > this.maxSessionTimeout) {
            throw new IllegalArgumentException("minSessionTimeout must not be larger than maxSessionTimeout");
        }
        LOG.c("metricsProvider.className is {}", (Object)this.metricsProviderClassName);
        try {
            Class.forName(this.metricsProviderClassName, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("metrics provider class was not found", classNotFoundException);
        }
        if (this.dynamicConfigFileStr == null) {
            this.setupQuorumPeerConfig(properties, true);
            if (this.isDistributed() && QuorumPeerConfig.isReconfigEnabled()) {
                this.backupOldConfig();
            }
        }
    }

    public static void configureSSLAuth() throws ConfigException {
        block6: {
            try (ClientX509Util clientX509Util = new ClientX509Util();){
                String string = "zookeeper.authProvider." + System.getProperty(clientX509Util.getSslAuthProviderProperty(), "x509");
                if (System.getProperty(string) != null) break block6;
                if ("zookeeper.authProvider.x509".equals(string)) {
                    System.setProperty("zookeeper.authProvider.x509", "XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.X509AuthenticationProvider");
                    break block6;
                }
                throw new ConfigException("No auth provider configured for the SSL authentication scheme '" + System.getProperty(clientX509Util.getSslAuthProviderProperty()) + "'.");
            }
        }
    }

    private void backupOldConfig() throws IOException {
        new AtomicFileWritingIdiom(new File(this.configFileStr + ".bak"), new AtomicFileWritingIdiom.OutputStreamStatement(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                try (FileInputStream fileInputStream = new FileInputStream(new File(QuorumPeerConfig.this.configFileStr));){
                    int n2;
                    byte[] byArray = new byte[1024];
                    while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                        outputStream.write(byArray, 0, n2);
                    }
                }
            }
        });
    }

    public static void writeDynamicConfig(String string, final QuorumVerifier quorumVerifier, final boolean bl2) throws IOException {
        new AtomicFileWritingIdiom(new File(string), new AtomicFileWritingIdiom.WriterStatement(){

            @Override
            public void write(Writer writer) throws IOException {
                Properties properties = new Properties();
                properties.load(new StringReader(quorumVerifier.toString()));
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String string = entry.getKey().toString().trim();
                    if (!bl2 && string.startsWith("version")) continue;
                    String string2 = entry.getValue().toString().trim();
                    arrayList.add(string.concat("=").concat(string2));
                }
                Collections.sort(arrayList);
                writer.write(StringUtils.joinStrings(arrayList, "\n"));
            }
        });
    }

    public static void editStaticConfig(String string, String string2, final boolean bl2) throws IOException {
        if (string == null) {
            return;
        }
        File file = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().create(string);
        final File file2 = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().create(string2);
        final Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            properties.load(fileInputStream);
        }
        new AtomicFileWritingIdiom(new File(string), new AtomicFileWritingIdiom.WriterStatement(){

            @Override
            public void write(Writer writer) throws IOException {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String string = entry.getKey().toString().trim();
                    if (string.startsWith("server.") || string.startsWith("group") || string.startsWith("weight") || string.startsWith("dynamicConfigFile") || string.startsWith("peerType") || bl2 && (string.startsWith("clientPort") || string.startsWith("clientPortAddress"))) continue;
                    String string2 = entry.getValue().toString().trim();
                    writer.write(string.concat("=").concat(string2).concat("\n"));
                }
                String string = PathUtils.normalizeFileSystemPath(file2.getCanonicalPath());
                writer.write("dynamicConfigFile=".concat(string).concat("\n"));
            }
        });
    }

    public static void deleteFile(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                LOG.d("deleting {} failed", (Object)string);
            }
        }
    }

    private static QuorumVerifier createQuorumVerifier(Properties properties, boolean bl2, String string) throws ConfigException {
        if (string == null) {
            return QuorumPeerConfig.createQuorumVerifier(properties, bl2);
        }
        return new QuorumOracleMaj(properties, string);
    }

    private static QuorumVerifier createQuorumVerifier(Properties properties, boolean bl2) throws ConfigException {
        if (bl2) {
            return new QuorumHierarchical(properties);
        }
        return new QuorumMaj(properties);
    }

    void setupQuorumPeerConfig(Properties properties, boolean bl2) throws IOException, ConfigException {
        this.quorumVerifier = QuorumPeerConfig.parseDynamicConfig(properties, this.electionAlg, true, bl2, this.oraclePath);
        this.setupMyId();
        this.setupClientPort();
        this.setupPeerType();
        this.checkValidity();
    }

    public static QuorumVerifier parseDynamicConfig(Properties properties, int n2, boolean bl2, boolean bl3, String string) throws IOException, ConfigException {
        boolean bl4 = false;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string2 = entry.getKey().toString().trim();
            if (string2.startsWith("group") || string2.startsWith("weight")) {
                bl4 = true;
                continue;
            }
            if (bl3 || string2.startsWith("server.") || string2.equals("version")) continue;
            LOG.c(properties.toString());
            throw new ConfigException("Unrecognised parameter: " + string2);
        }
        QuorumVerifier quorumVerifier = QuorumPeerConfig.createQuorumVerifier(properties, bl4, string);
        int n3 = quorumVerifier.getVotingMembers().size();
        int n4 = quorumVerifier.getObservingMembers().size();
        if (n3 == 0) {
            if (!standaloneEnabled) {
                throw new IllegalArgumentException("standaloneEnabled = false then number of participants should be >0");
            }
            if (n4 > 0) {
                throw new IllegalArgumentException("Observers w/o participants is an invalid configuration");
            }
        } else if (n3 == 1 && standaloneEnabled) {
            LOG.e("Invalid configuration, only one server specified (ignoring)");
            if (n4 > 0) {
                throw new IllegalArgumentException("Observers w/o quorum is an invalid configuration");
            }
        } else {
            if (bl2) {
                if (n3 <= 2) {
                    LOG.d("No server failure will be tolerated. You need at least 3 servers.");
                } else if (n3 % 2 == 0) {
                    LOG.d("Non-optimal configuration, consider an odd number of servers.");
                }
            }
            for (QuorumPeer.QuorumServer quorumServer : quorumVerifier.getVotingMembers().values()) {
                if (quorumServer.electionAddr != null) continue;
                throw new IllegalArgumentException("Missing election port for server: " + quorumServer.id);
            }
        }
        return quorumVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupMyId() throws IOException {
        String string;
        File file = new File(this.dataDir, "myid");
        if (!file.isFile()) {
            return;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            string = bufferedReader.readLine();
        }
        try {
            this.serverId = Long.parseLong(string);
            hoe.a("myid", string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("serverid " + string + " is not a number");
        }
    }

    private void setupClientPort() throws ConfigException {
        if (this.serverId == -1L) {
            return;
        }
        QuorumPeer.QuorumServer quorumServer = this.quorumVerifier.getAllMembers().get(this.serverId);
        if (this.clientPortAddress != null && quorumServer != null && quorumServer.clientAddr != null && (!this.clientPortAddress.getAddress().isAnyLocalAddress() && !this.clientPortAddress.equals(quorumServer.clientAddr) || this.clientPortAddress.getAddress().isAnyLocalAddress() && this.clientPortAddress.getPort() != quorumServer.clientAddr.getPort())) {
            throw new ConfigException("client address for this server (id = " + this.serverId + ") in static config file is " + this.clientPortAddress + " is different from client address found in dynamic file: " + quorumServer.clientAddr);
        }
        if (quorumServer != null && quorumServer.clientAddr != null) {
            this.clientPortAddress = quorumServer.clientAddr;
        }
        if (quorumServer != null && quorumServer.clientAddr == null) {
            quorumServer.clientAddr = this.clientPortAddress;
            quorumServer.isClientAddrFromStatic = true;
        }
    }

    private void setupPeerType() {
        QuorumPeer.LearnerType learnerType;
        QuorumPeer.LearnerType learnerType2 = learnerType = this.quorumVerifier.getObservingMembers().containsKey(this.serverId) ? QuorumPeer.LearnerType.OBSERVER : QuorumPeer.LearnerType.PARTICIPANT;
        if (learnerType != this.peerType) {
            LOG.d("Peer type from servers list ({}) doesn't match peerType ({}). Defaulting to servers list.", (Object)learnerType, (Object)this.peerType);
            this.peerType = learnerType;
        }
    }

    public void checkValidity() throws IOException, ConfigException {
        if (this.isDistributed()) {
            if (this.initLimit == 0) {
                throw new IllegalArgumentException("initLimit is not set");
            }
            if (this.syncLimit == 0) {
                throw new IllegalArgumentException("syncLimit is not set");
            }
            if (this.serverId == -1L) {
                throw new IllegalArgumentException("myid file is missing");
            }
        }
    }

    public InetSocketAddress getClientPortAddress() {
        return this.clientPortAddress;
    }

    public InetSocketAddress getSecureClientPortAddress() {
        return this.secureClientPortAddress;
    }

    public int getObserverMasterPort() {
        return this.observerMasterPort;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getDataLogDir() {
        return this.dataLogDir;
    }

    public String getInitialConfig() {
        return this.initialConfig;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public String getMetricsProviderClassName() {
        return this.metricsProviderClassName;
    }

    public Properties getMetricsProviderConfiguration() {
        return this.metricsProviderConfiguration;
    }

    public boolean areLocalSessionsEnabled() {
        return this.localSessionsEnabled;
    }

    public boolean isLocalSessionsUpgradingEnabled() {
        return this.localSessionsUpgradingEnabled;
    }

    public boolean isSslQuorum() {
        return this.sslQuorum;
    }

    public boolean shouldUsePortUnification() {
        return this.shouldUsePortUnification;
    }

    public int getClientPortListenBacklog() {
        return this.clientPortListenBacklog;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public int getConnectToLearnerMasterLimit() {
        return this.connectToLearnerMasterLimit;
    }

    public int getElectionAlg() {
        return this.electionAlg;
    }

    public int getElectionPort() {
        return this.electionPort;
    }

    public int getSnapRetainCount() {
        return this.snapRetainCount;
    }

    public int getPurgeInterval() {
        return this.purgeInterval;
    }

    public boolean getSyncEnabled() {
        return this.syncEnabled;
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumVerifier;
    }

    public QuorumVerifier getLastSeenQuorumVerifier() {
        return this.lastSeenQuorumVerifier;
    }

    public Map<Long, QuorumPeer.QuorumServer> getServers() {
        return Collections.unmodifiableMap(this.quorumVerifier.getAllMembers());
    }

    public long getJvmPauseInfoThresholdMs() {
        return this.jvmPauseInfoThresholdMs;
    }

    public long getJvmPauseWarnThresholdMs() {
        return this.jvmPauseWarnThresholdMs;
    }

    public long getJvmPauseSleepTimeMs() {
        return this.jvmPauseSleepTimeMs;
    }

    public boolean isJvmPauseMonitorToRun() {
        return this.jvmPauseMonitorToRun;
    }

    public long getServerId() {
        return this.serverId;
    }

    public boolean isDistributed() {
        return this.quorumVerifier != null && (!standaloneEnabled || this.quorumVerifier.getVotingMembers().size() > 1);
    }

    public QuorumPeer.LearnerType getPeerType() {
        return this.peerType;
    }

    public String getConfigFilename() {
        return this.configFileStr;
    }

    public Boolean getQuorumListenOnAllIPs() {
        return this.quorumListenOnAllIPs;
    }

    public boolean isMultiAddressEnabled() {
        return this.multiAddressEnabled;
    }

    public boolean isMultiAddressReachabilityCheckEnabled() {
        return this.multiAddressReachabilityCheckEnabled;
    }

    public int getMultiAddressReachabilityCheckTimeoutMs() {
        return this.multiAddressReachabilityCheckTimeoutMs;
    }

    public static boolean isStandaloneEnabled() {
        return standaloneEnabled;
    }

    public static void setStandaloneEnabled(boolean bl2) {
        standaloneEnabled = bl2;
    }

    public static boolean isReconfigEnabled() {
        return reconfigEnabled;
    }

    public static void setReconfigEnabled(boolean bl2) {
        reconfigEnabled = bl2;
    }

    private boolean parseBoolean(String string, String string2) throws ConfigException {
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ConfigException("Invalid option " + string2 + " for " + string + ". Choose 'true' or 'false.'");
    }

    public static class ConfigException
    extends Exception {
        public ConfigException(String string) {
            super(string);
        }

        public ConfigException(String string, Exception exception) {
            super(string, exception);
        }
    }
}

