/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.AtomicFileWritingIdiom;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.NetUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.QuorumX509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Exception;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.AdminServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.AdminServerFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Election;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.FastLeaderElection;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Follower;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderElectionBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LocalPeerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.MultipleAddresses;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Observer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumCnxManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumStats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.RemotePeerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Vote;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.NullQuorumAuthLearner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.NullQuorumAuthServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.QuorumAuthLearner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.QuorumAuthServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.SaslQuorumAuthLearner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.SaslQuorumAuthServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumOracleMaj;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.ConfigUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.JvmPauseMonitor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.ZxidUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.security.sasl.SaslException;

public class QuorumPeer
extends ZooKeeperThread
implements QuorumStats.Provider {
    private static final foe LOG = goe.a(QuorumPeer.class);
    public static final String CONFIG_KEY_KERBEROS_CANONICALIZE_HOST_NAMES = "zookeeper.kerberos.canonicalizeHostNames";
    public static final String CONFIG_DEFAULT_KERBEROS_CANONICALIZE_HOST_NAMES = "false";
    private QuorumBean jmxQuorumBean;
    LocalPeerBean jmxLocalPeerBean;
    private Map<Long, RemotePeerBean> jmxRemotePeerBean;
    LeaderElectionBean jmxLeaderElectionBean;
    private AtomicReference<QuorumCnxManager> qcmRef = new AtomicReference();
    QuorumAuthServer authServer;
    QuorumAuthLearner authLearner;
    private ZKDatabase zkDb;
    private JvmPauseMonitor jvmPauseMonitor;
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    private int observerMasterPort;
    public static final String CONFIG_KEY_MULTI_ADDRESS_ENABLED = "zookeeper.multiAddress.enabled";
    public static final String CONFIG_DEFAULT_MULTI_ADDRESS_ENABLED = "false";
    private boolean multiAddressEnabled = true;
    public static final String CONFIG_KEY_MULTI_ADDRESS_REACHABILITY_CHECK_TIMEOUT_MS = "zookeeper.multiAddress.reachabilityCheckTimeoutMs";
    private int multiAddressReachabilityCheckTimeoutMs = (int)MultipleAddresses.DEFAULT_TIMEOUT.toMillis();
    public static final String CONFIG_KEY_MULTI_ADDRESS_REACHABILITY_CHECK_ENABLED = "zookeeper.multiAddress.reachabilityCheckEnabled";
    private boolean multiAddressReachabilityCheckEnabled = true;
    static final long OBSERVER_ID = Long.MAX_VALUE;
    public long start_fle;
    public long end_fle;
    public static final String FLE_TIME_UNIT = "MS";
    private long unavailableStartTime;
    private LearnerType learnerType = LearnerType.PARTICIPANT;
    private String configFilename = null;
    private QuorumVerifier quorumVerifier;
    private QuorumVerifier lastSeenQuorumVerifier = null;
    final Object QV_LOCK = new Object();
    private long myid;
    private boolean sslQuorum;
    private boolean shouldUsePortUnification;
    private final QuorumX509Util x509Util;
    private volatile Vote currentVote;
    private volatile boolean running = true;
    private String initialConfig;
    protected int tickTime;
    protected boolean localSessionsEnabled = false;
    protected boolean localSessionsUpgradingEnabled = true;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected int clientPortListenBacklog = -1;
    protected volatile int initLimit;
    protected volatile int syncLimit;
    protected volatile int connectToLearnerMasterLimit;
    protected boolean syncEnabled = true;
    protected AtomicInteger tick = new AtomicInteger();
    protected boolean quorumListenOnAllIPs = false;
    private long electionTimeTaken = -1L;
    protected boolean quorumSaslEnableAuth;
    protected boolean quorumServerSaslAuthRequired;
    protected boolean quorumLearnerSaslAuthRequired;
    protected String quorumServicePrincipal;
    protected String quorumLearnerLoginContext;
    protected String quorumServerLoginContext;
    private static final int QUORUM_CNXN_THREADS_SIZE_DEFAULT_VALUE = 20;
    protected int quorumCnxnThreadsSize = 20;
    public static final String QUORUM_CNXN_TIMEOUT_MS = "zookeeper.quorumCnxnTimeoutMs";
    private static int quorumCnxnTimeoutMs = Integer.getInteger("zookeeper.quorumCnxnTimeoutMs", -1);
    private ServerState state = ServerState.LOOKING;
    private AtomicReference<ZabState> zabState = new AtomicReference<ZabState>(ZabState.ELECTION);
    private AtomicReference<SyncMode> syncMode = new AtomicReference<SyncMode>(SyncMode.NONE);
    private AtomicReference<String> leaderAddress = new AtomicReference<String>("");
    private AtomicLong leaderId = new AtomicLong(-1L);
    private boolean reconfigFlag = false;
    DatagramSocket udpSocket;
    private final AtomicReference<AddressTuple> myAddrs = new AtomicReference();
    private int electionType;
    Election electionAlg;
    ServerCnxnFactory cnxnFactory;
    ServerCnxnFactory secureCnxnFactory;
    private FileTxnSnapLog logFactory = null;
    private final QuorumStats quorumStats;
    AdminServer adminServer;
    private final boolean reconfigEnabled;
    ResponderThread responder;
    public Follower follower;
    public Leader leader;
    public Observer observer;
    boolean shuttingDownLE = false;
    public static final String SYNC_ENABLED = "zookeeper.observer.syncEnabled";
    private long acceptedEpoch = -1L;
    private long currentEpoch = -1L;
    public static final String CURRENT_EPOCH_FILENAME = "currentEpoch";
    public static final String ACCEPTED_EPOCH_FILENAME = "acceptedEpoch";
    private ArrayList<QuorumServer> observerMasters = new ArrayList();
    private int nextObserverMaster = 0;

    public int getObserverMasterPort() {
        return this.observerMasterPort;
    }

    public void setObserverMasterPort(int n2) {
        this.observerMasterPort = n2;
    }

    public boolean isMultiAddressEnabled() {
        return this.multiAddressEnabled;
    }

    public void setMultiAddressEnabled(boolean bl2) {
        this.multiAddressEnabled = bl2;
        LOG.c("multiAddress.enabled set to {}", (Object)bl2);
    }

    public int getMultiAddressReachabilityCheckTimeoutMs() {
        return this.multiAddressReachabilityCheckTimeoutMs;
    }

    public void setMultiAddressReachabilityCheckTimeoutMs(int n2) {
        this.multiAddressReachabilityCheckTimeoutMs = n2;
        LOG.c("multiAddress.reachabilityCheckTimeoutMs set to {}", (Object)n2);
    }

    public boolean isMultiAddressReachabilityCheckEnabled() {
        return this.multiAddressReachabilityCheckEnabled;
    }

    public void setMultiAddressReachabilityCheckEnabled(boolean bl2) {
        this.multiAddressReachabilityCheckEnabled = bl2;
        LOG.c("multiAddress.reachabilityCheckEnabled set to {}", (Object)bl2);
    }

    public LearnerType getLearnerType() {
        return this.learnerType;
    }

    public void setLearnerType(LearnerType learnerType) {
        this.learnerType = learnerType;
    }

    protected synchronized void setConfigFileName(String string) {
        this.configFilename = string;
    }

    public int getQuorumSize() {
        return this.getVotingView().size();
    }

    public void setJvmPauseMonitor(JvmPauseMonitor jvmPauseMonitor) {
        this.jvmPauseMonitor = jvmPauseMonitor;
    }

    public long getMyId() {
        return this.myid;
    }

    void setId(long l2) {
        this.myid = l2;
    }

    public boolean isSslQuorum() {
        return this.sslQuorum;
    }

    public boolean shouldUsePortUnification() {
        return this.shouldUsePortUnification;
    }

    QuorumX509Util getX509Util() {
        return this.x509Util;
    }

    public synchronized Vote getCurrentVote() {
        return this.currentVote;
    }

    public synchronized void setCurrentVote(Vote vote) {
        this.currentVote = vote;
    }

    public synchronized void setPeerState(ServerState serverState) {
        this.state = serverState;
        if (serverState == ServerState.LOOKING) {
            this.setLeaderAddressAndId(null, -1L);
            this.setZabState(ZabState.ELECTION);
        } else {
            LOG.c("Peer state changed: {}", (Object)this.getDetailedPeerState());
        }
    }

    public void setZabState(ZabState zabState) {
        if (zabState == ZabState.BROADCAST && this.unavailableStartTime != 0L) {
            long l2 = Time.currentElapsedTime() - this.unavailableStartTime;
            ServerMetrics.getMetrics().UNAVAILABLE_TIME.add(l2);
            if (this.getPeerState() == ServerState.LEADING) {
                ServerMetrics.getMetrics().LEADER_UNAVAILABLE_TIME.add(l2);
            }
            this.unavailableStartTime = 0L;
        }
        this.zabState.set(zabState);
        LOG.c("Peer state changed: {}", (Object)this.getDetailedPeerState());
    }

    public void setSyncMode(SyncMode syncMode) {
        this.syncMode.set(syncMode);
        LOG.c("Peer state changed: {}", (Object)this.getDetailedPeerState());
    }

    public ZabState getZabState() {
        return this.zabState.get();
    }

    public SyncMode getSyncMode() {
        return this.syncMode.get();
    }

    public void setLeaderAddressAndId(MultipleAddresses multipleAddresses, long l2) {
        if (multipleAddresses != null) {
            this.leaderAddress.set(String.join((CharSequence)"|", multipleAddresses.getAllHostStrings()));
        } else {
            this.leaderAddress.set(null);
        }
        this.leaderId.set(l2);
    }

    public String getLeaderAddress() {
        return this.leaderAddress.get();
    }

    public long getLeaderId() {
        return this.leaderId.get();
    }

    public String getDetailedPeerState() {
        SyncMode syncMode;
        StringBuilder stringBuilder = new StringBuilder(this.getPeerState().toString().toLowerCase());
        ZabState zabState = this.getZabState();
        if (!ZabState.ELECTION.equals((Object)zabState)) {
            stringBuilder.append(" - ").append(zabState.toString().toLowerCase());
        }
        if (!SyncMode.NONE.equals((Object)(syncMode = this.getSyncMode()))) {
            stringBuilder.append(" - ").append(syncMode.toString().toLowerCase());
        }
        return stringBuilder.toString();
    }

    public synchronized void reconfigFlagSet() {
        this.reconfigFlag = true;
    }

    public synchronized void reconfigFlagClear() {
        this.reconfigFlag = false;
    }

    public synchronized boolean isReconfigStateChange() {
        return this.reconfigFlag;
    }

    public synchronized ServerState getPeerState() {
        return this.state;
    }

    public void recreateSocketAddresses(long l2) {
        QuorumServer quorumServer;
        QuorumVerifier quorumVerifier = this.getQuorumVerifier();
        if (quorumVerifier != null && (quorumServer = quorumVerifier.getAllMembers().get(l2)) != null) {
            quorumServer.recreateSocketAddresses();
            if (l2 == this.getMyId()) {
                this.setAddrs(quorumServer.addr, quorumServer.electionAddr, quorumServer.clientAddr);
            }
        }
        if ((quorumVerifier = this.getLastSeenQuorumVerifier()) != null && (quorumServer = quorumVerifier.getAllMembers().get(l2)) != null) {
            quorumServer.recreateSocketAddresses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddressTuple getAddrs() {
        AddressTuple addressTuple = this.myAddrs.get();
        if (addressTuple != null) {
            return addressTuple;
        }
        try {
            Object object = this.QV_LOCK;
            synchronized (object) {
                addressTuple = this.myAddrs.get();
                while (addressTuple == null) {
                    this.QV_LOCK.wait();
                    addressTuple = this.myAddrs.get();
                }
                return addressTuple;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedException);
        }
    }

    public MultipleAddresses getQuorumAddress() {
        return this.getAddrs().quorumAddr;
    }

    public MultipleAddresses getElectionAddress() {
        return this.getAddrs().electionAddr;
    }

    public InetSocketAddress getClientAddress() {
        AddressTuple addressTuple = this.myAddrs.get();
        return addressTuple == null ? null : addressTuple.clientAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAddrs(MultipleAddresses multipleAddresses, MultipleAddresses multipleAddresses2, InetSocketAddress inetSocketAddress) {
        Object object = this.QV_LOCK;
        synchronized (object) {
            this.myAddrs.set(new AddressTuple(multipleAddresses, multipleAddresses2, inetSocketAddress));
            this.QV_LOCK.notifyAll();
        }
    }

    public static QuorumPeer testingQuorumPeer() throws SaslException {
        return new QuorumPeer();
    }

    public QuorumPeer() throws SaslException {
        super("QuorumPeer");
        this.quorumStats = new QuorumStats(this);
        this.jmxRemotePeerBean = new HashMap<Long, RemotePeerBean>();
        this.adminServer = AdminServerFactory.createAdminServer();
        this.x509Util = this.createX509Util();
        this.initialize();
        this.reconfigEnabled = QuorumPeerConfig.isReconfigEnabled();
    }

    QuorumX509Util createX509Util() {
        return new QuorumX509Util();
    }

    public QuorumPeer(Map<Long, QuorumServer> map, File file, File file2, int n2, long l2, int n3, int n4, int n5, int n6, ServerCnxnFactory serverCnxnFactory) throws IOException {
        this(map, file, file2, n2, l2, n3, n4, n5, n6, false, serverCnxnFactory, new QuorumMaj(map));
    }

    public QuorumPeer(Map<Long, QuorumServer> map, File file, File file2, int n2, long l2, int n3, int n4, int n5, int n6, boolean bl2, ServerCnxnFactory serverCnxnFactory, QuorumVerifier quorumVerifier) throws IOException {
        this();
        this.cnxnFactory = serverCnxnFactory;
        this.electionType = n2;
        this.myid = l2;
        this.tickTime = n3;
        this.initLimit = n4;
        this.syncLimit = n5;
        this.connectToLearnerMasterLimit = n6;
        this.quorumListenOnAllIPs = bl2;
        this.logFactory = new FileTxnSnapLog(file2, file);
        this.zkDb = new ZKDatabase(this.logFactory);
        if (quorumVerifier == null) {
            quorumVerifier = new QuorumMaj(map);
        }
        this.setQuorumVerifier(quorumVerifier, false);
        this.adminServer = AdminServerFactory.createAdminServer();
    }

    public void initialize() throws SaslException {
        if (this.isQuorumSaslAuthEnabled()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (QuorumServer quorumServer : this.getView().values()) {
                hashSet.add(quorumServer.hostname);
            }
            this.authServer = new SaslQuorumAuthServer(this.isQuorumServerSaslAuthRequired(), this.quorumServerLoginContext, hashSet);
            this.authLearner = new SaslQuorumAuthLearner(this.isQuorumLearnerSaslAuthRequired(), this.quorumServicePrincipal, this.quorumLearnerLoginContext);
        } else {
            this.authServer = new NullQuorumAuthServer();
            this.authLearner = new NullQuorumAuthLearner();
        }
    }

    QuorumStats quorumStats() {
        return this.quorumStats;
    }

    @Override
    public synchronized void start() {
        if (!this.getView().containsKey(this.myid)) {
            throw new RuntimeException("My id " + this.myid + " not in the peer list");
        }
        this.loadDataBase();
        this.startServerCnxnFactory();
        try {
            this.adminServer.start();
        }
        catch (AdminServer.AdminServerException adminServerException) {
            LOG.c("Problem starting AdminServer", adminServerException);
        }
        this.startLeaderElection();
        this.startJvmPauseMonitor();
        super.start();
    }

    private void loadDataBase() {
        try {
            this.zkDb.loadDataBase();
            long l2 = this.zkDb.getDataTree().lastProcessedZxid;
            long l3 = ZxidUtils.getEpochFromZxid(l2);
            try {
                this.currentEpoch = this.readLongFromFile(CURRENT_EPOCH_FILENAME);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.currentEpoch = l3;
                LOG.c("{} not found! Creating with a reasonable default of {}. This should only happen when you are upgrading your installation", (Object)CURRENT_EPOCH_FILENAME, (Object)this.currentEpoch);
                this.writeLongToFile(CURRENT_EPOCH_FILENAME, this.currentEpoch);
            }
            if (l3 > this.currentEpoch) {
                File file = new File(this.getTxnFactory().getSnapDir(), "currentEpoch.tmp");
                if (file.exists()) {
                    long l4 = this.readLongFromFile(file.getName());
                    LOG.c("{} found. Setting current epoch to {}.", (Object)file, (Object)l4);
                    this.setCurrentEpoch(l4);
                } else {
                    throw new IOException("The current epoch, " + ZxidUtils.zxidToString(this.currentEpoch) + ", is older than the last zxid, " + l2);
                }
            }
            try {
                this.acceptedEpoch = this.readLongFromFile(ACCEPTED_EPOCH_FILENAME);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.acceptedEpoch = l3;
                LOG.c("{} not found! Creating with a reasonable default of {}. This should only happen when you are upgrading your installation", (Object)ACCEPTED_EPOCH_FILENAME, (Object)this.acceptedEpoch);
                this.writeLongToFile(ACCEPTED_EPOCH_FILENAME, this.acceptedEpoch);
            }
            if (this.acceptedEpoch < this.currentEpoch) {
                throw new IOException("The accepted epoch, " + ZxidUtils.zxidToString(this.acceptedEpoch) + " is less than the current epoch, " + ZxidUtils.zxidToString(this.currentEpoch));
            }
        }
        catch (IOException iOException) {
            LOG.d("Unable to load database on disk", iOException);
            throw new RuntimeException("Unable to run quorum server ", iOException);
        }
    }

    public synchronized void stopLeaderElection() {
        this.responder.running = false;
        this.responder.interrupt();
    }

    public synchronized void startLeaderElection() {
        try {
            if (this.getPeerState() == ServerState.LOOKING) {
                this.currentVote = new Vote(this.myid, this.getLastLoggedZxid(), this.getCurrentEpoch());
            }
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException(iOException.getMessage());
            runtimeException.setStackTrace(iOException.getStackTrace());
            throw runtimeException;
        }
        this.electionAlg = this.createElectionAlgorithm(this.electionType);
    }

    private void startJvmPauseMonitor() {
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.serviceStart();
        }
    }

    protected static int countParticipants(Map<Long, QuorumServer> map) {
        int n2 = 0;
        for (QuorumServer quorumServer : map.values()) {
            if (quorumServer.type != LearnerType.PARTICIPANT) continue;
            ++n2;
        }
        return n2;
    }

    public QuorumPeer(Map<Long, QuorumServer> map, File file, File file2, int n2, int n3, long l2, int n4, int n5, int n6, int n7) throws IOException {
        this(map, file, file2, n3, l2, n4, n5, n6, n7, false, ServerCnxnFactory.createFactory(QuorumPeer.getClientAddress(map, l2, n2), -1), new QuorumMaj(map));
    }

    public QuorumPeer(Map<Long, QuorumServer> map, File file, File file2, int n2, int n3, long l2, int n4, int n5, int n6, int n7, String string) throws IOException {
        this(map, file, file2, n3, l2, n4, n5, n6, n7, false, ServerCnxnFactory.createFactory(QuorumPeer.getClientAddress(map, l2, n2), -1), new QuorumOracleMaj(map, string));
    }

    public QuorumPeer(Map<Long, QuorumServer> map, File file, File file2, int n2, int n3, long l2, int n4, int n5, int n6, int n7, QuorumVerifier quorumVerifier) throws IOException {
        this(map, file, file2, n3, l2, n4, n5, n6, n7, false, ServerCnxnFactory.createFactory(QuorumPeer.getClientAddress(map, l2, n2), -1), quorumVerifier);
    }

    private static InetSocketAddress getClientAddress(Map<Long, QuorumServer> map, long l2, int n2) throws IOException {
        QuorumServer quorumServer = map.get(l2);
        if (null == quorumServer) {
            throw new IOException("No QuorumServer correspoding to myid " + l2);
        }
        if (null == quorumServer.clientAddr) {
            return new InetSocketAddress(n2);
        }
        if (quorumServer.clientAddr.getPort() != n2) {
            throw new IOException("QuorumServer port " + quorumServer.clientAddr.getPort() + " does not match with given port " + n2);
        }
        return quorumServer.clientAddr;
    }

    public long getLastLoggedZxid() {
        if (!this.zkDb.isInitialized()) {
            this.loadDataBase();
        }
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    protected Follower makeFollower(FileTxnSnapLog fileTxnSnapLog) throws IOException {
        return new Follower(this, new FollowerZooKeeperServer(fileTxnSnapLog, this, this.zkDb));
    }

    protected Leader makeLeader(FileTxnSnapLog fileTxnSnapLog) throws IOException, X509Exception {
        return new Leader(this, new LeaderZooKeeperServer(fileTxnSnapLog, this, this.zkDb));
    }

    protected Observer makeObserver(FileTxnSnapLog fileTxnSnapLog) throws IOException {
        return new Observer(this, new ObserverZooKeeperServer(fileTxnSnapLog, this, this.zkDb));
    }

    protected Election createElectionAlgorithm(int n2) {
        FastLeaderElection fastLeaderElection = null;
        switch (n2) {
            case 1: {
                throw new UnsupportedOperationException("Election Algorithm 1 is not supported.");
            }
            case 2: {
                throw new UnsupportedOperationException("Election Algorithm 2 is not supported.");
            }
            case 3: {
                QuorumCnxManager.Listener listener;
                QuorumCnxManager quorumCnxManager = this.createCnxnManager();
                QuorumCnxManager quorumCnxManager2 = this.qcmRef.getAndSet(quorumCnxManager);
                if (quorumCnxManager2 != null) {
                    LOG.d("Clobbering already-set QuorumCnxManager (restarting leader election?)");
                    quorumCnxManager2.halt();
                }
                if ((listener = quorumCnxManager.listener) != null) {
                    listener.start();
                    FastLeaderElection fastLeaderElection2 = new FastLeaderElection(this, quorumCnxManager);
                    fastLeaderElection2.start();
                    fastLeaderElection = fastLeaderElection2;
                    break;
                }
                LOG.e("Null listener when initializing cnx manager");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return fastLeaderElection;
    }

    protected Election makeLEStrategy() {
        LOG.b("Initializing leader election protocol...");
        return this.electionAlg;
    }

    protected synchronized void setLeader(Leader leader) {
        this.leader = leader;
    }

    protected synchronized void setFollower(Follower follower) {
        this.follower = follower;
    }

    protected synchronized void setObserver(Observer observer) {
        this.observer = observer;
    }

    public synchronized ZooKeeperServer getActiveServer() {
        if (this.leader != null) {
            return this.leader.zk;
        }
        if (this.follower != null) {
            return this.follower.zk;
        }
        if (this.observer != null) {
            return this.observer.zk;
        }
        return null;
    }

    public void setSuspended(boolean bl2) {
        this.suspended.set(bl2);
    }

    private void checkSuspended() {
        try {
            while (this.suspended.get()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object;
        this.updateThreadName();
        LOG.b("Starting quorum peer");
        try {
            this.jmxQuorumBean = new QuorumBean(this);
            MBeanRegistry.getInstance().register(this.jmxQuorumBean, null);
            for (QuorumServer quorumServer : this.getView().values()) {
                if (this.getMyId() == quorumServer.id) {
                    LocalPeerBean localPeerBean = this.jmxLocalPeerBean = new LocalPeerBean(this);
                    try {
                        MBeanRegistry.getInstance().register(localPeerBean, this.jmxQuorumBean);
                    }
                    catch (Exception exception) {
                        LOG.c("Failed to register with JMX", exception);
                        this.jmxLocalPeerBean = null;
                    }
                    continue;
                }
                RemotePeerBean remotePeerBean = new RemotePeerBean(this, quorumServer);
                try {
                    MBeanRegistry.getInstance().register(remotePeerBean, this.jmxQuorumBean);
                    this.jmxRemotePeerBean.put(quorumServer.id, remotePeerBean);
                }
                catch (Exception exception) {
                    LOG.c("Failed to register with JMX", exception);
                }
            }
        }
        catch (Exception exception) {
            LOG.c("Failed to register with JMX", exception);
            this.jmxQuorumBean = null;
        }
        try {
            block38: while (this.running) {
                if (this.unavailableStartTime == 0L) {
                    this.unavailableStartTime = Time.currentElapsedTime();
                }
                switch (this.getPeerState()) {
                    case LOOKING: {
                        LOG.c("LOOKING");
                        ServerMetrics.getMetrics().LOOKING_COUNT.add(1L);
                        if (Boolean.getBoolean("readonlymode.enabled")) {
                            LOG.c("Attempting to start ReadOnlyZooKeeperServer");
                            object = new ReadOnlyZooKeeperServer(this.logFactory, this, this.zkDb);
                            Thread thread = new Thread((ReadOnlyZooKeeperServer)object){
                                final /* synthetic */ ReadOnlyZooKeeperServer val$roZk;
                                {
                                    this.val$roZk = readOnlyZooKeeperServer;
                                }

                                @Override
                                public void run() {
                                    try {
                                        1.sleep(Math.max(2000, QuorumPeer.this.tickTime));
                                        if (ServerState.LOOKING.equals((Object)QuorumPeer.this.getPeerState())) {
                                            this.val$roZk.startup();
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        LOG.c("Interrupted while attempting to start ReadOnlyZooKeeperServer, not started");
                                    }
                                    catch (Exception exception) {
                                        LOG.d("FAILED to start ReadOnlyZooKeeperServer", exception);
                                    }
                                }
                            };
                            try {
                                thread.start();
                                this.reconfigFlagClear();
                                if (this.shuttingDownLE) {
                                    this.shuttingDownLE = false;
                                    this.startLeaderElection();
                                }
                                this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                                this.checkSuspended();
                                continue block38;
                            }
                            catch (Exception exception) {
                                LOG.c("Unexpected exception", exception);
                                this.setPeerState(ServerState.LOOKING);
                                continue block38;
                            }
                            finally {
                                thread.interrupt();
                                ((ReadOnlyZooKeeperServer)object).shutdown();
                                continue block38;
                            }
                        }
                        try {
                            this.reconfigFlagClear();
                            if (this.shuttingDownLE) {
                                this.shuttingDownLE = false;
                                this.startLeaderElection();
                            }
                            this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                        }
                        catch (Exception exception) {
                            LOG.c("Unexpected exception", exception);
                            this.setPeerState(ServerState.LOOKING);
                        }
                        continue block38;
                    }
                    case OBSERVING: {
                        try {
                            LOG.c("OBSERVING");
                            this.setObserver(this.makeObserver(this.logFactory));
                            this.observer.observeLeader();
                            continue block38;
                        }
                        catch (Exception exception) {
                            LOG.c("Unexpected exception", exception);
                            continue block38;
                        }
                        finally {
                            this.observer.shutdown();
                            this.setObserver(null);
                            this.updateServerState();
                            if (!this.isRunning()) continue block38;
                            Observer.waitForObserverElectionDelay();
                            continue block38;
                        }
                    }
                    case FOLLOWING: {
                        try {
                            LOG.c("FOLLOWING");
                            this.setFollower(this.makeFollower(this.logFactory));
                            this.follower.followLeader();
                            continue block38;
                        }
                        catch (Exception exception) {
                            LOG.c("Unexpected exception", exception);
                            continue block38;
                        }
                        finally {
                            this.follower.shutdown();
                            this.setFollower(null);
                            this.updateServerState();
                            continue block38;
                        }
                    }
                    case LEADING: {
                        LOG.c("LEADING");
                        try {
                            this.setLeader(this.makeLeader(this.logFactory));
                            this.leader.lead();
                            this.setLeader(null);
                            continue block38;
                        }
                        catch (Exception exception) {
                            LOG.c("Unexpected exception", exception);
                            continue block38;
                        }
                        finally {
                            if (this.leader != null) {
                                this.leader.shutdown("Forcing shutdown");
                                this.setLeader(null);
                            }
                            this.updateServerState();
                            continue block38;
                        }
                    }
                }
            }
            return;
        }
        finally {
            LOG.d("QuorumPeer main thread exited");
            object = MBeanRegistry.getInstance();
            ((MBeanRegistry)object).unregister(this.jmxQuorumBean);
            ((MBeanRegistry)object).unregister(this.jmxLocalPeerBean);
            Iterator<RemotePeerBean> iterator = this.jmxRemotePeerBean.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.jmxQuorumBean = null;
                    this.jmxLocalPeerBean = null;
                    this.jmxRemotePeerBean = null;
                }
                RemotePeerBean remotePeerBean = iterator.next();
                ((MBeanRegistry)object).unregister(remotePeerBean);
            }
        }
    }

    private synchronized void updateServerState() {
        if (!this.reconfigFlag) {
            this.setPeerState(ServerState.LOOKING);
            LOG.d("PeerState set to LOOKING");
            return;
        }
        if (this.getMyId() == this.getCurrentVote().getId()) {
            this.setPeerState(ServerState.LEADING);
            LOG.b("PeerState set to LEADING");
        } else if (this.getLearnerType() == LearnerType.PARTICIPANT) {
            this.setPeerState(ServerState.FOLLOWING);
            LOG.b("PeerState set to FOLLOWING");
        } else if (this.getLearnerType() == LearnerType.OBSERVER) {
            this.setPeerState(ServerState.OBSERVING);
            LOG.b("PeerState set to OBSERVER");
        } else {
            this.setPeerState(ServerState.LOOKING);
            LOG.b("Should not be here");
        }
        this.reconfigFlag = false;
    }

    public void shutdown() {
        this.running = false;
        this.x509Util.close();
        if (this.leader != null) {
            this.leader.shutdown("quorum Peer shutdown");
        }
        if (this.follower != null) {
            this.follower.shutdown();
        }
        this.shutdownServerCnxnFactory();
        if (this.udpSocket != null) {
            this.udpSocket.close();
        }
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.serviceStop();
        }
        try {
            this.adminServer.shutdown();
        }
        catch (AdminServer.AdminServerException adminServerException) {
            LOG.c("Problem stopping AdminServer", adminServerException);
        }
        if (this.getElectionAlg() != null) {
            this.interrupt();
            this.getElectionAlg().shutdown();
        }
        try {
            this.zkDb.close();
        }
        catch (IOException iOException) {
            LOG.c("Error closing logs ", iOException);
        }
    }

    public Map<Long, QuorumServer> getView() {
        return Collections.unmodifiableMap(this.getQuorumVerifier().getAllMembers());
    }

    public Map<Long, QuorumServer> getVotingView() {
        return this.getQuorumVerifier().getVotingMembers();
    }

    public Map<Long, QuorumServer> getObservingView() {
        return this.getQuorumVerifier().getObservingMembers();
    }

    public synchronized Set<Long> getCurrentAndNextConfigVoters() {
        HashSet<Long> hashSet = new HashSet<Long>(this.getQuorumVerifier().getVotingMembers().keySet());
        if (this.getLastSeenQuorumVerifier() != null) {
            hashSet.addAll(this.getLastSeenQuorumVerifier().getVotingMembers().keySet());
        }
        return hashSet;
    }

    public boolean viewContains(Long l2) {
        return this.getView().containsKey(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getQuorumPeers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        QuorumPeer quorumPeer = this;
        synchronized (quorumPeer) {
            if (this.leader != null) {
                for (LearnerHandler learnerHandler : this.leader.getLearners()) {
                    if (learnerHandler.getSocket() == null) continue;
                    String string = NetUtils.formatInetAddr((InetSocketAddress)learnerHandler.getSocket().getRemoteSocketAddress());
                    if (this.leader.isLearnerSynced(learnerHandler)) {
                        string = string + "*";
                    }
                    arrayList.add(string);
                }
            } else if (this.follower != null) {
                arrayList.add(NetUtils.formatInetAddr((InetSocketAddress)this.follower.sock.getRemoteSocketAddress()));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public String getServerState() {
        switch (this.getPeerState()) {
            case LOOKING: {
                return "leaderelection";
            }
            case LEADING: {
                return "leading";
            }
            case FOLLOWING: {
                return "following";
            }
            case OBSERVING: {
                return "observing";
            }
        }
        return "unknown";
    }

    public void setMyid(long l2) {
        this.myid = l2;
    }

    public void setInitialConfig(String string) {
        this.initialConfig = string;
    }

    public String getInitialConfig() {
        return this.initialConfig;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int n2) {
        LOG.c("tickTime set to {}", (Object)n2);
        this.tickTime = n2;
    }

    public int getMaxClientCnxnsPerHost() {
        if (this.cnxnFactory != null) {
            return this.cnxnFactory.getMaxClientCnxnsPerHost();
        }
        if (this.secureCnxnFactory != null) {
            return this.secureCnxnFactory.getMaxClientCnxnsPerHost();
        }
        return -1;
    }

    public boolean areLocalSessionsEnabled() {
        return this.localSessionsEnabled;
    }

    public void enableLocalSessions(boolean bl2) {
        LOG.c("Local sessions {}", (Object)(bl2 ? "enabled" : "disabled"));
        this.localSessionsEnabled = bl2;
    }

    public boolean isLocalSessionsUpgradingEnabled() {
        return this.localSessionsUpgradingEnabled;
    }

    public void enableLocalSessionsUpgrading(boolean bl2) {
        LOG.c("Local session upgrading {}", (Object)(bl2 ? "enabled" : "disabled"));
        this.localSessionsUpgradingEnabled = bl2;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int n2) {
        LOG.c("minSessionTimeout set to {}", (Object)n2);
        this.minSessionTimeout = n2;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int n2) {
        LOG.c("maxSessionTimeout set to {}", (Object)n2);
        this.maxSessionTimeout = n2;
    }

    public int getClientPortListenBacklog() {
        return this.clientPortListenBacklog;
    }

    public void setClientPortListenBacklog(int n2) {
        this.clientPortListenBacklog = n2;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public void setInitLimit(int n2) {
        LOG.c("initLimit set to {}", (Object)n2);
        this.initLimit = n2;
    }

    public int getTick() {
        return this.tick.get();
    }

    public QuorumVerifier configFromString(String string) throws IOException, QuorumPeerConfig.ConfigException {
        Properties properties = new Properties();
        properties.load(new StringReader(string));
        return QuorumPeerConfig.parseDynamicConfig(properties, this.electionType, false, false, this.getQuorumVerifier().getOraclePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuorumVerifier getQuorumVerifier() {
        Object object = this.QV_LOCK;
        synchronized (object) {
            return this.quorumVerifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuorumVerifier getLastSeenQuorumVerifier() {
        Object object = this.QV_LOCK;
        synchronized (object) {
            return this.lastSeenQuorumVerifier;
        }
    }

    public synchronized void restartLeaderElection(QuorumVerifier quorumVerifier, QuorumVerifier quorumVerifier2) {
        if (quorumVerifier == null || !quorumVerifier.equals(quorumVerifier2)) {
            LOG.d("Restarting Leader Election");
            this.getElectionAlg().shutdown();
            this.shuttingDownLE = false;
            this.startLeaderElection();
        }
    }

    public String getNextDynamicConfigFilename() {
        if (this.configFilename == null) {
            LOG.d("configFilename is null! This should only happen in tests.");
            return null;
        }
        return this.configFilename + ".dynamic.next";
    }

    private void connectNewPeers(QuorumCnxManager quorumCnxManager) {
        if (this.quorumVerifier != null && this.lastSeenQuorumVerifier != null) {
            Map<Long, QuorumServer> map = this.quorumVerifier.getAllMembers();
            for (Map.Entry<Long, QuorumServer> entry : this.lastSeenQuorumVerifier.getAllMembers().entrySet()) {
                if (entry.getKey().longValue() == this.getMyId() || map.containsKey(entry.getKey())) continue;
                quorumCnxManager.connectOne(entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSeenQuorumVerifier(QuorumVerifier quorumVerifier, boolean bl2) {
        Object object;
        if (!this.isReconfigEnabled()) {
            LOG.c("Dynamic reconfig is disabled, we don't store the last seen config.");
            return;
        }
        QuorumCnxManager quorumCnxManager = this.qcmRef.get();
        Object object2 = object = quorumCnxManager != null ? quorumCnxManager : this.QV_LOCK;
        synchronized (object2) {
            Object object3 = this.QV_LOCK;
            synchronized (object3) {
                if (this.lastSeenQuorumVerifier != null && this.lastSeenQuorumVerifier.getVersion() > quorumVerifier.getVersion()) {
                    LOG.e("setLastSeenQuorumVerifier called with stale config " + quorumVerifier.getVersion() + ". Current version: " + this.quorumVerifier.getVersion());
                }
                if (this.lastSeenQuorumVerifier != null && this.lastSeenQuorumVerifier.getVersion() == quorumVerifier.getVersion()) {
                    return;
                }
                this.lastSeenQuorumVerifier = quorumVerifier;
                if (quorumCnxManager != null) {
                    this.connectNewPeers(quorumCnxManager);
                }
                if (bl2) {
                    try {
                        String string = this.getNextDynamicConfigFilename();
                        if (string != null) {
                            QuorumPeerConfig.writeDynamicConfig(string, quorumVerifier, true);
                        }
                    }
                    catch (IOException iOException) {
                        LOG.d("Error writing next dynamic config file to disk", iOException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuorumVerifier setQuorumVerifier(QuorumVerifier quorumVerifier, boolean bl2) {
        Object object = this.QV_LOCK;
        synchronized (object) {
            Object object2;
            if (this.quorumVerifier != null && this.quorumVerifier.getVersion() >= quorumVerifier.getVersion()) {
                LOG.b("{} setQuorumVerifier called with known or old config {}. Current version: {}", this.getMyId(), quorumVerifier.getVersion(), this.quorumVerifier.getVersion());
                return this.quorumVerifier;
            }
            QuorumVerifier quorumVerifier2 = this.quorumVerifier;
            this.quorumVerifier = quorumVerifier;
            if (this.lastSeenQuorumVerifier == null || quorumVerifier.getVersion() > this.lastSeenQuorumVerifier.getVersion()) {
                this.lastSeenQuorumVerifier = quorumVerifier;
            }
            if (bl2) {
                if (this.configFilename != null) {
                    try {
                        object2 = this.makeDynamicConfigFilename(quorumVerifier.getVersion());
                        QuorumPeerConfig.writeDynamicConfig((String)object2, quorumVerifier, false);
                        QuorumPeerConfig.editStaticConfig(this.configFilename, (String)object2, this.needEraseClientInfoFromStaticConfig());
                    }
                    catch (IOException iOException) {
                        LOG.d("Error closing file", iOException);
                    }
                } else {
                    LOG.c("writeToDisk == true but configFilename == null");
                }
            }
            if (quorumVerifier.getVersion() == this.lastSeenQuorumVerifier.getVersion()) {
                QuorumPeerConfig.deleteFile(this.getNextDynamicConfigFilename());
            }
            if ((object2 = quorumVerifier.getAllMembers().get(this.getMyId())) != null) {
                this.setAddrs(((QuorumServer)object2).addr, ((QuorumServer)object2).electionAddr, ((QuorumServer)object2).clientAddr);
            }
            this.updateObserverMasterList();
            return quorumVerifier2;
        }
    }

    private String makeDynamicConfigFilename(long l2) {
        return this.configFilename + ".dynamic." + Long.toHexString(l2);
    }

    private boolean needEraseClientInfoFromStaticConfig() {
        QuorumServer quorumServer = this.quorumVerifier.getAllMembers().get(this.getMyId());
        return quorumServer != null && quorumServer.clientAddr != null && !quorumServer.isClientAddrFromStatic;
    }

    public Election getElectionAlg() {
        return this.electionAlg;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public void setSyncLimit(int n2) {
        LOG.c("syncLimit set to {}", (Object)n2);
        this.syncLimit = n2;
    }

    public int getConnectToLearnerMasterLimit() {
        return this.connectToLearnerMasterLimit;
    }

    public void setConnectToLearnerMasterLimit(int n2) {
        LOG.c("connectToLearnerMasterLimit set to {}", (Object)n2);
        this.connectToLearnerMasterLimit = n2;
    }

    public boolean getSyncEnabled() {
        if (System.getProperty(SYNC_ENABLED) != null) {
            LOG.c("{}={}", (Object)SYNC_ENABLED, (Object)Boolean.getBoolean(SYNC_ENABLED));
            return Boolean.getBoolean(SYNC_ENABLED);
        }
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean bl2) {
        this.syncEnabled = bl2;
    }

    public int getElectionType() {
        return this.electionType;
    }

    public void setElectionType(int n2) {
        this.electionType = n2;
    }

    public boolean getQuorumListenOnAllIPs() {
        return this.quorumListenOnAllIPs;
    }

    public void setQuorumListenOnAllIPs(boolean bl2) {
        this.quorumListenOnAllIPs = bl2;
    }

    public void setCnxnFactory(ServerCnxnFactory serverCnxnFactory) {
        this.cnxnFactory = serverCnxnFactory;
    }

    public void setSecureCnxnFactory(ServerCnxnFactory serverCnxnFactory) {
        this.secureCnxnFactory = serverCnxnFactory;
    }

    public void setSslQuorum(boolean bl2) {
        if (bl2) {
            LOG.c("Using TLS encrypted quorum communication");
        } else {
            LOG.c("Using insecure (non-TLS) quorum communication");
        }
        this.sslQuorum = bl2;
    }

    public void setUsePortUnification(boolean bl2) {
        LOG.c("Port unification {}", (Object)(bl2 ? "enabled" : "disabled"));
        this.shouldUsePortUnification = bl2;
    }

    private void startServerCnxnFactory() {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.start();
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.start();
        }
    }

    private void shutdownServerCnxnFactory() {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.shutdown();
        }
    }

    public void setZooKeeperServer(ZooKeeperServer zooKeeperServer) {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.setZooKeeperServer(zooKeeperServer);
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.setZooKeeperServer(zooKeeperServer);
        }
    }

    public void closeAllConnections() {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.closeAll(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.closeAll(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
        }
    }

    public int getClientPort() {
        if (this.cnxnFactory != null) {
            return this.cnxnFactory.getLocalPort();
        }
        return -1;
    }

    public int getSecureClientPort() {
        if (this.secureCnxnFactory != null) {
            return this.secureCnxnFactory.getLocalPort();
        }
        return -1;
    }

    public void setTxnFactory(FileTxnSnapLog fileTxnSnapLog) {
        this.logFactory = fileTxnSnapLog;
    }

    public FileTxnSnapLog getTxnFactory() {
        return this.logFactory;
    }

    public void setZKDatabase(ZKDatabase zKDatabase) {
        this.zkDb = zKDatabase;
    }

    protected ZKDatabase getZkDb() {
        return this.zkDb;
    }

    public synchronized void initConfigInZKDatabase() {
        if (this.zkDb != null) {
            this.zkDb.initConfigInZKDatabase(this.getQuorumVerifier());
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public QuorumCnxManager getQuorumCnxManager() {
        return this.qcmRef.get();
    }

    private long readLongFromFile(String string) throws IOException {
        File file = new File(this.logFactory.getSnapDir(), string);
        String string2 = "";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            string2 = bufferedReader.readLine();
            long l2 = Long.parseLong(string2);
            return l2;
        }
    }

    void writeLongToFile(String string, final long l2) throws IOException {
        File file = new File(this.logFactory.getSnapDir(), string);
        new AtomicFileWritingIdiom(file, new AtomicFileWritingIdiom.WriterStatement(){

            @Override
            public void write(Writer writer) throws IOException {
                writer.write(Long.toString(l2));
            }
        });
    }

    public long getCurrentEpoch() throws IOException {
        if (this.currentEpoch == -1L) {
            this.currentEpoch = this.readLongFromFile(CURRENT_EPOCH_FILENAME);
        }
        return this.currentEpoch;
    }

    public long getAcceptedEpoch() throws IOException {
        if (this.acceptedEpoch == -1L) {
            this.acceptedEpoch = this.readLongFromFile(ACCEPTED_EPOCH_FILENAME);
        }
        return this.acceptedEpoch;
    }

    public void setCurrentEpoch(long l2) throws IOException {
        this.writeLongToFile(CURRENT_EPOCH_FILENAME, l2);
        this.currentEpoch = l2;
    }

    public void setAcceptedEpoch(long l2) throws IOException {
        this.writeLongToFile(ACCEPTED_EPOCH_FILENAME, l2);
        this.acceptedEpoch = l2;
    }

    public boolean processReconfig(QuorumVerifier quorumVerifier, Long l2, Long l3, boolean bl2) {
        if (!this.isReconfigEnabled()) {
            LOG.b("Reconfig feature is disabled, skip reconfig processing.");
            return false;
        }
        InetSocketAddress inetSocketAddress = this.getClientAddress();
        QuorumVerifier quorumVerifier2 = this.setQuorumVerifier(quorumVerifier, true);
        this.initConfigInZKDatabase();
        if (quorumVerifier2.getVersion() < quorumVerifier.getVersion() && !quorumVerifier2.equals(quorumVerifier)) {
            QuorumServer quorumServer;
            Map<Long, QuorumServer> map = quorumVerifier.getAllMembers();
            this.updateRemotePeerMXBeans(map);
            if (bl2) {
                this.restartLeaderElection(quorumVerifier2, quorumVerifier);
            }
            if ((quorumServer = map.get(this.getMyId())) != null && quorumServer.clientAddr != null && !quorumServer.clientAddr.equals(inetSocketAddress)) {
                this.cnxnFactory.reconfigure(quorumServer.clientAddr);
                this.updateThreadName();
            }
            boolean bl3 = this.updateLearnerType(quorumVerifier);
            boolean bl4 = false;
            if (l2 != null) {
                bl4 = this.updateVote(l2, l3);
            } else {
                long l4 = this.getCurrentVote().getId();
                QuorumServer quorumServer2 = quorumVerifier2.getVotingMembers().get(l4);
                QuorumServer quorumServer3 = quorumVerifier.getVotingMembers().get(l4);
                bl4 = quorumServer2 == null || quorumServer2.addr == null || quorumServer3 == null || !quorumServer2.addr.equals(quorumServer3.addr);
                this.reconfigFlagClear();
            }
            return bl3 || bl4;
        }
        return false;
    }

    private void updateRemotePeerMXBeans(Map<Long, QuorumServer> map) {
        RemotePeerBean remotePeerBean;
        Iterator iterator;
        HashSet<Long> hashSet2 = new HashSet<Long>(map.keySet());
        hashSet2.retainAll(this.jmxRemotePeerBean.keySet());
        for (Long hashSet3 : hashSet2) {
            iterator = this.jmxRemotePeerBean.get(hashSet3);
            ((RemotePeerBean)((Object)iterator)).setQuorumServer(map.get(hashSet3));
        }
        HashSet<Long> hashSet4 = new HashSet<Long>(map.keySet());
        hashSet4.removeAll(this.jmxRemotePeerBean.keySet());
        hashSet4.remove(this.getMyId());
        Iterator iterator2 = hashSet4.iterator();
        while (iterator2.hasNext()) {
            iterator = (Long)iterator2.next();
            QuorumServer quorumServer = map.get(iterator);
            remotePeerBean = new RemotePeerBean(this, quorumServer);
            try {
                MBeanRegistry.getInstance().register(remotePeerBean, this.jmxQuorumBean);
                this.jmxRemotePeerBean.put(quorumServer.id, remotePeerBean);
            }
            catch (Exception exception) {
                LOG.c("Failed to register with JMX", exception);
            }
        }
        HashSet<Long> hashSet = new HashSet<Long>(this.jmxRemotePeerBean.keySet());
        hashSet.removeAll(map.keySet());
        for (Long l2 : hashSet) {
            remotePeerBean = this.jmxRemotePeerBean.remove(l2);
            try {
                MBeanRegistry.getInstance().unregister(remotePeerBean);
            }
            catch (Exception exception) {
                LOG.c("Failed to unregister with JMX", exception);
            }
        }
    }

    private void updateObserverMasterList() {
        if (this.observerMasterPort <= 0) {
            return;
        }
        this.observerMasters.clear();
        StringBuilder stringBuilder = new StringBuilder();
        for (QuorumServer quorumServer : this.quorumVerifier.getVotingMembers().values()) {
            InetAddress inetAddress = quorumServer.addr.getReachableOrOne().getAddress();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.observerMasterPort);
            this.observerMasters.add(new QuorumServer(quorumServer.id, inetSocketAddress));
            stringBuilder.append(inetSocketAddress).append(",");
        }
        LOG.c("Updated learner master list to be {}", (Object)stringBuilder.toString());
        Collections.shuffle(this.observerMasters);
        this.nextObserverMaster = 0;
    }

    private boolean useObserverMasters() {
        return this.getLearnerType() == LearnerType.OBSERVER && this.observerMasters.size() > 0;
    }

    private QuorumServer nextObserverMaster() {
        if (this.nextObserverMaster >= this.observerMasters.size()) {
            this.nextObserverMaster = 0;
            if (this.isRunning()) {
                Observer.waitForReconnectDelay();
            }
        }
        return this.observerMasters.get(this.nextObserverMaster++);
    }

    QuorumServer findLearnerMaster(QuorumServer quorumServer) {
        if (this.useObserverMasters()) {
            return this.nextObserverMaster();
        }
        if (this.isRunning()) {
            Observer.waitForReconnectDelay();
        }
        return quorumServer;
    }

    QuorumServer validateLearnerMaster(String string) {
        if (this.useObserverMasters()) {
            Long l2;
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = null;
            }
            for (QuorumServer quorumServer : this.observerMasters) {
                if (l2 == null) {
                    for (InetSocketAddress inetSocketAddress : quorumServer.addr.getAllAddresses()) {
                        String string2 = inetSocketAddress.getAddress().getHostAddress() + ':' + inetSocketAddress.getPort();
                        if (!string2.startsWith(string)) continue;
                        return quorumServer;
                    }
                    continue;
                }
                if (!l2.equals(quorumServer.id)) continue;
                return quorumServer;
            }
            if (l2 == null) {
                LOG.c("could not find learner master address={}", (Object)string);
            } else {
                LOG.d("could not find learner master sid={}", (Object)l2);
            }
        } else {
            LOG.c("cannot validate request, observer masters not enabled");
        }
        return null;
    }

    private boolean updateLearnerType(QuorumVerifier quorumVerifier) {
        if (quorumVerifier.getObservingMembers().containsKey(this.getMyId())) {
            if (this.getLearnerType() != LearnerType.OBSERVER) {
                this.setLearnerType(LearnerType.OBSERVER);
                LOG.c("Becoming an observer");
                this.reconfigFlagSet();
                return true;
            }
            return false;
        }
        if (quorumVerifier.getVotingMembers().containsKey(this.getMyId())) {
            if (this.getLearnerType() != LearnerType.PARTICIPANT) {
                this.setLearnerType(LearnerType.PARTICIPANT);
                LOG.c("Becoming a voting participant");
                this.reconfigFlagSet();
                return true;
            }
            return false;
        }
        if (this.getLearnerType() != LearnerType.PARTICIPANT) {
            this.setLearnerType(LearnerType.PARTICIPANT);
            LOG.c("Becoming a non-voting participant");
            this.reconfigFlagSet();
            return true;
        }
        return false;
    }

    private boolean updateVote(long l2, long l3) {
        Vote vote = this.getCurrentVote();
        if (vote != null && l2 != vote.getId()) {
            this.setCurrentVote(new Vote(l2, l3));
            this.reconfigFlagSet();
            LOG.d("Suggested leader: {}", (Object)l2);
            return true;
        }
        return false;
    }

    protected void updateElectionVote(long l2) {
        Vote vote = this.getCurrentVote();
        if (vote != null) {
            this.setCurrentVote(new Vote(vote.getId(), vote.getZxid(), vote.getElectionEpoch(), l2, vote.getState()));
        }
    }

    private void updateThreadName() {
        String string = this.cnxnFactory != null ? (this.cnxnFactory.getLocalAddress() != null ? NetUtils.formatInetAddr(this.cnxnFactory.getLocalAddress()) : "disabled") : "disabled";
        String string2 = this.secureCnxnFactory != null ? NetUtils.formatInetAddr(this.secureCnxnFactory.getLocalAddress()) : "disabled";
        this.setName(String.format("QuorumPeer[myid=%d](plain=%s)(secure=%s)", this.getMyId(), string, string2));
    }

    void setElectionTimeTaken(long l2) {
        this.electionTimeTaken = l2;
    }

    long getElectionTimeTaken() {
        return this.electionTimeTaken;
    }

    void setQuorumServerSaslRequired(boolean bl2) {
        this.quorumServerSaslAuthRequired = bl2;
        LOG.c("{} set to {}", (Object)"quorum.auth.serverRequireSasl", (Object)bl2);
    }

    void setQuorumLearnerSaslRequired(boolean bl2) {
        this.quorumLearnerSaslAuthRequired = bl2;
        LOG.c("{} set to {}", (Object)"quorum.auth.learnerRequireSasl", (Object)bl2);
    }

    void setQuorumSaslEnabled(boolean bl2) {
        this.quorumSaslEnableAuth = bl2;
        if (!this.quorumSaslEnableAuth) {
            LOG.c("QuorumPeer communication is not secured! (SASL auth disabled)");
        } else {
            LOG.c("{} set to {}", (Object)"quorum.auth.enableSasl", (Object)bl2);
        }
    }

    void setQuorumServicePrincipal(String string) {
        this.quorumServicePrincipal = string;
        LOG.c("{} set to {}", (Object)"quorum.auth.kerberos.servicePrincipal", (Object)this.quorumServicePrincipal);
    }

    void setQuorumLearnerLoginContext(String string) {
        this.quorumLearnerLoginContext = string;
        LOG.c("{} set to {}", (Object)"quorum.auth.learner.saslLoginContext", (Object)this.quorumLearnerLoginContext);
    }

    void setQuorumServerLoginContext(String string) {
        this.quorumServerLoginContext = string;
        LOG.c("{} set to {}", (Object)"quorum.auth.server.saslLoginContext", (Object)this.quorumServerLoginContext);
    }

    void setQuorumCnxnThreadsSize(int n2) {
        if (n2 > 20) {
            this.quorumCnxnThreadsSize = n2;
        }
        LOG.c("quorum.cnxn.threads.size set to {}", (Object)this.quorumCnxnThreadsSize);
    }

    boolean isQuorumSaslAuthEnabled() {
        return this.quorumSaslEnableAuth;
    }

    private boolean isQuorumServerSaslAuthRequired() {
        return this.quorumServerSaslAuthRequired;
    }

    private boolean isQuorumLearnerSaslAuthRequired() {
        return this.quorumLearnerSaslAuthRequired;
    }

    public QuorumCnxManager createCnxnManager() {
        int n2 = quorumCnxnTimeoutMs > 0 ? quorumCnxnTimeoutMs : this.tickTime * this.syncLimit;
        LOG.c("Using {}ms as the quorum cnxn socket timeout", (Object)n2);
        return new QuorumCnxManager(this, this.getMyId(), this.getView(), this.authServer, this.authLearner, n2, this.getQuorumListenOnAllIPs(), this.quorumCnxnThreadsSize, this.isQuorumSaslAuthEnabled());
    }

    boolean isLeader(long l2) {
        Vote vote = this.getCurrentVote();
        return vote != null && l2 == vote.getId();
    }

    public boolean isReconfigEnabled() {
        return this.reconfigEnabled;
    }

    public Integer getSynced_observers_metric() {
        if (this.leader != null) {
            return this.leader.getObservingLearners().size();
        }
        if (this.follower != null) {
            return this.follower.getSyncedObserverSize();
        }
        return null;
    }

    public static QuorumPeer createFromConfig(QuorumPeerConfig quorumPeerConfig) throws IOException {
        QuorumPeer quorumPeer = new QuorumPeer();
        quorumPeer.setTxnFactory(new FileTxnSnapLog(quorumPeerConfig.getDataLogDir(), quorumPeerConfig.getDataDir()));
        quorumPeer.enableLocalSessions(quorumPeerConfig.areLocalSessionsEnabled());
        quorumPeer.enableLocalSessionsUpgrading(quorumPeerConfig.isLocalSessionsUpgradingEnabled());
        quorumPeer.setElectionType(quorumPeerConfig.getElectionAlg());
        quorumPeer.setMyid(quorumPeerConfig.getServerId());
        quorumPeer.setTickTime(quorumPeerConfig.getTickTime());
        quorumPeer.setMinSessionTimeout(quorumPeerConfig.getMinSessionTimeout());
        quorumPeer.setMaxSessionTimeout(quorumPeerConfig.getMaxSessionTimeout());
        quorumPeer.setInitLimit(quorumPeerConfig.getInitLimit());
        quorumPeer.setSyncLimit(quorumPeerConfig.getSyncLimit());
        quorumPeer.setConnectToLearnerMasterLimit(quorumPeerConfig.getConnectToLearnerMasterLimit());
        quorumPeer.setObserverMasterPort(quorumPeerConfig.getObserverMasterPort());
        quorumPeer.setConfigFileName(quorumPeerConfig.getConfigFilename());
        quorumPeer.setClientPortListenBacklog(quorumPeerConfig.getClientPortListenBacklog());
        quorumPeer.setZKDatabase(new ZKDatabase(quorumPeer.getTxnFactory()));
        quorumPeer.setQuorumVerifier(quorumPeerConfig.getQuorumVerifier(), false);
        if (quorumPeerConfig.getLastSeenQuorumVerifier() != null) {
            quorumPeer.setLastSeenQuorumVerifier(quorumPeerConfig.getLastSeenQuorumVerifier(), false);
        }
        quorumPeer.initConfigInZKDatabase();
        quorumPeer.setSslQuorum(quorumPeerConfig.isSslQuorum());
        quorumPeer.setUsePortUnification(quorumPeerConfig.shouldUsePortUnification());
        quorumPeer.setLearnerType(quorumPeerConfig.getPeerType());
        quorumPeer.setSyncEnabled(quorumPeerConfig.getSyncEnabled());
        quorumPeer.setQuorumListenOnAllIPs(quorumPeerConfig.getQuorumListenOnAllIPs());
        if (quorumPeerConfig.sslQuorumReloadCertFiles) {
            quorumPeer.getX509Util().enableCertFileReloading();
        }
        quorumPeer.setMultiAddressEnabled(quorumPeerConfig.isMultiAddressEnabled());
        quorumPeer.setMultiAddressReachabilityCheckEnabled(quorumPeerConfig.isMultiAddressReachabilityCheckEnabled());
        quorumPeer.setMultiAddressReachabilityCheckTimeoutMs(quorumPeerConfig.getMultiAddressReachabilityCheckTimeoutMs());
        quorumPeer.setQuorumSaslEnabled(quorumPeerConfig.quorumEnableSasl);
        if (quorumPeer.isQuorumSaslAuthEnabled()) {
            quorumPeer.setQuorumServerSaslRequired(quorumPeerConfig.quorumServerRequireSasl);
            quorumPeer.setQuorumLearnerSaslRequired(quorumPeerConfig.quorumLearnerRequireSasl);
            quorumPeer.setQuorumServicePrincipal(quorumPeerConfig.quorumServicePrincipal);
            quorumPeer.setQuorumServerLoginContext(quorumPeerConfig.quorumServerLoginContext);
            quorumPeer.setQuorumLearnerLoginContext(quorumPeerConfig.quorumLearnerLoginContext);
        }
        quorumPeer.setQuorumCnxnThreadsSize(quorumPeerConfig.quorumCnxnThreadsSize);
        if (quorumPeerConfig.jvmPauseMonitorToRun) {
            quorumPeer.setJvmPauseMonitor(new JvmPauseMonitor(quorumPeerConfig));
        }
        return quorumPeer;
    }

    static {
        LOG.c("{}={}", (Object)QUORUM_CNXN_TIMEOUT_MS, (Object)quorumCnxnTimeoutMs);
    }

    class ResponderThread
    extends ZooKeeperThread {
        volatile boolean running;

        ResponderThread() {
            super("ResponderThread");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] byArray = new byte[36];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                while (this.running) {
                    QuorumPeer.this.udpSocket.receive(datagramPacket);
                    if (datagramPacket.getLength() != 4) {
                        LOG.d("Got more than just an xid! Len = {}", (Object)datagramPacket.getLength());
                    } else {
                        byteBuffer.clear();
                        byteBuffer.getInt();
                        byteBuffer.putLong(QuorumPeer.this.myid);
                        Vote vote = QuorumPeer.this.getCurrentVote();
                        switch (QuorumPeer.this.getPeerState()) {
                            case LOOKING: {
                                byteBuffer.putLong(vote.getId());
                                byteBuffer.putLong(vote.getZxid());
                                break;
                            }
                            case LEADING: {
                                byteBuffer.putLong(QuorumPeer.this.myid);
                                try {
                                    long l2;
                                    Leader leader = QuorumPeer.this.leader;
                                    synchronized (leader) {
                                        l2 = QuorumPeer.this.leader.lastProposed;
                                    }
                                    byteBuffer.putLong(l2);
                                }
                                catch (NullPointerException nullPointerException) {}
                                break;
                            }
                            case FOLLOWING: {
                                byteBuffer.putLong(vote.getId());
                                try {
                                    byteBuffer.putLong(QuorumPeer.this.follower.getZxid());
                                }
                                catch (NullPointerException nullPointerException) {}
                                break;
                            }
                        }
                        datagramPacket.setData(byArray);
                        QuorumPeer.this.udpSocket.send(datagramPacket);
                    }
                    datagramPacket.setLength(byArray.length);
                }
            }
            catch (RuntimeException runtimeException) {
                LOG.c("Unexpected runtime exception in ResponderThread", runtimeException);
            }
            catch (IOException iOException) {
                LOG.c("Unexpected IO exception in ResponderThread", iOException);
            }
            finally {
                LOG.d("QuorumPeer responder thread exited");
            }
        }
    }

    public static enum LearnerType {
        PARTICIPANT,
        OBSERVER;

    }

    public static enum SyncMode {
        NONE,
        DIFF,
        SNAP,
        TRUNC;

    }

    public static enum ZabState {
        ELECTION,
        DISCOVERY,
        SYNCHRONIZATION,
        BROADCAST;

    }

    public static enum ServerState {
        LOOKING,
        FOLLOWING,
        LEADING,
        OBSERVING;

    }

    public static class QuorumServer {
        public MultipleAddresses addr = new MultipleAddresses();
        public MultipleAddresses electionAddr = new MultipleAddresses();
        public InetSocketAddress clientAddr = null;
        public long id;
        public String hostname;
        public LearnerType type = LearnerType.PARTICIPANT;
        public boolean isClientAddrFromStatic = false;
        private List<InetSocketAddress> myAddrs;
        private static final String wrongFormat = " does not have the form server_config or server_config;client_config where server_config is the pipe separated list of host:port:port or host:port:port:type and client_config is port or host:port";

        public QuorumServer(long l2, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3) {
            this(l2, inetSocketAddress, inetSocketAddress2, inetSocketAddress3, LearnerType.PARTICIPANT);
        }

        public QuorumServer(long l2, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            this(l2, inetSocketAddress, inetSocketAddress2, null, LearnerType.PARTICIPANT);
        }

        public QuorumServer(long l2, InetSocketAddress inetSocketAddress) {
            this(l2, inetSocketAddress, null, null, LearnerType.PARTICIPANT);
        }

        public long getId() {
            return this.id;
        }

        public void recreateSocketAddresses() {
            if (this.addr.isEmpty()) {
                LOG.d("Server address has not been initialized");
                return;
            }
            if (this.electionAddr.isEmpty()) {
                LOG.d("Election address has not been initialized");
                return;
            }
            this.addr.recreateSocketAddresses();
            this.electionAddr.recreateSocketAddresses();
        }

        private LearnerType getType(String string) throws QuorumPeerConfig.ConfigException {
            switch (string.trim().toLowerCase()) {
                case "observer": {
                    return LearnerType.OBSERVER;
                }
                case "participant": {
                    return LearnerType.PARTICIPANT;
                }
            }
            throw new QuorumPeerConfig.ConfigException("Unrecognised peertype: " + string);
        }

        public QuorumServer(long l2, String string) throws QuorumPeerConfig.ConfigException {
            this(l2, string, QuorumServer::getInetAddress);
        }

        QuorumServer(long l2, String string, Function<InetSocketAddress, InetAddress> function) throws QuorumPeerConfig.ConfigException {
            this.id = l2;
            this.initializeWithAddressString(string, function);
        }

        public QuorumServer(long l2, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, LearnerType learnerType) {
            this(l2, inetSocketAddress, inetSocketAddress2, null, learnerType);
        }

        public QuorumServer(long l2, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3, LearnerType learnerType) {
            this.id = l2;
            if (inetSocketAddress != null) {
                this.addr.addAddress(inetSocketAddress);
            }
            if (inetSocketAddress2 != null) {
                this.electionAddr.addAddress(inetSocketAddress2);
            }
            this.type = learnerType;
            this.clientAddr = inetSocketAddress3;
            this.setMyAddrs();
        }

        private void initializeWithAddressString(String string, Function<InetSocketAddress, InetAddress> function) throws QuorumPeerConfig.ConfigException {
            boolean bl2;
            Object object = null;
            String[] stringArray = string.split(";");
            String[] stringArray2 = stringArray[0].split("\\|");
            if (stringArray.length == 2) {
                String[] stringArray3 = ConfigUtils.getHostAndPort(stringArray[1]);
                if (stringArray3.length > 2) {
                    throw new QuorumPeerConfig.ConfigException(string + wrongFormat);
                }
                String string2 = stringArray3.length == 2 ? stringArray3[0] : "0.0.0.0";
                try {
                    this.clientAddr = new InetSocketAddress(string2, Integer.parseInt(stringArray3[stringArray3.length - 1]));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new QuorumPeerConfig.ConfigException("Address unresolved: " + this.hostname + ":" + stringArray3[stringArray3.length - 1]);
                }
            }
            if (!(bl2 = Boolean.parseBoolean(System.getProperty(QuorumPeer.CONFIG_KEY_MULTI_ADDRESS_ENABLED, "false"))) && stringArray2.length > 1) {
                throw new QuorumPeerConfig.ConfigException("Multiple address feature is disabled, but multiple addresses were specified for sid " + this.id);
            }
            boolean bl3 = Boolean.parseBoolean(System.getProperty(QuorumPeer.CONFIG_KEY_KERBEROS_CANONICALIZE_HOST_NAMES, "false"));
            for (String string3 : stringArray2) {
                Object object2;
                InetSocketAddress inetSocketAddress;
                InetSocketAddress inetSocketAddress2;
                String[] stringArray4 = ConfigUtils.getHostAndPort(string3);
                if (stringArray.length > 2 || stringArray4.length < 3 || stringArray4.length > 4) {
                    throw new QuorumPeerConfig.ConfigException(string + wrongFormat);
                }
                String string4 = stringArray4[0];
                try {
                    inetSocketAddress2 = new InetSocketAddress(string4, Integer.parseInt(stringArray4[1]));
                    this.addr.addAddress(inetSocketAddress2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new QuorumPeerConfig.ConfigException("Address unresolved: " + string4 + ":" + stringArray4[1]);
                }
                try {
                    inetSocketAddress = new InetSocketAddress(string4, Integer.parseInt(stringArray4[2]));
                    this.electionAddr.addAddress(inetSocketAddress);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new QuorumPeerConfig.ConfigException("Address unresolved: " + string4 + ":" + stringArray4[2]);
                }
                if (inetSocketAddress2.getPort() == inetSocketAddress.getPort()) {
                    throw new QuorumPeerConfig.ConfigException("Client and election port must be different! Please update the configuration file on server." + this.id);
                }
                if (bl3) {
                    object2 = function.apply(inetSocketAddress2);
                    if (object2 == null) {
                        throw new QuorumPeerConfig.ConfigException("Unable to canonicalize address " + string4 + " because it's not resolvable");
                    }
                    String string5 = ((InetAddress)object2).getCanonicalHostName();
                    if (!string5.equals(string4) && !string5.equals(((InetAddress)object2).getHostAddress())) {
                        LOG.c("Host name for quorum server {} canonicalized from {} to {}", this.id, string4, string5);
                        string4 = string5;
                    }
                }
                if (stringArray4.length == 4) {
                    object2 = this.getType(stringArray4[3]);
                    if (object == null) {
                        object = object2;
                    }
                    if (object != object2) {
                        throw new QuorumPeerConfig.ConfigException("Multiple addresses should have similar roles: " + (Object)((Object)this.type) + " vs " + object2);
                    }
                }
                this.hostname = string4;
            }
            if (object != null) {
                this.type = object;
            }
            this.setMyAddrs();
        }

        private static InetAddress getInetAddress(InetSocketAddress inetSocketAddress) {
            return inetSocketAddress.getAddress();
        }

        private void setMyAddrs() {
            this.myAddrs = new ArrayList<InetSocketAddress>();
            this.myAddrs.addAll(this.addr.getAllAddresses());
            this.myAddrs.add(this.clientAddr);
            this.myAddrs.addAll(this.electionAddr.getAllAddresses());
            this.myAddrs = this.excludedSpecialAddresses(this.myAddrs);
        }

        public static String delimitedHostString(InetSocketAddress inetSocketAddress) {
            String string = inetSocketAddress.getHostString();
            if (string.contains(":")) {
                return "[" + string + "]";
            }
            return string;
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            LinkedList<InetSocketAddress> linkedList = new LinkedList<InetSocketAddress>(this.addr.getAllAddresses());
            LinkedList<InetSocketAddress> linkedList2 = new LinkedList<InetSocketAddress>(this.electionAddr.getAllAddresses());
            if (linkedList.size() > 0 && linkedList2.size() > 0) {
                linkedList.sort(Comparator.comparing(InetSocketAddress::getHostString));
                linkedList2.sort(Comparator.comparing(InetSocketAddress::getHostString));
                stringWriter.append(IntStream.range(0, linkedList.size()).mapToObj(n2 -> String.format("%s:%d:%d", QuorumServer.delimitedHostString((InetSocketAddress)linkedList.get(n2)), ((InetSocketAddress)linkedList.get(n2)).getPort(), ((InetSocketAddress)linkedList2.get(n2)).getPort())).collect(Collectors.joining("|")));
            }
            if (this.type == LearnerType.OBSERVER) {
                stringWriter.append(":observer");
            } else if (this.type == LearnerType.PARTICIPANT) {
                stringWriter.append(":participant");
            }
            if (this.clientAddr != null && !this.isClientAddrFromStatic) {
                stringWriter.append(";");
                stringWriter.append(QuorumServer.delimitedHostString(this.clientAddr));
                stringWriter.append(":");
                stringWriter.append(String.valueOf(this.clientAddr.getPort()));
            }
            return stringWriter.toString();
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        private boolean checkAddressesEqual(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            return !(inetSocketAddress == null && inetSocketAddress2 != null || inetSocketAddress != null && inetSocketAddress2 == null || inetSocketAddress != null && inetSocketAddress2 != null && !inetSocketAddress.equals(inetSocketAddress2));
        }

        public boolean equals(Object object) {
            if (!(object instanceof QuorumServer)) {
                return false;
            }
            QuorumServer quorumServer = (QuorumServer)object;
            if (quorumServer.id != this.id || quorumServer.type != this.type) {
                return false;
            }
            if (!this.addr.equals(quorumServer.addr)) {
                return false;
            }
            if (!this.electionAddr.equals(quorumServer.electionAddr)) {
                return false;
            }
            return this.checkAddressesEqual(this.clientAddr, quorumServer.clientAddr);
        }

        public void checkAddressDuplicate(QuorumServer quorumServer) throws KeeperException.BadArgumentsException {
            List<InetSocketAddress> list = new ArrayList<InetSocketAddress>(quorumServer.addr.getAllAddresses());
            list.add(quorumServer.clientAddr);
            list.addAll(quorumServer.electionAddr.getAllAddresses());
            list = this.excludedSpecialAddresses(list);
            for (InetSocketAddress inetSocketAddress : this.myAddrs) {
                for (InetSocketAddress inetSocketAddress2 : list) {
                    if (!inetSocketAddress.equals(inetSocketAddress2)) continue;
                    String string = String.format("%s of server.%d conflicts %s of server.%d", inetSocketAddress, this.id, inetSocketAddress2, quorumServer.id);
                    throw new KeeperException.BadArgumentsException(string);
                }
            }
        }

        private List<InetSocketAddress> excludedSpecialAddresses(List<InetSocketAddress> list) {
            ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>();
            for (InetSocketAddress inetSocketAddress : list) {
                InetAddress inetAddress;
                if (inetSocketAddress == null || (inetAddress = inetSocketAddress.getAddress()) == null || inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) continue;
                arrayList.add(inetSocketAddress);
            }
            return arrayList;
        }
    }

    public static final class AddressTuple {
        public final MultipleAddresses quorumAddr;
        public final MultipleAddresses electionAddr;
        public final InetSocketAddress clientAddr;

        public AddressTuple(MultipleAddresses multipleAddresses, MultipleAddresses multipleAddresses2, InetSocketAddress inetSocketAddress) {
            this.quorumAddr = multipleAddresses;
            this.electionAddr = multipleAddresses2;
            this.clientAddr = inetSocketAddress;
        }
    }
}

