/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SyncRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.AckRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerSyncRequest;

public class ProposalRequestProcessor
implements RequestProcessor {
    private static final foe LOG = goe.a(ProposalRequestProcessor.class);
    LeaderZooKeeperServer zks;
    RequestProcessor nextProcessor;
    SyncRequestProcessor syncProcessor;
    public static final String FORWARD_LEARNER_REQUESTS_TO_COMMIT_PROCESSOR_DISABLED = "zookeeper.forward_learner_requests_to_commit_processor_disabled";
    private final boolean forwardLearnerRequestsToCommitProcessorDisabled;

    public ProposalRequestProcessor(LeaderZooKeeperServer leaderZooKeeperServer, RequestProcessor requestProcessor) {
        this.zks = leaderZooKeeperServer;
        this.nextProcessor = requestProcessor;
        AckRequestProcessor ackRequestProcessor = new AckRequestProcessor(leaderZooKeeperServer.getLeader());
        this.syncProcessor = new SyncRequestProcessor(leaderZooKeeperServer, ackRequestProcessor);
        this.forwardLearnerRequestsToCommitProcessorDisabled = Boolean.getBoolean(FORWARD_LEARNER_REQUESTS_TO_COMMIT_PROCESSOR_DISABLED);
        LOG.c("{} = {}", (Object)FORWARD_LEARNER_REQUESTS_TO_COMMIT_PROCESSOR_DISABLED, (Object)this.forwardLearnerRequestsToCommitProcessorDisabled);
    }

    public void initialize() {
        this.syncProcessor.start();
    }

    @Override
    public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
        if (request instanceof LearnerSyncRequest) {
            this.zks.getLeader().processSync((LearnerSyncRequest)request);
        } else {
            if (this.shouldForwardToNextProcessor(request)) {
                this.nextProcessor.processRequest(request);
            }
            if (request.getHdr() != null) {
                try {
                    this.zks.getLeader().propose(request);
                }
                catch (Leader.XidRolloverException xidRolloverException) {
                    throw new RequestProcessor.RequestProcessorException(xidRolloverException.getMessage(), xidRolloverException);
                }
                this.syncProcessor.processRequest(request);
            }
        }
    }

    @Override
    public void shutdown() {
        LOG.c("Shutting down");
        this.nextProcessor.shutdown();
        this.syncProcessor.shutdown();
    }

    private boolean shouldForwardToNextProcessor(Request request) {
        if (!this.forwardLearnerRequestsToCommitProcessorDisabled) {
            return true;
        }
        if (request.getOwner() instanceof LearnerHandler) {
            ServerMetrics.getMetrics().REQUESTS_NOT_FORWARDED_TO_COMMIT_PROCESSOR.add(1L);
            return false;
        }
        return true;
    }
}

