/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SessionTrackerImpl;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerListener;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class LearnerSessionTracker
extends UpgradeableSessionTracker {
    private static final foe LOG = goe.a(LearnerSessionTracker.class);
    private final SessionTracker.SessionExpirer expirer;
    private final AtomicReference<Map<Long, Integer>> touchTable = new AtomicReference();
    private final long serverId;
    private final AtomicLong nextSessionId = new AtomicLong();
    private final ConcurrentMap<Long, Integer> globalSessionsWithTimeouts;

    public LearnerSessionTracker(SessionTracker.SessionExpirer sessionExpirer, ConcurrentMap<Long, Integer> concurrentMap, int n2, long l2, boolean bl2, ZooKeeperServerListener zooKeeperServerListener) {
        this.expirer = sessionExpirer;
        this.touchTable.set(new ConcurrentHashMap());
        this.globalSessionsWithTimeouts = concurrentMap;
        this.serverId = l2;
        this.nextSessionId.set(SessionTrackerImpl.initializeNextSessionId(this.serverId));
        this.localSessionsEnabled = bl2;
        if (this.localSessionsEnabled) {
            this.createLocalSessionTracker(sessionExpirer, n2, l2, zooKeeperServerListener);
        }
    }

    @Override
    public void removeSession(long l2) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.removeSession(l2);
        }
        this.globalSessionsWithTimeouts.remove(l2);
        this.touchTable.get().remove(l2);
    }

    @Override
    public void start() {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.start();
        }
    }

    @Override
    public void shutdown() {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.shutdown();
        }
    }

    @Override
    public boolean isGlobalSession(long l2) {
        return this.globalSessionsWithTimeouts.containsKey(l2);
    }

    @Override
    public boolean trackSession(long l2, int n2) {
        return false;
    }

    @Override
    public synchronized boolean commitSession(long l2, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = this.globalSessionsWithTimeouts.put(l2, n2) == null;
        if (bl2) {
            LOG.c("Committing global session 0x{}", (Object)Long.toHexString(l2));
        }
        if (this.localSessionsEnabled) {
            this.removeLocalSession(l2);
            this.finishedUpgrading(l2);
        }
        this.touchTable.get().put(l2, n2);
        return bl2;
    }

    @Override
    public boolean touchSession(long l2, int n2) {
        if (this.localSessionsEnabled) {
            if (this.localSessionTracker.touchSession(l2, n2)) {
                return true;
            }
            if (!this.isGlobalSession(l2) && !this.isUpgradingSession(l2)) {
                return false;
            }
        }
        this.touchTable.get().put(l2, n2);
        return true;
    }

    public Map<Long, Integer> snapshot() {
        return this.touchTable.getAndSet(new ConcurrentHashMap());
    }

    @Override
    public long createSession(int n2) {
        if (this.localSessionsEnabled) {
            return this.localSessionTracker.createSession(n2);
        }
        return this.nextSessionId.getAndIncrement();
    }

    @Override
    public void checkSession(long l2, Object object) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        block3: {
            if (this.localSessionTracker != null) {
                try {
                    this.localSessionTracker.checkSession(l2, object);
                    return;
                }
                catch (KeeperException.UnknownSessionException unknownSessionException) {
                    if (this.isGlobalSession(l2)) break block3;
                    throw new KeeperException.SessionExpiredException();
                }
            }
        }
    }

    @Override
    public void setOwner(long l2, Object object) throws KeeperException.SessionExpiredException {
        block3: {
            if (this.localSessionTracker != null) {
                try {
                    this.localSessionTracker.setOwner(l2, object);
                    return;
                }
                catch (KeeperException.SessionExpiredException sessionExpiredException) {
                    if (this.isGlobalSession(l2)) break block3;
                    throw sessionExpiredException;
                }
            }
        }
    }

    @Override
    public void dumpSessions(PrintWriter printWriter) {
        if (this.localSessionTracker != null) {
            printWriter.print("Local ");
            this.localSessionTracker.dumpSessions(printWriter);
        }
        printWriter.print("Global Sessions(");
        printWriter.print(this.globalSessionsWithTimeouts.size());
        printWriter.println("):");
        TreeSet treeSet = new TreeSet(this.globalSessionsWithTimeouts.keySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            printWriter.print("0x");
            printWriter.print(Long.toHexString(l2));
            printWriter.print("\t");
            printWriter.print(this.globalSessionsWithTimeouts.get(l2));
            printWriter.println("ms");
        }
    }

    @Override
    public void setSessionClosing(long l2) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.setSessionClosing(l2);
        }
    }

    @Override
    public Map<Long, Set<Long>> getSessionExpiryMap() {
        return new HashMap<Long, Set<Long>>();
    }

    @Override
    public Set<Long> globalSessions() {
        return this.globalSessionsWithTimeouts.keySet();
    }
}

