/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderMXBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;

public class LeaderBean
extends ZooKeeperServerBean
implements LeaderMXBean {
    private final Leader leader;

    public LeaderBean(Leader leader, ZooKeeperServer zooKeeperServer) {
        super(zooKeeperServer);
        this.leader = leader;
    }

    @Override
    public String getName() {
        return "Leader";
    }

    @Override
    public String getCurrentZxid() {
        return "0x" + Long.toHexString(this.zks.getZxid());
    }

    @Override
    public String followerInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (LearnerHandler learnerHandler : this.leader.getLearners()) {
            if (learnerHandler.getLearnerType() != QuorumPeer.LearnerType.PARTICIPANT) continue;
            stringBuilder.append(learnerHandler.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String nonVotingFollowerInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (LearnerHandler learnerHandler : this.leader.getNonVotingFollowers()) {
            stringBuilder.append(learnerHandler.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public long getElectionTimeTaken() {
        return this.leader.self.getElectionTimeTaken();
    }

    @Override
    public int getLastProposalSize() {
        return this.leader.getProposalStats().getLastBufferSize();
    }

    @Override
    public int getMinProposalSize() {
        return this.leader.getProposalStats().getMinBufferSize();
    }

    @Override
    public int getMaxProposalSize() {
        return this.leader.getProposalStats().getMaxBufferSize();
    }

    @Override
    public void resetProposalStatistics() {
        this.leader.getProposalStats().reset();
    }

    @Override
    public int getMaxConcurrentSnapSyncs() {
        return this.leader.getMaxConcurrentSnapSyncs();
    }

    @Override
    public void setMaxConcurrentSnapSyncs(int n2) {
        this.leader.setMaxConcurrentSnapSyncs(n2);
    }

    @Override
    public int getMaxConcurrentDiffSyncs() {
        return this.leader.getMaxConcurrentDiffSyncs();
    }

    @Override
    public void setMaxConcurrentDiffSyncs(int n2) {
        this.leader.setMaxConcurrentDiffSyncs(n2);
    }
}

