/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.FinalRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.BufferStats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandlerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerMaster;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPacket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.StateSummary;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.SyncedLearnerTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.UnifiedServerSocket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.auth.QuorumAuthServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.ZxidUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.security.sasl.SaslException;

public class Leader
extends LearnerMaster {
    private static final foe LOG = goe.a(Leader.class);
    private static final boolean nodelay = System.getProperty("leader.nodelay", "true").equals("true");
    private static final String ACK_LOGGING_FREQUENCY = "zookeeper.leader.ackLoggingFrequency";
    private static int ackLoggingFrequency;
    final LeaderZooKeeperServer zk;
    final QuorumPeer self;
    protected boolean quorumFormed = false;
    volatile LearnerCnxAcceptor cnxAcceptor = null;
    private final HashSet<LearnerHandler> learners = new HashSet();
    private final BufferStats proposalStats;
    private final ConcurrentHashMap<LearnerHandler, LearnerHandlerBean> connectionBeans = new ConcurrentHashMap();
    private final HashSet<LearnerHandler> forwardingFollowers = new HashSet();
    private final HashSet<LearnerHandler> observingLearners = new HashSet();
    private final Map<Long, List<LearnerSyncRequest>> pendingSyncs = new HashMap<Long, List<LearnerSyncRequest>>();
    final AtomicLong followerCounter = new AtomicLong(-1L);
    private final List<ServerSocket> serverSockets = new LinkedList<ServerSocket>();
    static final int DIFF = 13;
    static final int TRUNC = 14;
    static final int SNAP = 15;
    static final int OBSERVERINFO = 16;
    static final int NEWLEADER = 10;
    static final int FOLLOWERINFO = 11;
    static final int UPTODATE = 12;
    public static final int LEADERINFO = 17;
    public static final int ACKEPOCH = 18;
    static final int REQUEST = 1;
    public static final int PROPOSAL = 2;
    static final int ACK = 3;
    static final int COMMIT = 4;
    static final int PING = 5;
    static final int REVALIDATE = 6;
    static final int SYNC = 7;
    static final int INFORM = 8;
    static final int COMMITANDACTIVATE = 9;
    static final int INFORMANDACTIVATE = 19;
    final ConcurrentMap<Long, Proposal> outstandingProposals = new ConcurrentHashMap<Long, Proposal>();
    private final ConcurrentLinkedQueue<Proposal> toBeApplied = new ConcurrentLinkedQueue();
    protected final Proposal newLeaderProposal = new Proposal();
    StateSummary leaderStateSummary;
    long epoch = -1L;
    boolean waitingForNewEpoch = true;
    boolean allowedToCommit = true;
    private long leaderStartTime;
    boolean isShutdown;
    long lastCommitted = -1L;
    long lastProposed;
    protected final Set<Long> connectingFollowers = new HashSet<Long>();
    private volatile boolean quitWaitForEpoch = false;
    private volatile long timeStartWaitForEpoch = -1L;
    private volatile SyncedLearnerTracker voteSet;
    public static final String MAX_TIME_TO_WAIT_FOR_EPOCH = "zookeeper.leader.maxTimeToWaitForEpoch";
    private static int maxTimeToWaitForEpoch;
    protected final Set<Long> electingFollowers = new HashSet<Long>();
    protected boolean electionFinished = false;

    public static void setAckLoggingFrequency(int n2) {
        ackLoggingFrequency = n2;
    }

    public static int getAckLoggingFrequency() {
        return ackLoggingFrequency;
    }

    public BufferStats getProposalStats() {
        return this.proposalStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getLearners() {
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.learners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getForwardingFollowers() {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.forwardingFollowers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getNonVotingFollowers() {
        ArrayList<LearnerHandler> arrayList = new ArrayList<LearnerHandler>();
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            for (LearnerHandler learnerHandler : this.forwardingFollowers) {
                if (this.isParticipant(learnerHandler.getSid())) continue;
                arrayList.add(learnerHandler);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addForwardingFollower(LearnerHandler learnerHandler) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            this.forwardingFollowers.add(learnerHandler);
            this.self.getQuorumVerifier().updateNeedOracle(new ArrayList<LearnerHandler>(this.forwardingFollowers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getObservingLearners() {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.observingLearners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObserverLearnerHandler(LearnerHandler learnerHandler) {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            this.observingLearners.add(learnerHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Map<String, Object>> getObservingLearnersInfo() {
        HashSet<Map<String, Object>> hashSet = new HashSet<Map<String, Object>>();
        HashSet<LearnerHandler> hashSet2 = this.observingLearners;
        synchronized (hashSet2) {
            for (LearnerHandler learnerHandler : this.observingLearners) {
                hashSet.add(learnerHandler.getLearnerHandlerInfo());
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetObserverConnectionStats() {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            for (LearnerHandler learnerHandler : this.observingLearners) {
                learnerHandler.resetObserverConnectionStats();
            }
        }
    }

    public synchronized int getNumPendingSyncs() {
        return this.pendingSyncs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLearnerHandler(LearnerHandler learnerHandler) {
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            this.learners.add(learnerHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLearnerHandler(LearnerHandler learnerHandler) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            this.forwardingFollowers.remove(learnerHandler);
        }
        hashSet = this.learners;
        synchronized (hashSet) {
            this.learners.remove(learnerHandler);
        }
        hashSet = this.observingLearners;
        synchronized (hashSet) {
            this.observingLearners.remove(learnerHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLearnerSynced(LearnerHandler learnerHandler) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            return this.forwardingFollowers.contains(learnerHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuorumSynced(QuorumVerifier quorumVerifier) {
        HashSet<Long> hashSet = new HashSet<Long>();
        if (quorumVerifier.getVotingMembers().containsKey(this.self.getMyId())) {
            hashSet.add(this.self.getMyId());
        }
        HashSet<LearnerHandler> hashSet2 = this.forwardingFollowers;
        synchronized (hashSet2) {
            for (LearnerHandler learnerHandler : this.forwardingFollowers) {
                if (!learnerHandler.synced() || !quorumVerifier.getVotingMembers().containsKey(learnerHandler.getSid())) continue;
                hashSet.add(learnerHandler.getSid());
            }
        }
        return quorumVerifier.containsQuorum(hashSet);
    }

    public Leader(QuorumPeer quorumPeer, LeaderZooKeeperServer leaderZooKeeperServer) throws IOException {
        this.self = quorumPeer;
        this.proposalStats = new BufferStats();
        Set<InetSocketAddress> set = quorumPeer.getQuorumListenOnAllIPs() ? quorumPeer.getQuorumAddress().getWildcardAddresses() : quorumPeer.getQuorumAddress().getAllAddresses();
        set.stream().map(inetSocketAddress -> this.createServerSocket((InetSocketAddress)inetSocketAddress, quorumPeer.shouldUsePortUnification(), quorumPeer.isSslQuorum())).filter(Optional::isPresent).map(Optional::get).forEach(this.serverSockets::add);
        if (this.serverSockets.isEmpty()) {
            throw new IOException("Leader failed to initialize any of the following sockets: " + set);
        }
        this.zk = leaderZooKeeperServer;
    }

    InetSocketAddress recreateInetSocketAddr(String string, int n2) {
        return new InetSocketAddress(string, n2);
    }

    Optional<ServerSocket> createServerSocket(InetSocketAddress inetSocketAddress, boolean bl2, boolean bl3) {
        try {
            ServerSocket serverSocket = bl2 || bl3 ? new UnifiedServerSocket(this.self.getX509Util(), bl2) : new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(this.recreateInetSocketAddr(inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
            return Optional.of(serverSocket);
        }
        catch (IOException iOException) {
            LOG.e("Couldn't bind to {}", (Object)inetSocketAddress.toString(), (Object)iOException);
            return Optional.empty();
        }
    }

    public long getUptime() {
        if (this.leaderStartTime > 0L) {
            return Time.currentElapsedTime() - this.leaderStartTime;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lead() throws IOException, InterruptedException {
        this.self.end_fle = Time.currentElapsedTime();
        long l2 = this.self.end_fle - this.self.start_fle;
        this.self.setElectionTimeTaken(l2);
        ServerMetrics.getMetrics().ELECTION_TIME.add(l2);
        LOG.c("LEADING - LEADER ELECTION TOOK - {} {}", (Object)l2, (Object)"MS");
        this.self.start_fle = 0L;
        this.self.end_fle = 0L;
        this.zk.registerJMX(new LeaderBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            Object object;
            this.self.setZabState(QuorumPeer.ZabState.DISCOVERY);
            this.self.tick.set(0);
            this.zk.loadData();
            this.leaderStateSummary = new StateSummary(this.self.getCurrentEpoch(), this.zk.getLastProcessedZxid());
            this.cnxAcceptor = new LearnerCnxAcceptor();
            this.cnxAcceptor.start();
            long l3 = this.getEpochToPropose(this.self.getMyId(), this.self.getAcceptedEpoch());
            this.zk.setZxid(ZxidUtils.makeZxid(l3, 0L));
            Object object2 = this;
            synchronized (object2) {
                this.lastProposed = this.zk.getZxid();
            }
            this.newLeaderProposal.packet = new QuorumPacket(10, this.zk.getZxid(), null, null);
            if ((this.newLeaderProposal.packet.getZxid() & 0xFFFFFFFFL) != 0L) {
                LOG.c("NEWLEADER proposal has Zxid of {}", (Object)Long.toHexString(this.newLeaderProposal.packet.getZxid()));
            }
            object2 = this.self.getLastSeenQuorumVerifier();
            QuorumVerifier quorumVerifier = this.self.getQuorumVerifier();
            if (quorumVerifier.getVersion() == 0L && quorumVerifier.getVersion() == object2.getVersion()) {
                try {
                    LOG.b(String.format("set lastSeenQuorumVerifier to currentQuorumVerifier (%s)", quorumVerifier.toString()));
                    object = this.self.configFromString(quorumVerifier.toString());
                    object.setVersion(this.zk.getZxid());
                    this.self.setLastSeenQuorumVerifier((QuorumVerifier)object, true);
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }
            this.newLeaderProposal.addQuorumVerifier(this.self.getQuorumVerifier());
            if (this.self.getLastSeenQuorumVerifier().getVersion() > this.self.getQuorumVerifier().getVersion()) {
                this.newLeaderProposal.addQuorumVerifier(this.self.getLastSeenQuorumVerifier());
            }
            this.waitForEpochAck(this.self.getMyId(), this.leaderStateSummary);
            this.self.setCurrentEpoch(l3);
            this.self.setLeaderAddressAndId(this.self.getQuorumAddress(), this.self.getMyId());
            this.self.setZabState(QuorumPeer.ZabState.SYNCHRONIZATION);
            try {
                this.waitForNewLeaderAck(this.self.getMyId(), this.zk.getZxid());
            }
            catch (InterruptedException interruptedException) {
                this.shutdown("Waiting for a quorum of followers, only synced with sids: [ " + this.newLeaderProposal.ackSetsToString() + " ]");
                HashSet<Long> hashSet = new HashSet<Long>();
                for (LearnerHandler object3 : this.getLearners()) {
                    if (!this.self.getQuorumVerifier().getVotingMembers().containsKey(object3.getSid())) continue;
                    hashSet.add(object3.getSid());
                }
                boolean bl2 = true;
                for (SyncedLearnerTracker.QuorumVerifierAcksetPair learnerHandler : this.newLeaderProposal.qvAcksetPairs) {
                    if (learnerHandler.getQuorumVerifier().containsQuorum(hashSet)) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    LOG.d("Enough followers present. Perhaps the initTicks need to be increased.");
                }
                this.zk.unregisterJMX(this);
                return;
            }
            this.startZkServer();
            object = System.getProperty("zookeeper.testingonly.initialZxid");
            if (object != null) {
                long l4 = Long.parseLong((String)object);
                this.zk.setZxid(this.zk.getZxid() & 0xFFFFFFFF00000000L | l4);
            }
            if (!System.getProperty("zookeeper.leaderServes", "yes").equals("no")) {
                this.self.setZooKeeperServer(this.zk);
            }
            this.self.setZabState(QuorumPeer.ZabState.BROADCAST);
            this.self.adminServer.setZooKeeperServer(this.zk);
            boolean bl3 = true;
            String string = null;
            block16: while (true) {
                Leader leader = this;
                synchronized (leader) {
                    long l4;
                    long l5 = l4 = Time.currentElapsedTime();
                    long l6 = l4 + (long)(this.self.tickTime / 2);
                    while (l5 < l6) {
                        this.wait(l6 - l5);
                        l5 = Time.currentElapsedTime();
                    }
                    if (!bl3) {
                        this.self.tick.incrementAndGet();
                    }
                    SyncedLearnerTracker syncedLearnerTracker = new SyncedLearnerTracker();
                    syncedLearnerTracker.addQuorumVerifier(this.self.getQuorumVerifier());
                    if (this.self.getLastSeenQuorumVerifier() != null && this.self.getLastSeenQuorumVerifier().getVersion() > this.self.getQuorumVerifier().getVersion()) {
                        syncedLearnerTracker.addQuorumVerifier(this.self.getLastSeenQuorumVerifier());
                    }
                    syncedLearnerTracker.addAck(this.self.getMyId());
                    for (LearnerHandler learnerHandler : this.getLearners()) {
                        if (!learnerHandler.synced()) continue;
                        syncedLearnerTracker.addAck(learnerHandler.getSid());
                    }
                    if (!this.isRunning()) {
                        string = "Unexpected internal error";
                        break;
                    }
                    if (!(bl3 || syncedLearnerTracker.hasAllQuorums() || this.self.getQuorumVerifier().overrideQuorumDecision(this.getForwardingFollowers()) && this.self.getQuorumVerifier().revalidateOutstandingProp(this, new ArrayList<Proposal>(this.outstandingProposals.values()), this.lastCommitted))) {
                        string = "Not sufficient followers synced, only synced with sids: [ " + syncedLearnerTracker.ackSetsToString() + " ]";
                        break;
                    }
                    bl3 = !bl3;
                }
                Iterator<LearnerHandler> iterator = this.getLearners().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block16;
                    LearnerHandler learnerHandler = iterator.next();
                    learnerHandler.ping();
                }
                break;
            }
            if (string != null) {
                this.shutdown(string);
            }
        }
        finally {
            this.zk.unregisterJMX(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(String string) {
        LOG.c("Shutting down");
        if (this.isShutdown) {
            return;
        }
        LOG.c("Shutdown called. For the reason {}", (Object)string);
        if (this.cnxAcceptor != null) {
            this.cnxAcceptor.halt();
        } else {
            this.closeSockets();
        }
        this.self.setZooKeeperServer(null);
        this.self.adminServer.setZooKeeperServer(null);
        this.self.closeAllConnections();
        if (this.zk != null) {
            this.zk.shutdown();
        }
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            Iterator<LearnerHandler> iterator = this.learners.iterator();
            while (iterator.hasNext()) {
                LearnerHandler learnerHandler = iterator.next();
                iterator.remove();
                learnerHandler.shutdown();
            }
        }
        this.isShutdown = true;
    }

    synchronized void closeSockets() {
        for (ServerSocket serverSocket : this.serverSockets) {
            if (serverSocket.isClosed()) continue;
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                LOG.d("Ignoring unexpected exception during close {}", (Object)serverSocket, (Object)iOException);
            }
        }
    }

    private long getDesignatedLeader(Proposal proposal, long l2) {
        SyncedLearnerTracker.QuorumVerifierAcksetPair quorumVerifierAcksetPair = (SyncedLearnerTracker.QuorumVerifierAcksetPair)proposal.qvAcksetPairs.get(proposal.qvAcksetPairs.size() - 1);
        if (quorumVerifierAcksetPair.getQuorumVerifier().getVotingMembers().containsKey(this.self.getMyId()) && quorumVerifierAcksetPair.getQuorumVerifier().getVotingMembers().get((Object)Long.valueOf((long)this.self.getMyId())).addr.equals(this.self.getQuorumAddress())) {
            return this.self.getMyId();
        }
        HashSet<Long> hashSet = new HashSet<Long>(quorumVerifierAcksetPair.getAckset());
        hashSet.remove(this.self.getMyId());
        long l3 = hashSet.iterator().next();
        long l4 = l2 + 1L;
        Proposal proposal2 = (Proposal)this.outstandingProposals.get(l4);
        while (proposal2 != null && !hashSet.isEmpty()) {
            for (SyncedLearnerTracker.QuorumVerifierAcksetPair quorumVerifierAcksetPair2 : proposal2.qvAcksetPairs) {
                hashSet.retainAll(quorumVerifierAcksetPair2.getAckset());
                if (hashSet.isEmpty()) {
                    return l3;
                }
                l3 = hashSet.iterator().next();
                if (hashSet.size() != 1) continue;
                return l3;
            }
            proposal2 = (Proposal)this.outstandingProposals.get(++l4);
        }
        return l3;
    }

    public synchronized boolean tryToCommit(Proposal proposal, long l2, SocketAddress socketAddress) {
        if (this.outstandingProposals.containsKey(l2 - 1L)) {
            return false;
        }
        if (!proposal.hasAllQuorums()) {
            return false;
        }
        if (l2 != this.lastCommitted + 1L) {
            LOG.d("Commiting zxid 0x{} from {} not first!", (Object)Long.toHexString(l2), (Object)socketAddress);
            LOG.d("First is 0x{}", (Object)Long.toHexString(this.lastCommitted + 1L));
        }
        this.outstandingProposals.remove(l2);
        if (proposal.request != null) {
            this.toBeApplied.add(proposal);
        }
        if (proposal.request == null) {
            LOG.d("Going to commit null: {}", (Object)proposal);
        } else if (proposal.request.getHdr().getType() == 16) {
            LOG.b("Committing a reconfiguration! {}", (Object)this.outstandingProposals.size());
            Long l3 = this.getDesignatedLeader(proposal, l2);
            QuorumVerifier object = ((SyncedLearnerTracker.QuorumVerifierAcksetPair)proposal.qvAcksetPairs.get(proposal.qvAcksetPairs.size() - 1)).getQuorumVerifier();
            this.self.processReconfig(object, l3, this.zk.getZxid(), true);
            if (l3.longValue() != this.self.getMyId()) {
                LOG.c(String.format("Committing a reconfiguration (reconfigEnabled=%s); this leader is not the designated leader anymore, setting allowedToCommit=false", this.self.isReconfigEnabled()));
                this.allowedToCommit = false;
            }
            this.commitAndActivate(l2, l3);
            this.informAndActivate(proposal, l3);
        } else {
            proposal.request.logLatency(ServerMetrics.getMetrics().QUORUM_ACK_LATENCY);
            this.commit(l2);
            this.inform(proposal);
        }
        this.zk.commitProcessor.commit(proposal.request);
        if (this.pendingSyncs.containsKey(l2)) {
            for (LearnerSyncRequest learnerSyncRequest : this.pendingSyncs.remove(l2)) {
                this.sendSync(learnerSyncRequest);
            }
        }
        return true;
    }

    @Override
    public synchronized void processAck(long l2, long l3, SocketAddress socketAddress) {
        long l4;
        if (!this.allowedToCommit) {
            return;
        }
        if (LOG.b()) {
            LOG.a("Ack zxid: 0x{}", (Object)Long.toHexString(l3));
            for (Proposal proposal : this.outstandingProposals.values()) {
                l4 = proposal.packet.getZxid();
                LOG.a("outstanding proposal: 0x{}", (Object)Long.toHexString(l4));
            }
            LOG.a("outstanding proposals all");
        }
        if ((l3 & 0xFFFFFFFFL) == 0L) {
            return;
        }
        if (this.outstandingProposals.size() == 0) {
            LOG.b("outstanding is 0");
            return;
        }
        if (this.lastCommitted >= l3) {
            LOG.b("proposal has already been committed, pzxid: 0x{} zxid: 0x{}", (Object)Long.toHexString(this.lastCommitted), (Object)Long.toHexString(l3));
            return;
        }
        Object object = (Proposal)this.outstandingProposals.get(l3);
        if (object == null) {
            LOG.d("Trying to commit future proposal: zxid 0x{} from {}", (Object)Long.toHexString(l3), (Object)socketAddress);
            return;
        }
        if (ackLoggingFrequency > 0 && l3 % (long)ackLoggingFrequency == 0L) {
            ((Proposal)object).request.logLatency(ServerMetrics.getMetrics().ACK_LATENCY, Long.toString(l2));
        }
        ((SyncedLearnerTracker)object).addAck(l2);
        boolean bl2 = this.tryToCommit((Proposal)object, l3, socketAddress);
        if (bl2 && ((Proposal)object).request != null && ((Proposal)object).request.getHdr().getType() == 16) {
            l4 = l3;
            while (this.allowedToCommit && bl2 && object != null) {
                if ((object = (Proposal)this.outstandingProposals.get(++l4)) == null) continue;
                bl2 = this.tryToCommit((Proposal)object, l4, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(QuorumPacket quorumPacket) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            for (LearnerHandler learnerHandler : this.forwardingFollowers) {
                learnerHandler.queuePacket(quorumPacket);
            }
        }
    }

    void sendObserverPacket(QuorumPacket quorumPacket) {
        for (LearnerHandler learnerHandler : this.getObservingLearners()) {
            learnerHandler.queuePacket(quorumPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(long l2) {
        Object object = this;
        synchronized (object) {
            this.lastCommitted = l2;
        }
        object = new QuorumPacket(4, l2, null, null);
        this.sendPacket((QuorumPacket)object);
        ServerMetrics.getMetrics().COMMIT_COUNT.add(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAndActivate(long l2, long l3) {
        Object object = this;
        synchronized (object) {
            this.lastCommitted = l2;
        }
        object = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object);
        byteBuffer.putLong(l3);
        QuorumPacket quorumPacket = new QuorumPacket(9, l2, (byte[])object, null);
        this.sendPacket(quorumPacket);
    }

    public void inform(Proposal proposal) {
        QuorumPacket quorumPacket = new QuorumPacket(8, proposal.request.zxid, proposal.packet.getData(), null);
        this.sendObserverPacket(quorumPacket);
    }

    public static QuorumPacket buildInformAndActivePacket(long l2, long l3, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.putLong(l3);
        byteBuffer.put(byArray);
        return new QuorumPacket(19, l2, byArray2, null);
    }

    public void informAndActivate(Proposal proposal, long l2) {
        this.sendObserverPacket(Leader.buildInformAndActivePacket(proposal.request.zxid, l2, proposal.packet.getData()));
    }

    @Override
    public synchronized long getLastProposed() {
        return this.lastProposed;
    }

    public long getEpoch() {
        return ZxidUtils.getEpochFromZxid(this.lastProposed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proposal propose(Request request) throws XidRolloverException {
        if (request.isThrottled()) {
            LOG.e("Throttled request send as proposal: {}. Exiting.", (Object)request);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        if ((request.zxid & 0xFFFFFFFFL) == 0xFFFFFFFFL) {
            String string = "zxid lower 32 bits have rolled over, forcing re-election, and therefore new epoch start";
            this.shutdown(string);
            throw new XidRolloverException(string);
        }
        byte[] byArray = request.getSerializeData();
        this.proposalStats.setLastBufferSize(byArray.length);
        QuorumPacket quorumPacket = new QuorumPacket(2, request.zxid, byArray, null);
        Proposal proposal = new Proposal(request, quorumPacket);
        Leader leader = this;
        synchronized (leader) {
            proposal.addQuorumVerifier(this.self.getQuorumVerifier());
            if (request.getHdr().getType() == 16) {
                this.self.setLastSeenQuorumVerifier(request.qv, true);
            }
            if (this.self.getQuorumVerifier().getVersion() < this.self.getLastSeenQuorumVerifier().getVersion()) {
                proposal.addQuorumVerifier(this.self.getLastSeenQuorumVerifier());
            }
            LOG.b("Proposing:: {}", (Object)request);
            this.lastProposed = proposal.packet.getZxid();
            this.outstandingProposals.put(this.lastProposed, proposal);
            this.sendPacket(quorumPacket);
        }
        ServerMetrics.getMetrics().PROPOSAL_COUNT.add(1L);
        return proposal;
    }

    public synchronized void processSync(LearnerSyncRequest learnerSyncRequest) {
        if (this.outstandingProposals.isEmpty()) {
            this.sendSync(learnerSyncRequest);
        } else {
            this.pendingSyncs.computeIfAbsent(this.lastProposed, l2 -> new ArrayList()).add(learnerSyncRequest);
        }
    }

    public void sendSync(LearnerSyncRequest learnerSyncRequest) {
        QuorumPacket quorumPacket = new QuorumPacket(7, 0L, null, null);
        learnerSyncRequest.fh.queuePacket(quorumPacket);
    }

    @Override
    public synchronized long startForwarding(LearnerHandler learnerHandler, long l2) {
        if (this.lastProposed > l2) {
            Object object;
            for (Proposal object2 : this.toBeApplied) {
                if (object2.packet.getZxid() <= l2) continue;
                learnerHandler.queuePacket(object2.packet);
                object = new QuorumPacket(4, object2.packet.getZxid(), null, null);
                learnerHandler.queuePacket((QuorumPacket)object);
            }
            if (learnerHandler.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
                ArrayList arrayList = new ArrayList(this.outstandingProposals.keySet());
                Collections.sort(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (Long)iterator.next();
                    if ((Long)object <= l2) continue;
                    learnerHandler.queuePacket(((Proposal)this.outstandingProposals.get(object)).packet);
                }
            }
        }
        if (learnerHandler.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
            this.addForwardingFollower(learnerHandler);
        } else {
            this.addObserverLearnerHandler(learnerHandler);
        }
        return this.lastProposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForStartup() throws InterruptedException {
        LeaderZooKeeperServer leaderZooKeeperServer = this.zk;
        synchronized (leaderZooKeeperServer) {
            while (!this.zk.isRunning() && !Thread.currentThread().isInterrupted()) {
                this.zk.wait(20L);
            }
        }
    }

    public static void setMaxTimeToWaitForEpoch(int n2) {
        maxTimeToWaitForEpoch = n2;
        LOG.c("Set {} to {}ms", (Object)MAX_TIME_TO_WAIT_FOR_EPOCH, (Object)maxTimeToWaitForEpoch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quitLeading() {
        Set<Long> set = this.connectingFollowers;
        synchronized (set) {
            this.quitWaitForEpoch = true;
            this.connectingFollowers.notifyAll();
        }
        ServerMetrics.getMetrics().QUIT_LEADING_DUE_TO_DISLOYAL_VOTER.add(1L);
        LOG.c("Quit leading due to voter changed mind.");
    }

    public void setLeadingVoteSet(SyncedLearnerTracker syncedLearnerTracker) {
        this.voteSet = syncedLearnerTracker;
    }

    public void reportLookingSid(long l2) {
        if (maxTimeToWaitForEpoch < 0 || this.timeStartWaitForEpoch < 0L || !this.waitingForNewEpoch) {
            return;
        }
        if (this.voteSet == null || !this.voteSet.hasSid(l2)) {
            return;
        }
        if (Time.currentElapsedTime() - this.timeStartWaitForEpoch > (long)maxTimeToWaitForEpoch) {
            this.quitLeading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEpochToPropose(long l2, long l3) throws InterruptedException, IOException {
        Set<Long> set = this.connectingFollowers;
        synchronized (set) {
            if (!this.waitingForNewEpoch) {
                return this.epoch;
            }
            if (l3 >= this.epoch) {
                this.epoch = l3 + 1L;
            }
            if (this.isParticipant(l2)) {
                this.connectingFollowers.add(l2);
            }
            QuorumVerifier quorumVerifier = this.self.getQuorumVerifier();
            if (this.connectingFollowers.contains(this.self.getMyId()) && quorumVerifier.containsQuorum(this.connectingFollowers)) {
                this.waitingForNewEpoch = false;
                this.self.setAcceptedEpoch(this.epoch);
                this.connectingFollowers.notifyAll();
            } else {
                long l4 = Time.currentElapsedTime();
                if (l2 == this.self.getMyId()) {
                    this.timeStartWaitForEpoch = l4;
                }
                long l5 = l4;
                long l6 = l4 + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (this.waitingForNewEpoch && l5 < l6 && !this.quitWaitForEpoch) {
                    this.connectingFollowers.wait(l6 - l5);
                    l5 = Time.currentElapsedTime();
                }
                if (this.waitingForNewEpoch) {
                    throw new InterruptedException("Timeout while waiting for epoch from quorum");
                }
            }
            return this.epoch;
        }
    }

    @Override
    public ZKDatabase getZKDatabase() {
        return this.zk.getZKDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForEpochAck(long l2, StateSummary stateSummary) throws IOException, InterruptedException {
        Set<Long> set = this.electingFollowers;
        synchronized (set) {
            if (this.electionFinished) {
                return;
            }
            if (stateSummary.getCurrentEpoch() != -1L) {
                if (stateSummary.isMoreRecentThan(this.leaderStateSummary)) {
                    throw new IOException("Follower is ahead of the leader, leader summary: " + this.leaderStateSummary.getCurrentEpoch() + " (current epoch), " + this.leaderStateSummary.getLastZxid() + " (last zxid)");
                }
                if (stateSummary.getLastZxid() != -1L && this.isParticipant(l2)) {
                    this.electingFollowers.add(l2);
                }
            }
            QuorumVerifier quorumVerifier = this.self.getQuorumVerifier();
            if (this.electingFollowers.contains(this.self.getMyId()) && quorumVerifier.containsQuorum(this.electingFollowers)) {
                this.electionFinished = true;
                this.electingFollowers.notifyAll();
            } else {
                long l3;
                long l4 = l3 = Time.currentElapsedTime();
                long l5 = l3 + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (!this.electionFinished && l4 < l5) {
                    this.electingFollowers.wait(l5 - l4);
                    l4 = Time.currentElapsedTime();
                }
                if (!this.electionFinished) {
                    throw new InterruptedException("Timeout while waiting for epoch to be acked by quorum");
                }
            }
        }
    }

    private String getSidSetString(Set<Long> set) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Long> iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) break;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private synchronized void startZkServer() {
        this.lastCommitted = this.zk.getZxid();
        LOG.c("Have quorum of supporters, sids: [{}]; starting up and setting last processed zxid: 0x{}", (Object)this.newLeaderProposal.ackSetsToString(), (Object)Long.toHexString(this.zk.getZxid()));
        if (this.self.isReconfigEnabled()) {
            QuorumVerifier quorumVerifier = this.self.getLastSeenQuorumVerifier();
            Long l2 = this.getDesignatedLeader(this.newLeaderProposal, this.zk.getZxid());
            this.self.processReconfig(quorumVerifier, l2, this.zk.getZxid(), true);
            if (l2.longValue() != this.self.getMyId()) {
                LOG.d("This leader is not the designated leader, it will be initialized with allowedToCommit = false");
                this.allowedToCommit = false;
            }
        } else {
            LOG.c("Dynamic reconfig feature is disabled, skip designatedLeader calculation and reconfig processing.");
        }
        this.leaderStartTime = Time.currentElapsedTime();
        this.zk.startup();
        this.self.updateElectionVote(this.getEpoch());
        this.zk.getZKDatabase().setlastProcessedZxid(this.zk.getZxid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForNewLeaderAck(long l2, long l3) throws InterruptedException {
        ArrayList arrayList = this.newLeaderProposal.qvAcksetPairs;
        synchronized (arrayList) {
            if (this.quorumFormed) {
                return;
            }
            long l4 = this.newLeaderProposal.packet.getZxid();
            if (l3 != l4) {
                LOG.e("NEWLEADER ACK from sid: {} is from a different epoch - current 0x{} received 0x{}", l2, Long.toHexString(l4), Long.toHexString(l3));
                return;
            }
            this.newLeaderProposal.addAck(l2);
            if (this.newLeaderProposal.hasAllQuorums()) {
                this.quorumFormed = true;
                this.newLeaderProposal.qvAcksetPairs.notifyAll();
            } else {
                long l5;
                long l6 = l5 = Time.currentElapsedTime();
                long l7 = l5 + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (!this.quorumFormed && l6 < l7) {
                    this.newLeaderProposal.qvAcksetPairs.wait(l7 - l6);
                    l6 = Time.currentElapsedTime();
                }
                if (!this.quorumFormed) {
                    throw new InterruptedException("Timeout while waiting for NEWLEADER to be acked by quorum");
                }
            }
        }
    }

    public static String getPacketType(int n2) {
        switch (n2) {
            case 13: {
                return "DIFF";
            }
            case 14: {
                return "TRUNC";
            }
            case 15: {
                return "SNAP";
            }
            case 16: {
                return "OBSERVERINFO";
            }
            case 10: {
                return "NEWLEADER";
            }
            case 11: {
                return "FOLLOWERINFO";
            }
            case 12: {
                return "UPTODATE";
            }
            case 17: {
                return "LEADERINFO";
            }
            case 18: {
                return "ACKEPOCH";
            }
            case 1: {
                return "REQUEST";
            }
            case 2: {
                return "PROPOSAL";
            }
            case 3: {
                return "ACK";
            }
            case 4: {
                return "COMMIT";
            }
            case 9: {
                return "COMMITANDACTIVATE";
            }
            case 5: {
                return "PING";
            }
            case 6: {
                return "REVALIDATE";
            }
            case 7: {
                return "SYNC";
            }
            case 8: {
                return "INFORM";
            }
            case 19: {
                return "INFORMANDACTIVATE";
            }
        }
        return "UNKNOWN";
    }

    private boolean isRunning() {
        return this.self.isRunning() && this.zk.isRunning();
    }

    private boolean isParticipant(long l2) {
        return this.self.getQuorumVerifier().getVotingMembers().containsKey(l2);
    }

    @Override
    public int getCurrentTick() {
        return this.self.tick.get();
    }

    @Override
    public int syncTimeout() {
        return this.self.tickTime * this.self.syncLimit;
    }

    @Override
    public int getTickOfNextAckDeadline() {
        return this.self.tick.get() + this.self.syncLimit;
    }

    @Override
    public int getTickOfInitialAckDeadline() {
        return this.self.tick.get() + this.self.initLimit + this.self.syncLimit;
    }

    @Override
    public long getAndDecrementFollowerCounter() {
        return this.followerCounter.getAndDecrement();
    }

    @Override
    public void touch(long l2, int n2) {
        this.zk.touch(l2, n2);
    }

    @Override
    public void submitLearnerRequest(Request request) {
        this.zk.submitLearnerRequest(request);
    }

    @Override
    public long getQuorumVerifierVersion() {
        return this.self.getQuorumVerifier().getVersion();
    }

    @Override
    public String getPeerInfo(long l2) {
        QuorumPeer.QuorumServer quorumServer = this.self.getView().get(l2);
        return quorumServer == null ? "" : quorumServer.toString();
    }

    @Override
    public byte[] getQuorumVerifierBytes() {
        return this.self.getLastSeenQuorumVerifier().toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public QuorumAuthServer getQuorumAuthServer() {
        return this.self == null ? null : this.self.authServer;
    }

    @Override
    public void revalidateSession(QuorumPacket quorumPacket, LearnerHandler learnerHandler) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(quorumPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        long l2 = dataInputStream.readLong();
        int n2 = dataInputStream.readInt();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeLong(l2);
        boolean bl2 = this.zk.checkIfValidGlobalSession(l2, n2);
        if (bl2) {
            try {
                this.zk.setOwner(l2, learnerHandler);
            }
            catch (KeeperException.SessionExpiredException sessionExpiredException) {
                LOG.e("Somehow session 0x{} expired right after being renewed! (impossible)", (Object)Long.toHexString(l2), (Object)sessionExpiredException);
            }
        }
        if (LOG.b()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(l2) + " is valid: " + bl2);
        }
        dataOutputStream.writeBoolean(bl2);
        quorumPacket.setData(byteArrayOutputStream.toByteArray());
        learnerHandler.queuePacket(quorumPacket);
    }

    @Override
    public void registerLearnerHandlerBean(LearnerHandler learnerHandler, Socket socket) {
        LearnerHandlerBean learnerHandlerBean = new LearnerHandlerBean(learnerHandler, socket);
        if (this.zk.registerJMX(learnerHandlerBean)) {
            this.connectionBeans.put(learnerHandler, learnerHandlerBean);
        }
    }

    @Override
    public void unregisterLearnerHandlerBean(LearnerHandler learnerHandler) {
        LearnerHandlerBean learnerHandlerBean = this.connectionBeans.remove(learnerHandler);
        if (learnerHandlerBean != null) {
            MBeanRegistry.getInstance().unregister(learnerHandlerBean);
        }
    }

    static {
        LOG.c("TCP NoDelay set to: {}", (Object)nodelay);
        ackLoggingFrequency = Integer.getInteger(ACK_LOGGING_FREQUENCY, 1000);
        LOG.c("{} = {}", (Object)ACK_LOGGING_FREQUENCY, (Object)ackLoggingFrequency);
        maxTimeToWaitForEpoch = Integer.getInteger(MAX_TIME_TO_WAIT_FOR_EPOCH, -1);
        LOG.c("{} = {}ms", (Object)MAX_TIME_TO_WAIT_FOR_EPOCH, (Object)maxTimeToWaitForEpoch);
    }

    public static class XidRolloverException
    extends Exception {
        public XidRolloverException(String string) {
            super(string);
        }
    }

    static class ToBeAppliedRequestProcessor
    implements RequestProcessor {
        private final RequestProcessor next;
        private final Leader leader;

        ToBeAppliedRequestProcessor(RequestProcessor requestProcessor, Leader leader) {
            if (!(requestProcessor instanceof FinalRequestProcessor)) {
                throw new RuntimeException(ToBeAppliedRequestProcessor.class.getName() + " must be connected to " + FinalRequestProcessor.class.getName() + " not " + requestProcessor.getClass().getName());
            }
            this.leader = leader;
            this.next = requestProcessor;
        }

        @Override
        public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
            this.next.processRequest(request);
            if (request.getHdr() != null) {
                long l2 = request.getHdr().getZxid();
                Iterator iterator = this.leader.toBeApplied.iterator();
                if (iterator.hasNext()) {
                    Proposal proposal = (Proposal)iterator.next();
                    if (proposal.request != null && proposal.request.zxid == l2) {
                        iterator.remove();
                        return;
                    }
                }
                LOG.e("Committed request not found on toBeApplied: {}", (Object)request);
            }
        }

        @Override
        public void shutdown() {
            LOG.c("Shutting down");
            this.next.shutdown();
        }
    }

    class LearnerCnxAcceptor
    extends ZooKeeperCriticalThread {
        private final AtomicBoolean stop;
        private final AtomicBoolean fail;

        LearnerCnxAcceptor() {
            super("LearnerCnxAcceptor-" + Leader.this.serverSockets.stream().map(ServerSocket::getLocalSocketAddress).map(Objects::toString).collect(Collectors.joining("|")), Leader.this.zk.getZooKeeperServerListener());
            this.stop = new AtomicBoolean(false);
            this.fail = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.stop.get() && !Leader.this.serverSockets.isEmpty()) {
                ExecutorService executorService = Executors.newFixedThreadPool(Leader.this.serverSockets.size());
                CountDownLatch countDownLatch = new CountDownLatch(Leader.this.serverSockets.size());
                Leader.this.serverSockets.forEach(serverSocket -> executorService.submit(new LearnerCnxAcceptorHandler((ServerSocket)serverSocket, countDownLatch)));
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    LOG.d("Interrupted while sleeping in LearnerCnxAcceptor.", interruptedException);
                }
                finally {
                    Leader.this.closeSockets();
                    executorService.shutdown();
                    try {
                        if (!executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                            LOG.e("not all the LearnerCnxAcceptorHandler terminated properly");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.d("Interrupted while terminating LearnerCnxAcceptor.", interruptedException);
                    }
                }
            }
        }

        public void halt() {
            this.stop.set(true);
            Leader.this.closeSockets();
        }

        class LearnerCnxAcceptorHandler
        implements Runnable {
            private ServerSocket serverSocket;
            private CountDownLatch latch;

            LearnerCnxAcceptorHandler(ServerSocket serverSocket, CountDownLatch countDownLatch) {
                this.serverSocket = serverSocket;
                this.latch = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("LearnerCnxAcceptorHandler-" + this.serverSocket.getLocalSocketAddress());
                    while (!LearnerCnxAcceptor.this.stop.get()) {
                        this.acceptConnections();
                    }
                }
                catch (Exception exception) {
                    LOG.c("Exception while accepting follower", exception);
                    if (LearnerCnxAcceptor.this.fail.compareAndSet(false, true)) {
                        LearnerCnxAcceptor.this.handleException(LearnerCnxAcceptor.this.getName(), exception);
                        LearnerCnxAcceptor.this.halt();
                    }
                }
                finally {
                    this.latch.countDown();
                }
            }

            private void acceptConnections() throws IOException {
                block19: {
                    Socket socket = null;
                    boolean bl2 = false;
                    try {
                        socket = this.serverSocket.accept();
                        socket.setSoTimeout(Leader.this.self.tickTime * Leader.this.self.initLimit);
                        socket.setTcpNoDelay(nodelay);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                        LearnerHandler learnerHandler = new LearnerHandler(socket, bufferedInputStream, Leader.this);
                        learnerHandler.start();
                    }
                    catch (SocketException socketException) {
                        bl2 = true;
                        if (LearnerCnxAcceptor.this.stop.get()) {
                            LOG.c("Exception while shutting down acceptor.", socketException);
                            break block19;
                        }
                        throw socketException;
                    }
                    catch (SaslException saslException) {
                        LOG.d("Exception while connecting to quorum learner", saslException);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        bl2 = true;
                        throw exception;
                    }
                    finally {
                        if (bl2 && socket != null && !socket.isClosed()) {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {
                                LOG.c("Error closing socket: " + socket, iOException);
                            }
                        }
                    }
                }
            }
        }
    }

    public static class PureRequestProposal
    extends Proposal {
        public PureRequestProposal(Request request) {
            this.request = request;
        }

        @Override
        public QuorumPacket getQuorumPacket() {
            byte[] byArray = this.request.getSerializeData();
            return new QuorumPacket(2, this.request.zxid, byArray, null);
        }

        @Override
        public long getZxid() {
            return this.request.zxid;
        }

        @Override
        public String toString() {
            return this.request.toString();
        }
    }

    public static class Proposal
    extends SyncedLearnerTracker {
        private QuorumPacket packet;
        protected Request request;

        public Proposal() {
        }

        public Proposal(QuorumPacket quorumPacket) {
            this.packet = quorumPacket;
        }

        public Proposal(Request request, QuorumPacket quorumPacket) {
            this.request = request;
            this.packet = quorumPacket;
        }

        public QuorumPacket getQuorumPacket() {
            return this.packet;
        }

        public Request getRequest() {
            return this.request;
        }

        public long getZxid() {
            return this.packet.getZxid();
        }

        public String toString() {
            return this.packet.getType() + ", " + this.packet.getZxid() + ", " + this.request;
        }
    }
}

