/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsContext;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.FinalRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SyncRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.CommitProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Follower;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.FollowerRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Learner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandlerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPacket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.SendAckRequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.management.JMException;

public class FollowerZooKeeperServer
extends LearnerZooKeeperServer {
    private static final foe LOG = goe.a(FollowerZooKeeperServer.class);
    ConcurrentLinkedQueue<Request> pendingSyncs;
    LinkedBlockingQueue<Request> pendingTxns = new LinkedBlockingQueue();

    FollowerZooKeeperServer(FileTxnSnapLog fileTxnSnapLog, QuorumPeer quorumPeer, ZKDatabase zKDatabase) throws IOException {
        super(fileTxnSnapLog, quorumPeer.tickTime, quorumPeer.minSessionTimeout, quorumPeer.maxSessionTimeout, quorumPeer.clientPortListenBacklog, zKDatabase, quorumPeer);
        this.pendingSyncs = new ConcurrentLinkedQueue();
    }

    public Follower getFollower() {
        return this.self.follower;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalRequestProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalRequestProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        this.firstProcessor = new FollowerRequestProcessor(this, this.commitProcessor);
        ((FollowerRequestProcessor)this.firstProcessor).start();
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getFollower()));
        this.syncProcessor.start();
    }

    public void logRequest(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
        Request request = this.buildRequestToProcess(txnHeader, mme2, txnDigest);
        this.syncProcessor.processRequest(request);
    }

    public Request appendRequest(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) throws IOException {
        Request request = this.buildRequestToProcess(txnHeader, mme2, txnDigest);
        this.getZKDatabase().append(request);
        return request;
    }

    public void commit(long l2) {
        if (this.pendingTxns.size() == 0) {
            LOG.d("Committing " + Long.toHexString(l2) + " without seeing txn");
            return;
        }
        long l3 = ((Request)this.pendingTxns.element()).zxid;
        if (l3 != l2) {
            LOG.e("Committing zxid 0x" + Long.toHexString(l2) + " but next pending txn 0x" + Long.toHexString(l3));
            ServiceUtils.requestSystemExit(ExitCode.UNMATCHED_TXN_COMMIT.getValue());
        }
        Request request = (Request)this.pendingTxns.remove();
        request.logLatency(ServerMetrics.getMetrics().COMMIT_PROPAGATION_LATENCY);
        this.commitProcessor.commit(request);
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.d("Not expecting a sync.");
            return;
        }
        Request request = (Request)this.pendingSyncs.remove();
        if (request instanceof LearnerSyncRequest) {
            LearnerSyncRequest learnerSyncRequest = (LearnerSyncRequest)request;
            learnerSyncRequest.fh.queuePacket(new QuorumPacket(7, 0L, null, null));
        }
        this.commitProcessor.commit(request);
    }

    @Override
    public int getGlobalOutstandingLimit() {
        int n2 = this.self.getQuorumSize() > 2 ? this.self.getQuorumSize() - 1 : 1;
        int n3 = super.getGlobalOutstandingLimit() / n2;
        return n3;
    }

    @Override
    public String getState() {
        return "follower";
    }

    @Override
    public Learner getLearner() {
        return this.getFollower();
    }

    void processObserverRequest(Request request) {
        ((FollowerRequestProcessor)this.firstProcessor).processRequest(request, false);
    }

    boolean registerJMX(LearnerHandlerBean learnerHandlerBean) {
        try {
            MBeanRegistry.getInstance().register(learnerHandlerBean, this.jmxServerBean);
            return true;
        }
        catch (JMException jMException) {
            LOG.c("Could not register connection", jMException);
            return false;
        }
    }

    @Override
    protected void registerMetrics() {
        super.registerMetrics();
        MetricsContext metricsContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        metricsContext.registerGauge("synced_observers", this.self::getSynced_observers_metric);
    }

    @Override
    protected void unregisterMetrics() {
        super.unregisterMetrics();
        MetricsContext metricsContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        metricsContext.unregisterGauge("synced_observers");
    }

    private Request buildRequestToProcess(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
        Request request = new Request(txnHeader.getClientId(), txnHeader.getCxid(), txnHeader.getType(), txnHeader, mme2, txnHeader.getZxid());
        request.setTxnDigest(txnDigest);
        if ((request.zxid & 0xFFFFFFFFL) != 0L) {
            this.pendingTxns.add(request);
        }
        return request;
    }
}

