/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.ErrorTxn;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class FollowerRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final foe LOG = goe.a(FollowerRequestProcessor.class);
    public static final String SKIP_LEARNER_REQUEST_TO_NEXT_PROCESSOR = "zookeeper.follower.skipLearnerRequestToNextProcessor";
    private final boolean skipLearnerRequestToNextProcessor;
    FollowerZooKeeperServer zks;
    RequestProcessor nextProcessor;
    LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    boolean finished = false;

    public FollowerRequestProcessor(FollowerZooKeeperServer followerZooKeeperServer, RequestProcessor requestProcessor) {
        super("FollowerRequestProcessor:" + followerZooKeeperServer.getServerId(), followerZooKeeperServer.getZooKeeperServerListener());
        this.zks = followerZooKeeperServer;
        this.nextProcessor = requestProcessor;
        this.skipLearnerRequestToNextProcessor = Boolean.getBoolean(SKIP_LEARNER_REQUEST_TO_NEXT_PROCESSOR);
        LOG.c("Initialized FollowerRequestProcessor with {} as {}", (Object)SKIP_LEARNER_REQUEST_TO_NEXT_PROCESSOR, (Object)this.skipLearnerRequestToNextProcessor);
    }

    @Override
    public void run() {
        try {
            while (!this.finished) {
                ServerMetrics.getMetrics().LEARNER_REQUEST_PROCESSOR_QUEUE_SIZE.add(this.queuedRequests.size());
                Request request = this.queuedRequests.take();
                if (LOG.b()) {
                    ZooTrace.logRequest(LOG, 2L, 'F', request, "");
                }
                if (request != Request.requestOfDeath) {
                    if (!this.zks.authWriteRequest(request)) continue;
                    this.maybeSendRequestToNextProcessor(request);
                    if (request.isThrottled()) continue;
                    switch (request.type) {
                        case 9: {
                            this.zks.pendingSyncs.add(request);
                            this.zks.getFollower().request(request);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 19: 
                        case 20: 
                        case 21: {
                            this.zks.getFollower().request(request);
                            break;
                        }
                        case -11: 
                        case -10: {
                            if (request.isLocalSession()) break;
                            this.zks.getFollower().request(request);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException runtimeException) {
            this.handleException(this.getName(), runtimeException);
        }
        catch (Exception exception) {
            this.handleException(this.getName(), exception);
        }
        LOG.c("FollowerRequestProcessor exited loop!");
    }

    private void maybeSendRequestToNextProcessor(Request request) throws RequestProcessor.RequestProcessorException {
        if (this.skipLearnerRequestToNextProcessor && request.isFromLearner()) {
            ServerMetrics.getMetrics().SKIP_LEARNER_REQUEST_TO_NEXT_PROCESSOR_COUNT.add(1L);
        } else {
            this.nextProcessor.processRequest(request);
        }
    }

    @Override
    public void processRequest(Request request) {
        this.processRequest(request, true);
    }

    void processRequest(Request request, boolean bl2) {
        if (!this.finished) {
            if (bl2) {
                Request request2 = null;
                try {
                    request2 = this.zks.checkUpgradeSession(request);
                }
                catch (KeeperException keeperException) {
                    if (request.getHdr() != null) {
                        request.getHdr().setType(-1);
                        request.setTxn(new ErrorTxn(keeperException.code().intValue()));
                    }
                    request.setException(keeperException);
                    LOG.c("Error creating upgrade request", keeperException);
                }
                catch (IOException iOException) {
                    LOG.d("Unexpected error in upgrade", iOException);
                }
                if (request2 != null) {
                    this.queuedRequests.add(request2);
                }
            }
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        LOG.c("Shutting down");
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

