/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Follower;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.FollowerMXBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ObserverMaster;

public class FollowerBean
extends ZooKeeperServerBean
implements FollowerMXBean {
    private final Follower follower;

    public FollowerBean(Follower follower, ZooKeeperServer zooKeeperServer) {
        super(zooKeeperServer);
        this.follower = follower;
    }

    @Override
    public String getName() {
        return "Follower";
    }

    @Override
    public String getQuorumAddress() {
        return this.follower.sock.toString();
    }

    @Override
    public String getLastQueuedZxid() {
        return "0x" + Long.toHexString(this.follower.getLastQueued());
    }

    @Override
    public int getPendingRevalidationCount() {
        return this.follower.getPendingRevalidationsCount();
    }

    @Override
    public long getElectionTimeTaken() {
        return this.follower.self.getElectionTimeTaken();
    }

    @Override
    public int getObserverMasterPacketSizeLimit() {
        return this.follower.om == null ? -1 : this.follower.om.getPktsSizeLimit();
    }

    @Override
    public void setObserverMasterPacketSizeLimit(int n2) {
        ObserverMaster.setPktsSizeLimit(n2);
    }

    @Override
    public int getMaxConcurrentSnapSyncs() {
        ObserverMaster observerMaster = this.follower.om;
        return observerMaster == null ? -1 : observerMaster.getMaxConcurrentSnapSyncs();
    }

    @Override
    public void setMaxConcurrentSnapSyncs(int n2) {
        ObserverMaster observerMaster = this.follower.om;
        if (observerMaster != null) {
            observerMaster.setMaxConcurrentSnapSyncs(n2);
        }
    }

    @Override
    public int getMaxConcurrentDiffSyncs() {
        ObserverMaster observerMaster = this.follower.om;
        return observerMaster == null ? -1 : observerMaster.getMaxConcurrentDiffSyncs();
    }

    @Override
    public void setMaxConcurrentDiffSyncs(int n2) {
        ObserverMaster observerMaster = this.follower.om;
        if (observerMaster != null) {
            observerMaster.setMaxConcurrentDiffSyncs(n2);
        }
    }
}

