/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum;

import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.TxnLogEntry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.FollowerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Learner;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ObserverMaster;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPacket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.SerializeUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.ZxidUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.SetDataTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class Follower
extends Learner {
    private long lastQueued;
    final FollowerZooKeeperServer fzk;
    ObserverMaster om;

    Follower(QuorumPeer quorumPeer, FollowerZooKeeperServer followerZooKeeperServer) {
        this.self = Objects.requireNonNull(quorumPeer);
        this.fzk = Objects.requireNonNull(followerZooKeeperServer);
        this.zk = followerZooKeeperServer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Follower ").append(this.sock);
        stringBuilder.append(" lastQueuedZxid:").append(this.lastQueued);
        stringBuilder.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void followLeader() throws InterruptedException {
        this.self.end_fle = Time.currentElapsedTime();
        long l2 = this.self.end_fle - this.self.start_fle;
        this.self.setElectionTimeTaken(l2);
        ServerMetrics.getMetrics().ELECTION_TIME.add(l2);
        LOG.c("FOLLOWING - LEADER ELECTION TOOK - {} {}", (Object)l2, (Object)"MS");
        this.self.start_fle = 0L;
        this.self.end_fle = 0L;
        this.fzk.registerJMX(new FollowerBean(this, this.zk), this.self.jmxLocalPeerBean);
        long l3 = 0L;
        boolean bl2 = false;
        try {
            this.self.setZabState(QuorumPeer.ZabState.DISCOVERY);
            QuorumPeer.QuorumServer quorumServer = this.findLeader();
            try {
                this.connectToLeader(quorumServer.addr, quorumServer.hostname);
                l3 = System.currentTimeMillis();
                long l4 = this.registerWithLeader(11);
                if (this.self.isReconfigStateChange()) {
                    throw new Exception("learned about role change");
                }
                long l5 = ZxidUtils.getEpochFromZxid(l4);
                if (l5 < this.self.getAcceptedEpoch()) {
                    LOG.e("Proposed leader epoch " + ZxidUtils.zxidToString(l4) + " is less than our accepted epoch " + ZxidUtils.zxidToString(this.self.getAcceptedEpoch()));
                    throw new IOException("Error: Epoch of leader is lower");
                }
                long l6 = Time.currentElapsedTime();
                this.self.setLeaderAddressAndId(quorumServer.addr, quorumServer.getId());
                this.self.setZabState(QuorumPeer.ZabState.SYNCHRONIZATION);
                this.syncWithLeader(l4);
                this.self.setZabState(QuorumPeer.ZabState.BROADCAST);
                bl2 = true;
                long l7 = Time.currentElapsedTime() - l6;
                ServerMetrics.getMetrics().FOLLOWER_SYNC_TIME.add(l7);
                if (this.self.getObserverMasterPort() > 0) {
                    LOG.c("Starting ObserverMaster");
                    this.om = new ObserverMaster(this.self, this.fzk, this.self.getObserverMasterPort());
                    this.om.start();
                } else {
                    this.om = null;
                }
                QuorumPacket quorumPacket = new QuorumPacket();
                while (this.isRunning()) {
                    this.readPacket(quorumPacket);
                    this.processPacket(quorumPacket);
                }
            }
            catch (Exception exception) {
                LOG.c("Exception when following the leader", exception);
                this.closeSocket();
                this.pendingRevalidations.clear();
            }
            if (this.om != null) {
                this.om.stop();
            }
            this.zk.unregisterJMX(this);
            if (l3 == 0L) return;
        }
        catch (Throwable throwable) {
            if (this.om != null) {
                this.om.stop();
            }
            this.zk.unregisterJMX(this);
            if (l3 == 0L) throw throwable;
            long l8 = System.currentTimeMillis() - l3;
            LOG.c("Disconnected from leader (with address: {}). Was connected for {}ms. Sync state: {}", this.leaderAddr, l8, bl2);
            this.messageTracker.dumpToLog(this.leaderAddr.toString());
            throw throwable;
        }
        long l9 = System.currentTimeMillis() - l3;
        LOG.c("Disconnected from leader (with address: {}). Was connected for {}ms. Sync state: {}", this.leaderAddr, l9, bl2);
        this.messageTracker.dumpToLog(this.leaderAddr.toString());
    }

    protected void processPacket(QuorumPacket quorumPacket) throws Exception {
        switch (quorumPacket.getType()) {
            case 5: {
                this.ping(quorumPacket);
                break;
            }
            case 2: {
                long l2;
                long l3;
                ServerMetrics.getMetrics().LEARNER_PROPOSAL_RECEIVED_COUNT.add(1L);
                TxnLogEntry txnLogEntry = SerializeUtils.deserializeTxn(quorumPacket.getData());
                TxnHeader txnHeader = txnLogEntry.getHeader();
                mme mme2 = txnLogEntry.getTxn();
                TxnDigest txnDigest = txnLogEntry.getDigest();
                if (txnHeader.getZxid() != this.lastQueued + 1L) {
                    LOG.d("Got zxid 0x{} expected 0x{}", (Object)Long.toHexString(txnHeader.getZxid()), (Object)Long.toHexString(this.lastQueued + 1L));
                }
                this.lastQueued = txnHeader.getZxid();
                if (txnHeader.getType() == 16) {
                    SetDataTxn setDataTxn = (SetDataTxn)mme2;
                    QuorumVerifier quorumVerifier = this.self.configFromString(new String(setDataTxn.getData(), StandardCharsets.UTF_8));
                    this.self.setLastSeenQuorumVerifier(quorumVerifier, true);
                }
                this.fzk.logRequest(txnHeader, mme2, txnDigest);
                if (txnHeader != null && (l3 = (l2 = Time.currentWallTime()) - txnHeader.getTime()) >= 0L) {
                    ServerMetrics.getMetrics().PROPOSAL_LATENCY.add(l3);
                }
                if (this.om == null) break;
                long l4 = Time.currentElapsedTime();
                this.om.proposalReceived(quorumPacket);
                ServerMetrics.getMetrics().OM_PROPOSAL_PROCESS_TIME.add(Time.currentElapsedTime() - l4);
                break;
            }
            case 4: {
                ServerMetrics.getMetrics().LEARNER_COMMIT_RECEIVED_COUNT.add(1L);
                this.fzk.commit(quorumPacket.getZxid());
                if (this.om == null) break;
                long l5 = Time.currentElapsedTime();
                this.om.proposalCommitted(quorumPacket.getZxid());
                ServerMetrics.getMetrics().OM_COMMIT_PROCESS_TIME.add(Time.currentElapsedTime() - l5);
                break;
            }
            case 9: {
                Request request = (Request)this.fzk.pendingTxns.element();
                SetDataTxn setDataTxn = (SetDataTxn)request.getTxn();
                QuorumVerifier quorumVerifier = this.self.configFromString(new String(setDataTxn.getData(), StandardCharsets.UTF_8));
                ByteBuffer byteBuffer = ByteBuffer.wrap(quorumPacket.getData());
                long l6 = byteBuffer.getLong();
                long l7 = quorumPacket.getZxid();
                boolean bl2 = this.self.processReconfig(quorumVerifier, l6, l7, true);
                this.fzk.commit(l7);
                if (this.om != null) {
                    this.om.informAndActivate(l7, l6);
                }
                if (!bl2) break;
                throw new Exception("changes proposed in reconfig");
            }
            case 12: {
                LOG.e("Received an UPTODATE message after Follower started");
                break;
            }
            case 6: {
                if (this.om != null && this.om.revalidateLearnerSession(quorumPacket)) break;
                this.revalidate(quorumPacket);
                break;
            }
            case 7: {
                this.fzk.sync();
                break;
            }
            default: {
                LOG.d("Unknown packet type: {}", (Object)LearnerHandler.packetToString(quorumPacket));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZxid() {
        FollowerZooKeeperServer followerZooKeeperServer = this.fzk;
        synchronized (followerZooKeeperServer) {
            return this.fzk.getZxid();
        }
    }

    protected long getLastQueued() {
        return this.lastQueued;
    }

    public Integer getSyncedObserverSize() {
        return this.om == null ? null : Integer.valueOf(this.om.getNumActiveObservers());
    }

    public Iterable<Map<String, Object>> getSyncedObserversInfo() {
        if (this.om != null && this.om.getNumActiveObservers() > 0) {
            return this.om.getActiveObservers();
        }
        return Collections.emptySet();
    }

    public void resetObserverConnectionStats() {
        if (this.om != null && this.om.getNumActiveObservers() > 0) {
            this.om.resetObserverConnectionStats();
        }
    }

    @Override
    public void shutdown() {
        LOG.c("shutdown Follower");
        super.shutdown();
    }
}

