/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapStream;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public class Util {
    private static final foe LOG = goe.a(Util.class);
    private static final String SNAP_DIR = "snapDir";
    private static final String LOG_DIR = "logDir";
    private static final String DB_FORMAT_CONV = "dbFormatConversion";

    public static String makeURIString(String string, String string2, String string3) {
        String string4 = "file:snapDir=" + string + ";" + LOG_DIR + "=" + string2;
        if (string3 != null) {
            string4 = string4 + ";dbFormatConversion=" + string3;
        }
        return string4.replace('\\', '/');
    }

    public static URI makeFileLoggerURL(File file, File file2) {
        return URI.create(Util.makeURIString(file.getPath(), file2.getPath(), null));
    }

    public static URI makeFileLoggerURL(File file, File file2, String string) {
        return URI.create(Util.makeURIString(file.getPath(), file2.getPath(), string));
    }

    public static String makeLogName(long l2) {
        return "log." + Long.toHexString(l2);
    }

    public static String makeSnapshotName(long l2) {
        return "snapshot." + Long.toHexString(l2) + SnapStream.getStreamMode().getFileExtension();
    }

    public static File getSnapDir(Properties properties) {
        return new File(properties.getProperty(SNAP_DIR));
    }

    public static File getLogDir(Properties properties) {
        return new File(properties.getProperty(LOG_DIR));
    }

    public static String getFormatConversionPolicy(Properties properties) {
        return properties.getProperty(DB_FORMAT_CONV);
    }

    public static long getZxidFromName(String string, String string2) {
        long l2 = -1L;
        String[] stringArray = string.split("\\.");
        if (stringArray.length >= 2 && stringArray[0].equals(string2)) {
            try {
                l2 = Long.parseLong(stringArray[1], 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l2;
    }

    public static byte[] readTxnBytes(kme kme2) throws IOException {
        try {
            byte[] byArray = kme2.f("txtEntry");
            if (byArray.length == 0) {
                return byArray;
            }
            if (kme2.a("EOF") != 66) {
                LOG.e("Last transaction was partial.");
                return null;
            }
            return byArray;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    public static byte[] marshallTxnEntry(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ime ime2 = ime.a(byteArrayOutputStream);
        txnHeader.serialize(ime2, "hdr");
        if (mme2 != null) {
            mme2.serialize(ime2, "txn");
        }
        if (txnDigest != null) {
            txnDigest.serialize(ime2, "digest");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeTxnBytes(lme lme2, byte[] byArray) throws IOException {
        lme2.a(byArray, "txnEntry");
        lme2.a((byte)66, "EOR");
    }

    public static List<File> sortDataDir(File[] fileArray, String string, boolean bl2) {
        if (fileArray == null) {
            return new ArrayList<File>(0);
        }
        List<File> list = Arrays.asList(fileArray);
        Collections.sort(list, new DataDirFileComparator(string, bl2));
        return list;
    }

    public static boolean isLogFileName(String string) {
        return string.startsWith("log.");
    }

    public static boolean isSnapshotFileName(String string) {
        return string.startsWith("snapshot.");
    }

    static class DataDirFileComparator
    implements Serializable,
    Comparator<File> {
        private static final long serialVersionUID = -2648639884525140318L;
        private String prefix;
        private boolean ascending;

        public DataDirFileComparator(String string, boolean bl2) {
            this.prefix = string;
            this.ascending = bl2;
        }

        @Override
        public int compare(File file, File file2) {
            long l2;
            long l3 = Util.getZxidFromName(file.getName(), this.prefix);
            int n2 = l3 < (l2 = Util.getZxidFromName(file2.getName(), this.prefix)) ? -1 : (l3 > l2 ? 1 : 0);
            return this.ascending ? n2 : -n2;
        }
    }
}

