/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerStats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileSnap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapShot;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapshotInfo;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.TxnLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateSessionTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileTxnSnapLog {
    final File dataDir;
    final File snapDir;
    TxnLog txnLog;
    SnapShot snapLog;
    private final boolean autoCreateDB;
    private final boolean trustEmptySnapshot;
    public static final int VERSION = 2;
    public static final String version = "version-";
    private static final foe LOG = goe.a(FileTxnSnapLog.class);
    public static final String ZOOKEEPER_DATADIR_AUTOCREATE = "zookeeper.datadir.autocreate";
    public static final String ZOOKEEPER_DATADIR_AUTOCREATE_DEFAULT = "true";
    static final String ZOOKEEPER_DB_AUTOCREATE = "zookeeper.db.autocreate";
    private static final String ZOOKEEPER_DB_AUTOCREATE_DEFAULT = "true";
    public static final String ZOOKEEPER_SNAPSHOT_TRUST_EMPTY = "zookeeper.snapshot.trust.empty";
    private static final String EMPTY_SNAPSHOT_WARNING = "No snapshot found, but there are log entries. ";

    public FileTxnSnapLog(File file, File file2) throws IOException {
        LOG.b("Opening datadir:{} snapDir:{}", (Object)file, (Object)file2);
        this.dataDir = new File(file, "version-2");
        this.snapDir = new File(file2, "version-2");
        boolean bl2 = Boolean.parseBoolean(System.getProperty(ZOOKEEPER_DATADIR_AUTOCREATE, "true"));
        this.trustEmptySnapshot = Boolean.getBoolean(ZOOKEEPER_SNAPSHOT_TRUST_EMPTY);
        LOG.c("{} : {}", (Object)ZOOKEEPER_SNAPSHOT_TRUST_EMPTY, (Object)this.trustEmptySnapshot);
        if (!this.dataDir.exists()) {
            if (!bl2) {
                throw new DatadirException(String.format("Missing data directory %s, automatic data directory creation is disabled (%s is false). Please create this directory manually.", this.dataDir, ZOOKEEPER_DATADIR_AUTOCREATE));
            }
            if (!this.dataDir.mkdirs() && !this.dataDir.exists()) {
                throw new DatadirException("Unable to create data directory " + this.dataDir);
            }
        }
        if (!this.dataDir.canWrite()) {
            throw new DatadirException("Cannot write to data directory " + this.dataDir);
        }
        if (!this.snapDir.exists()) {
            if (!bl2) {
                throw new DatadirException(String.format("Missing snap directory %s, automatic data directory creation is disabled (%s is false).Please create this directory manually.", this.snapDir, ZOOKEEPER_DATADIR_AUTOCREATE));
            }
            if (!this.snapDir.mkdirs() && !this.snapDir.exists()) {
                throw new DatadirException("Unable to create snap directory " + this.snapDir);
            }
        }
        if (!this.snapDir.canWrite()) {
            throw new DatadirException("Cannot write to snap directory " + this.snapDir);
        }
        if (!this.dataDir.getPath().equals(this.snapDir.getPath())) {
            this.checkLogDir();
            this.checkSnapDir();
        }
        this.txnLog = new FileTxnLog(this.dataDir);
        this.snapLog = new FileSnap(this.snapDir);
        this.autoCreateDB = Boolean.parseBoolean(System.getProperty(ZOOKEEPER_DB_AUTOCREATE, "true"));
    }

    public void setServerStats(ServerStats serverStats) {
        this.txnLog.setServerStats(serverStats);
    }

    private void checkLogDir() throws LogDirContentCheckException {
        File[] fileArray = this.dataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return Util.isSnapshotFileName(string);
            }
        });
        if (fileArray != null && fileArray.length > 0) {
            throw new LogDirContentCheckException("Log directory has snapshot files. Check if dataLogDir and dataDir configuration is correct.");
        }
    }

    private void checkSnapDir() throws SnapDirContentCheckException {
        File[] fileArray = this.snapDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return Util.isLogFileName(string);
            }
        });
        if (fileArray != null && fileArray.length > 0) {
            throw new SnapDirContentCheckException("Snapshot directory has log files. Check if dataLogDir and dataDir configuration is correct.");
        }
    }

    public File getDataLogDir() {
        return this.dataDir;
    }

    public File getSnapDir() {
        return this.snapDir;
    }

    public SnapshotInfo getLastSnapshotInfo() {
        return this.snapLog.getLastSnapshotInfo();
    }

    public boolean shouldForceWriteInitialSnapshotAfterLeaderElection() {
        return this.trustEmptySnapshot && this.getLastSnapshotInfo() == null;
    }

    public long restore(DataTree dataTree, Map<Long, Integer> map, PlayBackListener playBackListener) throws IOException {
        boolean bl2;
        long l2 = Time.currentElapsedTime();
        long l3 = this.snapLog.deserialize(dataTree, map);
        ServerMetrics.getMetrics().STARTUP_SNAP_LOAD_TIME.add(Time.currentElapsedTime() - l2);
        FileTxnLog fileTxnLog = new FileTxnLog(this.dataDir);
        File file = new File(this.dataDir.getParent(), "initialize");
        if (Files.deleteIfExists(file.toPath())) {
            LOG.c("Initialize file found, an empty database will not block voting participation");
            bl2 = true;
        } else {
            bl2 = this.autoCreateDB;
        }
        RestoreFinalizer restoreFinalizer = () -> {
            long l2 = this.fastForwardFromEdits(dataTree, map, playBackListener);
            DataTree.ZxidDigest zxidDigest = dataTree.getDigestFromLoadedSnapshot();
            if (zxidDigest != null) {
                LOG.d("Highest txn zxid 0x{} is not covering the snapshot digest zxid 0x{}, which might lead to inconsistent state", (Object)Long.toHexString(l2), (Object)Long.toHexString(zxidDigest.getZxid()));
            }
            return l2;
        };
        if (-1L == l3) {
            if (fileTxnLog.getLastLoggedZxid() != -1L) {
                if (!this.trustEmptySnapshot) {
                    throw new IOException("No snapshot found, but there are log entries. Something is broken!");
                }
                LOG.d("{}This should only be allowed during upgrading.", (Object)EMPTY_SNAPSHOT_WARNING);
                return restoreFinalizer.run();
            }
            if (bl2) {
                this.save(dataTree, (ConcurrentHashMap)map, false);
                return 0L;
            }
            LOG.d("Unexpected empty data tree, setting zxid to -1");
            dataTree.lastProcessedZxid = -1L;
            return -1L;
        }
        return restoreFinalizer.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fastForwardFromEdits(DataTree dataTree, Map<Long, Integer> map, PlayBackListener playBackListener) throws IOException {
        TxnLog.TxnIterator txnIterator = this.txnLog.read(dataTree.lastProcessedZxid + 1L);
        long l2 = dataTree.lastProcessedZxid;
        int n2 = 0;
        long l3 = Time.currentElapsedTime();
        try {
            do {
                TxnHeader txnHeader;
                if ((txnHeader = txnIterator.getHeader()) == null) {
                    long l4 = dataTree.lastProcessedZxid;
                    return l4;
                }
                if (txnHeader.getZxid() < l2 && l2 != 0L) {
                    LOG.e("{}(highestZxid) > {}(next log) for type {}", l2, txnHeader.getZxid(), txnHeader.getType());
                } else {
                    l2 = txnHeader.getZxid();
                }
                try {
                    this.processTransaction(txnHeader, dataTree, map, txnIterator.getTxn());
                    dataTree.compareDigest(txnHeader, txnIterator.getTxn(), txnIterator.getDigest());
                    ++n2;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    throw new IOException("Failed to process transaction type: " + txnHeader.getType() + " error: " + noNodeException.getMessage(), noNodeException);
                }
                playBackListener.onTxnLoaded(txnHeader, txnIterator.getTxn(), txnIterator.getDigest());
            } while (txnIterator.next());
        }
        finally {
            if (txnIterator != null) {
                txnIterator.close();
            }
        }
        long l5 = Time.currentElapsedTime() - l3;
        LOG.c("{} txns loaded in {} ms", (Object)n2, (Object)l5);
        ServerMetrics.getMetrics().STARTUP_TXNS_LOADED.add(n2);
        ServerMetrics.getMetrics().STARTUP_TXNS_LOAD_TIME.add(l5);
        return l2;
    }

    public TxnLog.TxnIterator readTxnLog(long l2) throws IOException {
        return this.readTxnLog(l2, true);
    }

    public TxnLog.TxnIterator readTxnLog(long l2, boolean bl2) throws IOException {
        FileTxnLog fileTxnLog = new FileTxnLog(this.dataDir);
        return fileTxnLog.read(l2, bl2);
    }

    public void processTransaction(TxnHeader txnHeader, DataTree dataTree, Map<Long, Integer> map, mme mme2) throws KeeperException.NoNodeException {
        DataTree.ProcessTxnResult processTxnResult;
        switch (txnHeader.getType()) {
            case -10: {
                map.put(txnHeader.getClientId(), ((CreateSessionTxn)mme2).getTimeOut());
                if (LOG.b()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- create session in log: 0x" + Long.toHexString(txnHeader.getClientId()) + " with timeout: " + ((CreateSessionTxn)mme2).getTimeOut());
                }
                processTxnResult = dataTree.processTxn(txnHeader, mme2);
                break;
            }
            case -11: {
                map.remove(txnHeader.getClientId());
                if (LOG.b()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- close session in log: 0x" + Long.toHexString(txnHeader.getClientId()));
                }
                processTxnResult = dataTree.processTxn(txnHeader, mme2);
                break;
            }
            default: {
                processTxnResult = dataTree.processTxn(txnHeader, mme2);
            }
        }
        if (processTxnResult.err != KeeperException.Code.OK.intValue()) {
            LOG.b("Ignoring processTxn failure hdr: {}, error: {}, path: {}", txnHeader.getType(), processTxnResult.err, processTxnResult.path);
        }
    }

    public long getLastLoggedZxid() {
        FileTxnLog fileTxnLog = new FileTxnLog(this.dataDir);
        return fileTxnLog.getLastLoggedZxid();
    }

    public File save(DataTree dataTree, ConcurrentHashMap<Long, Integer> concurrentHashMap, boolean bl2) throws IOException {
        long l2 = dataTree.lastProcessedZxid;
        File file = new File(this.snapDir, Util.makeSnapshotName(l2));
        LOG.c("Snapshotting: 0x{} to {}", (Object)Long.toHexString(l2), (Object)file);
        try {
            this.snapLog.serialize(dataTree, concurrentHashMap, file, bl2);
            return file;
        }
        catch (IOException iOException) {
            if (file.length() == 0L) {
                if (file.delete()) {
                    LOG.c("Deleted empty snapshot file: {}", (Object)file.getAbsolutePath());
                } else {
                    LOG.d("Could not delete empty snapshot file: {}", (Object)file.getAbsolutePath());
                }
            }
            throw iOException;
        }
    }

    public boolean truncateLog(long l2) {
        boolean bl2;
        this.close();
        FileTxnLog fileTxnLog = new FileTxnLog(this.dataDir);
        try {
            boolean bl3 = fileTxnLog.truncate(l2);
            this.txnLog = new FileTxnLog(this.dataDir);
            this.snapLog = new FileSnap(this.snapDir);
            bl2 = bl3;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileTxnLog.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                LOG.d("Unable to truncate Txn log", iOException);
                return false;
            }
        }
        fileTxnLog.close();
        return bl2;
    }

    public File findMostRecentSnapshot() throws IOException {
        FileSnap fileSnap = new FileSnap(this.snapDir);
        return fileSnap.findMostRecentSnapshot();
    }

    public List<File> findNRecentSnapshots(int n2) throws IOException {
        FileSnap fileSnap = new FileSnap(this.snapDir);
        return fileSnap.findNRecentSnapshots(n2);
    }

    public List<File> findNValidSnapshots(int n2) {
        FileSnap fileSnap = new FileSnap(this.snapDir);
        return fileSnap.findNValidSnapshots(n2);
    }

    public File[] getSnapshotLogs(long l2) {
        return FileTxnLog.getLogFiles(this.dataDir.listFiles(), l2);
    }

    public boolean append(Request request) throws IOException {
        return this.txnLog.append(request);
    }

    public void commit() throws IOException {
        this.txnLog.commit();
    }

    public long getTxnLogElapsedSyncTime() {
        return this.txnLog.getTxnLogSyncElapsedTime();
    }

    public void rollLog() throws IOException {
        this.txnLog.rollLog();
    }

    public void close() throws IOException {
        TxnLog txnLog = this.txnLog;
        if (txnLog != null) {
            txnLog.close();
        }
        this.txnLog = null;
        SnapShot snapShot = this.snapLog;
        if (snapShot != null) {
            snapShot.close();
        }
        this.snapLog = null;
    }

    public void setTotalLogSize(long l2) {
        this.txnLog.setTotalLogSize(l2);
    }

    public long getTotalLogSize() {
        return this.txnLog.getTotalLogSize();
    }

    public static class SnapDirContentCheckException
    extends DatadirException {
        public SnapDirContentCheckException(String string) {
            super(string);
        }
    }

    public static class LogDirContentCheckException
    extends DatadirException {
        public LogDirContentCheckException(String string) {
            super(string);
        }
    }

    public static class DatadirException
    extends IOException {
        public DatadirException(String string) {
            super(string);
        }

        public DatadirException(String string, Exception exception) {
            super(string, exception);
        }
    }

    static interface RestoreFinalizer {
        public long run() throws IOException;
    }

    public static interface PlayBackListener {
        public void onTxnLoaded(TxnHeader var1, mme var2, TxnDigest var3);
    }
}

