/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.hme;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapShot;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapStream;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapshotInfo;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.SerializeUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;

public class FileSnap
implements SnapShot {
    File snapDir;
    SnapshotInfo lastSnapshotInfo = null;
    private volatile boolean close = false;
    private static final int VERSION = 2;
    private static final long dbId = -1L;
    private static final foe LOG = goe.a(FileSnap.class);
    public static final int SNAP_MAGIC = ByteBuffer.wrap("ZKSN".getBytes()).getInt();
    public static final String SNAPSHOT_FILE_PREFIX = "snapshot";

    public FileSnap(File file) {
        this.snapDir = file;
    }

    @Override
    public SnapshotInfo getLastSnapshotInfo() {
        return this.lastSnapshotInfo;
    }

    @Override
    public long deserialize(DataTree dataTree, Map<Long, Integer> map) throws IOException {
        List<File> list = this.findNValidSnapshots(100);
        if (list.size() == 0) {
            return -1L;
        }
        File file = null;
        long l2 = -1L;
        boolean bl2 = false;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            file = list.get(i2);
            LOG.c("Reading snapshot {}", (Object)file);
            l2 = Util.getZxidFromName(file.getName(), SNAPSHOT_FILE_PREFIX);
            try (CheckedInputStream checkedInputStream = SnapStream.getInputStream(file);){
                hme hme2 = hme.a(checkedInputStream);
                FileSnap.deserialize(dataTree, map, hme2);
                SnapStream.checkSealIntegrity(checkedInputStream, hme2);
                if (dataTree.deserializeZxidDigest(hme2, l2)) {
                    SnapStream.checkSealIntegrity(checkedInputStream, hme2);
                }
                if (dataTree.deserializeLastProcessedZxid(hme2)) {
                    SnapStream.checkSealIntegrity(checkedInputStream, hme2);
                }
                bl2 = true;
                break;
            }
            catch (IOException iOException) {
                LOG.d("problem reading snap file {}", (Object)file, (Object)iOException);
                continue;
            }
        }
        if (!bl2) {
            throw new IOException("Not able to find valid snapshots in " + this.snapDir);
        }
        dataTree.lastProcessedZxid = l2;
        this.lastSnapshotInfo = new SnapshotInfo(dataTree.lastProcessedZxid, file.lastModified() / 1000L);
        if (dataTree.getDigestFromLoadedSnapshot() != null) {
            dataTree.compareSnapshotDigests(dataTree.lastProcessedZxid);
        }
        return dataTree.lastProcessedZxid;
    }

    public static void deserialize(DataTree dataTree, Map<Long, Integer> map, kme kme2) throws IOException {
        FileHeader fileHeader = new FileHeader();
        fileHeader.deserialize(kme2, "fileheader");
        if (fileHeader.getMagic() != SNAP_MAGIC) {
            throw new IOException("mismatching magic headers " + fileHeader.getMagic() + " !=  " + SNAP_MAGIC);
        }
        SerializeUtils.deserializeSnapshot(dataTree, kme2, map);
    }

    @Override
    public File findMostRecentSnapshot() {
        List<File> list = this.findNValidSnapshots(1);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    protected List<File> findNValidSnapshots(int n2) {
        List<File> list = Util.sortDataDir(this.snapDir.listFiles(), SNAPSHOT_FILE_PREFIX, false);
        int n3 = 0;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            try {
                if (!SnapStream.isValidSnapshot(file)) continue;
                arrayList.add(file);
                if (++n3 != n2) continue;
                break;
            }
            catch (IOException iOException) {
                LOG.d("invalid snapshot {}", (Object)file, (Object)iOException);
            }
        }
        return arrayList;
    }

    public List<File> findNRecentSnapshots(int n2) throws IOException {
        List<File> list = Util.sortDataDir(this.snapDir.listFiles(), SNAPSHOT_FILE_PREFIX, false);
        int n3 = 0;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            if (n3 == n2) break;
            if (Util.getZxidFromName(file.getName(), SNAPSHOT_FILE_PREFIX) == -1L) continue;
            ++n3;
            arrayList.add(file);
        }
        return arrayList;
    }

    protected void serialize(DataTree dataTree, Map<Long, Integer> map, lme lme2, FileHeader fileHeader) throws IOException {
        if (fileHeader == null) {
            throw new IllegalStateException("Snapshot's not open for writing: uninitialized header");
        }
        fileHeader.serialize(lme2, "fileheader");
        SerializeUtils.serializeSnapshot(dataTree, lme2, map);
    }

    @Override
    public synchronized void serialize(DataTree dataTree, Map<Long, Integer> map, File file, boolean bl2) throws IOException {
        if (!this.close) {
            try (CheckedOutputStream checkedOutputStream = SnapStream.getOutputStream(file, bl2);){
                ime ime2 = ime.a(checkedOutputStream);
                FileHeader fileHeader = new FileHeader(SNAP_MAGIC, 2, -1L);
                this.serialize(dataTree, map, ime2, fileHeader);
                SnapStream.sealStream(checkedOutputStream, ime2);
                if (dataTree.serializeZxidDigest(ime2)) {
                    SnapStream.sealStream(checkedOutputStream, ime2);
                }
                if (dataTree.serializeLastProcessedZxid(ime2)) {
                    SnapStream.sealStream(checkedOutputStream, ime2);
                }
                this.lastSnapshotInfo = new SnapshotInfo(Util.getZxidFromName(file.getName(), SNAPSHOT_FILE_PREFIX), file.lastModified() / 1000L);
            }
        } else {
            throw new IOException("FileSnap has already been closed");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.close = true;
    }
}

