/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.Summary;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.AvgMinMaxCounter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.Metric;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformSnapshot;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class AvgMinMaxPercentileCounter
extends Metric
implements Summary {
    private final String name;
    private final AvgMinMaxCounter counter;
    private final ResettableUniformReservoir reservoir;
    private final Histogram histogram;

    public AvgMinMaxPercentileCounter(String string) {
        this.name = string;
        this.counter = new AvgMinMaxCounter(this.name);
        this.reservoir = new ResettableUniformReservoir();
        this.histogram = new Histogram((Reservoir)this.reservoir);
    }

    public void addDataPoint(long l2) {
        this.counter.add(l2);
        this.histogram.update(l2);
    }

    public void resetMax() {
        this.counter.resetMax();
    }

    @Override
    public void reset() {
        this.counter.reset();
        this.reservoir.reset();
    }

    @Override
    public void add(long l2) {
        this.addDataPoint(l2);
    }

    @Override
    public Map<String, Object> values() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.putAll(this.counter.values());
        linkedHashMap.put("p50_" + this.name, Math.round(this.histogram.getSnapshot().getMedian()));
        linkedHashMap.put("p95_" + this.name, Math.round(this.histogram.getSnapshot().get95thPercentile()));
        linkedHashMap.put("p99_" + this.name, Math.round(this.histogram.getSnapshot().get99thPercentile()));
        linkedHashMap.put("p999_" + this.name, Math.round(this.histogram.getSnapshot().get999thPercentile()));
        return linkedHashMap;
    }

    static class ResettableUniformReservoir
    implements Reservoir {
        private static final int DEFAULT_SIZE = 4096;
        private static final int BITS_PER_LONG = 63;
        private final AtomicLong count = new AtomicLong();
        private volatile AtomicLongArray values = new AtomicLongArray(4096);

        ResettableUniformReservoir() {
        }

        public int size() {
            long l2 = this.count.get();
            if (l2 > (long)this.values.length()) {
                return this.values.length();
            }
            return (int)l2;
        }

        public void update(long l2) {
            long l3 = this.count.incrementAndGet();
            if (l3 <= (long)this.values.length()) {
                this.values.set((int)l3 - 1, l2);
            } else {
                long l4 = ResettableUniformReservoir.nextLong(l3);
                if (l4 < (long)this.values.length()) {
                    this.values.set((int)l4, l2);
                }
            }
        }

        private static long nextLong(long l2) {
            long l3;
            long l4;
            while ((l4 = ThreadLocalRandom.current().nextLong() & Long.MAX_VALUE) - (l3 = l4 % l2) + (l2 - 1L) < 0L) {
            }
            return l3;
        }

        public Snapshot getSnapshot() {
            int n2 = this.size();
            ArrayList<Long> arrayList = new ArrayList<Long>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(this.values.get(i2));
            }
            return new UniformSnapshot(arrayList);
        }

        public void reset() {
            this.count.set(0L);
            this.values = new AtomicLongArray(4096);
        }
    }
}

