/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.Summary;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.Metric;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class AvgMinMaxCounter
extends Metric
implements Summary {
    private final String name;
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong count = new AtomicLong();

    public AvgMinMaxCounter(String string) {
        this.name = string;
    }

    public void addDataPoint(long l2) {
        this.total.addAndGet(l2);
        this.count.incrementAndGet();
        this.setMin(l2);
        this.setMax(l2);
    }

    private void setMax(long l2) {
        long l3;
        while (l2 > (l3 = this.max.get()) && !this.max.compareAndSet(l3, l2)) {
        }
    }

    private void setMin(long l2) {
        long l3;
        while (l2 < (l3 = this.min.get()) && !this.min.compareAndSet(l3, l2)) {
        }
    }

    public double getAvg() {
        long l2 = this.count.get();
        long l3 = this.total.get();
        if (l2 > 0L) {
            double d2 = (double)l3 / (double)l2;
            BigDecimal bigDecimal = new BigDecimal(d2);
            return bigDecimal.setScale(4, RoundingMode.HALF_UP).doubleValue();
        }
        return 0.0;
    }

    public long getCount() {
        return this.count.get();
    }

    public long getMax() {
        long l2 = this.max.get();
        return l2 == Long.MIN_VALUE ? 0L : l2;
    }

    public long getMin() {
        long l2 = this.min.get();
        return l2 == Long.MAX_VALUE ? 0L : l2;
    }

    public long getTotal() {
        return this.total.get();
    }

    public void resetMax() {
        this.max.set(this.getMin());
    }

    @Override
    public void reset() {
        this.count.set(0L);
        this.total.set(0L);
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
    }

    @Override
    public void add(long l2) {
        this.addDataPoint(l2);
    }

    @Override
    public Map<String, Object> values() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("avg_" + this.name, this.getAvg());
        linkedHashMap.put("min_" + this.name, this.getMin());
        linkedHashMap.put("max_" + this.name, this.getMax());
        linkedHashMap.put("cnt_" + this.name, this.getCount());
        linkedHashMap.put("sum_" + this.name, this.getTotal());
        return linkedHashMap;
    }
}

