/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.embedded;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DatadirCleanupManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerMain;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.embedded.ExitHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerMain;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.sasl.SaslException;

class ZooKeeperServerEmbeddedImpl
implements ZooKeeperServerEmbedded {
    private static final foe LOG = goe.a(ZooKeeperServerEmbeddedImpl.class);
    private final QuorumPeerConfig config;
    private QuorumPeerMain maincluster;
    private ZooKeeperServerMain mainsingle;
    private Thread thread;
    private DatadirCleanupManager purgeMgr;
    private final ExitHandler exitHandler;
    private volatile boolean stopping;
    private int boundClientPort;
    private int boundSecureClientPort;

    ZooKeeperServerEmbeddedImpl(Properties properties, Path path, ExitHandler exitHandler) throws Exception {
        if (!properties.containsKey("dataDir")) {
            properties.put("dataDir", path.resolve("data").toAbsolutePath().toString());
        }
        Path path2 = Files.createTempFile(path, "zookeeper.configuration", ".properties", new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(path2, new OpenOption[0]);){
            properties.store(outputStream, "Automatically generated at every-boot");
        }
        this.exitHandler = exitHandler;
        LOG.c("Current configuration is at {}", (Object)path2.toAbsolutePath());
        this.config = new QuorumPeerConfig();
        this.config.parse(path2.toAbsolutePath().toString());
        LOG.c("ServerID:" + this.config.getServerId());
        LOG.c("DataDir:" + this.config.getDataDir());
        LOG.c("Servers:" + this.config.getServers());
        LOG.c("ElectionPort:" + this.config.getElectionPort());
        LOG.c("SyncLimit:" + this.config.getSyncLimit());
        LOG.c("PeerType:" + (Object)((Object)this.config.getPeerType()));
        LOG.c("Distributed:" + this.config.isDistributed());
        LOG.c("SyncEnabled:" + this.config.getSyncEnabled());
        LOG.c("MetricsProviderClassName:" + this.config.getMetricsProviderClassName());
        for (Map.Entry entry : this.config.getServers().entrySet()) {
            LOG.c("Server: " + entry.getKey() + " -> addr " + ((QuorumPeer.QuorumServer)entry.getValue()).addr + " elect " + ((QuorumPeer.QuorumServer)entry.getValue()).electionAddr + " id=" + ((QuorumPeer.QuorumServer)entry.getValue()).id + " type " + (Object)((Object)((QuorumPeer.QuorumServer)entry.getValue()).type));
        }
    }

    @Override
    public void start() throws Exception {
        this.start(Integer.MAX_VALUE);
    }

    @Override
    public void start(long l2) throws Exception {
        switch (this.exitHandler) {
            case EXIT: {
                ServiceUtils.setSystemExitProcedure(ServiceUtils.SYSTEM_EXIT);
                break;
            }
            case LOG_ONLY: {
                ServiceUtils.setSystemExitProcedure(ServiceUtils.LOG_ONLY);
                break;
            }
            default: {
                ServiceUtils.setSystemExitProcedure(ServiceUtils.SYSTEM_EXIT);
            }
        }
        final CompletableFuture completableFuture = new CompletableFuture();
        if (this.config.getServers().size() > 1 || this.config.isDistributed()) {
            LOG.c("Running ZK Server in single Quorum MODE");
            this.maincluster = new QuorumPeerMain(){

                @Override
                protected QuorumPeer getQuorumPeer() throws SaslException {
                    return new QuorumPeer(){

                        @Override
                        public void start() {
                            super.start();
                            ZooKeeperServerEmbeddedImpl.this.boundClientPort = this.getClientPort();
                            ZooKeeperServerEmbeddedImpl.this.boundSecureClientPort = this.getSecureClientPort();
                            LOG.c("ZK Server {} started", (Object)this);
                            completableFuture.complete(null);
                        }
                    };
                }
            };
            this.purgeMgr = new DatadirCleanupManager(this.config.getDataDir(), this.config.getDataLogDir(), this.config.getSnapRetainCount(), this.config.getPurgeInterval());
            this.purgeMgr.start();
            this.thread = new Thread("zkservermainrunner"){

                @Override
                public void run() {
                    block3: {
                        try {
                            ZooKeeperServerEmbeddedImpl.this.maincluster.runFromConfig(ZooKeeperServerEmbeddedImpl.this.config);
                            ZooKeeperServerEmbeddedImpl.this.maincluster.close();
                            LOG.c("ZK server died. Requsting stop on JVM");
                            if (!ZooKeeperServerEmbeddedImpl.this.stopping) {
                                ServiceUtils.requestSystemExit(ExitCode.EXECUTION_FINISHED.getValue());
                            }
                        }
                        catch (Throwable throwable) {
                            LOG.d("error during server lifecycle", throwable);
                            ZooKeeperServerEmbeddedImpl.this.maincluster.close();
                            if (ZooKeeperServerEmbeddedImpl.this.stopping) break block3;
                            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
                        }
                    }
                }
            };
            this.thread.start();
        } else {
            LOG.c("Running ZK Server in single STANDALONE MODE");
            this.mainsingle = new ZooKeeperServerMain(){

                @Override
                public void serverStarted() {
                    LOG.c("ZK Server started");
                    ZooKeeperServerEmbeddedImpl.this.boundClientPort = this.getClientPort();
                    ZooKeeperServerEmbeddedImpl.this.boundSecureClientPort = this.getSecureClientPort();
                    completableFuture.complete(null);
                }
            };
            this.purgeMgr = new DatadirCleanupManager(this.config.getDataDir(), this.config.getDataLogDir(), this.config.getSnapRetainCount(), this.config.getPurgeInterval());
            this.purgeMgr.start();
            this.thread = new Thread("zkservermainrunner"){

                @Override
                public void run() {
                    block3: {
                        try {
                            ServerConfig serverConfig = new ServerConfig();
                            serverConfig.readFrom(ZooKeeperServerEmbeddedImpl.this.config);
                            LOG.c("ZK server starting");
                            ZooKeeperServerEmbeddedImpl.this.mainsingle.runFromConfig(serverConfig);
                            LOG.c("ZK server died. Requesting stop on JVM");
                            if (!ZooKeeperServerEmbeddedImpl.this.stopping) {
                                ServiceUtils.requestSystemExit(ExitCode.EXECUTION_FINISHED.getValue());
                            }
                        }
                        catch (Throwable throwable) {
                            LOG.d("error during server lifecycle", throwable);
                            ZooKeeperServerEmbeddedImpl.this.mainsingle.close();
                            if (ZooKeeperServerEmbeddedImpl.this.stopping) break block3;
                            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
                        }
                    }
                }
            };
            this.thread.start();
        }
        try {
            completableFuture.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            LOG.c("Startup timed out, trying to close");
            this.close();
            throw timeoutException;
        }
    }

    @Override
    public String getConnectionString() {
        return this.prettifyConnectionString(this.config.getClientPortAddress(), this.boundClientPort);
    }

    @Override
    public String getSecureConnectionString() {
        return this.prettifyConnectionString(this.config.getSecureClientPortAddress(), this.boundSecureClientPort);
    }

    private String prettifyConnectionString(InetSocketAddress inetSocketAddress, int n2) {
        if (inetSocketAddress != null) {
            return inetSocketAddress.getHostString().replace("0.0.0.0", "localhost").replace("0:0:0:0:0:0:0:0", "localhost") + ":" + n2;
        }
        throw new IllegalStateException("No client address is configured");
    }

    @Override
    public void close() {
        LOG.c("Stopping ZK Server");
        this.stopping = true;
        if (this.mainsingle != null) {
            this.mainsingle.close();
        }
        if (this.maincluster != null) {
            this.maincluster.close();
        }
    }
}

