/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.ControlCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.ControllableConnectionFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.IOException;

public class ZooKeeperServerController {
    private static final foe LOG = goe.a(ZooKeeperServerController.class);
    private static final long DEFAULT_DELAY_MS = 1000L;
    private QuorumPeer quorumPeer;
    private ControllableConnectionFactory cnxnFactory;

    public ZooKeeperServerController(QuorumPeerConfig quorumPeerConfig) throws IOException {
        if (quorumPeerConfig == null) {
            throw new IllegalArgumentException("ZooKeeperServerController requires a valid config!");
        }
        this.cnxnFactory = new ControllableConnectionFactory();
        this.cnxnFactory.configure(quorumPeerConfig.getClientPortAddress(), quorumPeerConfig.getMaxClientCnxns(), quorumPeerConfig.getClientPortListenBacklog());
        this.quorumPeer = QuorumPeer.createFromConfig(quorumPeerConfig);
        this.quorumPeer.setCnxnFactory(this.cnxnFactory);
    }

    public void run() {
        try {
            this.quorumPeer.start();
            this.quorumPeer.join();
        }
        catch (Exception exception) {
            LOG.d("Fatal error starting quorum peer", exception);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
    }

    protected ServerCnxnFactory getCnxnFactory() {
        return this.cnxnFactory;
    }

    public synchronized void shutdown() {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
            this.cnxnFactory = null;
        }
        if (this.quorumPeer != null && this.quorumPeer.isRunning()) {
            this.quorumPeer.shutdown();
            this.quorumPeer = null;
        }
    }

    public synchronized boolean isReady() {
        return this.cnxnFactory != null && this.quorumPeer != null && this.quorumPeer.isRunning() && this.quorumPeer.getActiveServer() != null;
    }

    public void processCommand(ControlCommand controlCommand) {
        if (controlCommand == null) {
            throw new IllegalArgumentException("Invalid command parameter!");
        }
        LOG.c("processing command {}{}", (Object)controlCommand.getAction(), (Object)(controlCommand.getParameter() == null ? "" : "[" + controlCommand.getParameter() + "]"));
        if (!this.isReady()) {
            throw new IllegalStateException("Service is not ready. It has already been shutdown or is still initializing.");
        }
        switch (controlCommand.getAction()) {
            case PING: {
                break;
            }
            case SHUTDOWN: {
                this.shutdown();
                break;
            }
            case CLOSECONNECTION: {
                if (controlCommand.getParameter() == null) {
                    this.cnxnFactory.closeAll(ServerCnxn.DisconnectReason.CLOSE_ALL_CONNECTIONS_FORCED);
                    break;
                }
                this.cnxnFactory.closeSession(Long.decode(controlCommand.getParameter()), ServerCnxn.DisconnectReason.CONNECTION_CLOSE_FORCED);
                break;
            }
            case EXPIRESESSION: {
                if (controlCommand.getParameter() == null) {
                    this.expireAllSessions();
                    break;
                }
                this.expireSession(Long.decode(controlCommand.getParameter()));
                break;
            }
            case REJECTCONNECTIONS: {
                break;
            }
            case ADDDELAY: {
                this.cnxnFactory.delayResponses(controlCommand.getParameter() == null ? 1000L : Long.decode(controlCommand.getParameter()));
                break;
            }
            case NORESPONSE: {
                if (controlCommand.getParameter() == null) {
                    this.cnxnFactory.holdAllFutureResponses();
                    break;
                }
                this.cnxnFactory.holdFutureResponses(Long.decode(controlCommand.getParameter()));
                break;
            }
            case FAILREQUESTS: {
                if (controlCommand.getParameter() == null) {
                    this.cnxnFactory.failAllFutureRequests();
                    break;
                }
                this.cnxnFactory.failFutureRequests(Long.decode(controlCommand.getParameter()));
                break;
            }
            case RESET: {
                this.cnxnFactory.resetBadBehavior();
                break;
            }
            case ELECTNEWLEADER: {
                this.quorumPeer.startLeaderElection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command: " + controlCommand);
            }
        }
    }

    private ZooKeeperServer getServer() {
        return this.quorumPeer.getActiveServer();
    }

    private void expireSession(long l2) {
        this.getServer().expire(l2);
    }

    private void expireAllSessions() {
        for (Long l2 : this.getServer().getSessionTracker().localSessions()) {
            this.expireSession(l2);
        }
        for (Long l2 : this.getServer().getSessionTracker().globalSessions()) {
            this.expireSession(l2);
        }
    }
}

