/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashMap;

public class ControllerServerConfig
extends QuorumPeerConfig {
    public static final String CONTROLLER_PORT_KEY = "zookeeper.controllerPort";
    public static final String CLIENT_PORT_KEY = "zookeeper.clientPortAddress";
    private InetSocketAddress controllerAddress;

    public InetSocketAddress getControllerAddress() {
        return this.controllerAddress;
    }

    public ControllerServerConfig(String string) throws QuorumPeerConfig.ConfigException {
        this.parse(string);
    }

    public ControllerServerConfig(InetAddress inetAddress, int n2, int n3, String string) {
        this.controllerAddress = new InetSocketAddress(inetAddress, n2);
        this.clientPortAddress = new InetSocketAddress(inetAddress, n3);
        this.dataLogDir = this.dataDir = new File(string);
        this.serverId = 0L;
    }

    public ControllerServerConfig(int n2, int n3, String string) {
        this(InetAddress.getLoopbackAddress(), n2, n3, string);
    }

    public ServerConfig getZooKeeperServerConfig() {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.readFrom(this);
        return serverConfig;
    }

    @Override
    public void parse(String string) throws QuorumPeerConfig.ConfigException {
        super.parse(string);
        for (String string2 : System.getProperties().stringPropertyNames()) {
            if (CONTROLLER_PORT_KEY.equalsIgnoreCase(string2)) {
                this.setControllerAddress(System.getProperty(string2));
            }
            if (!CLIENT_PORT_KEY.equals(string2)) continue;
            this.setClientAddress(System.getProperty(string2));
        }
        if (this.controllerAddress == null) {
            throw new QuorumPeerConfig.ConfigException("Missing required parameter zookeeper.controllerPort");
        }
        if (this.clientPortAddress == null) {
            throw new QuorumPeerConfig.ConfigException("Missing required parameter zookeeper.clientPortAddress");
        }
    }

    private void setControllerAddress(String string) {
        try {
            this.controllerAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port", numberFormatException);
        }
    }

    private void setClientAddress(String string) {
        try {
            this.clientPortAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port", numberFormatException);
        }
    }

    public void ensureComplete() throws IOException {
        if (this.quorumVerifier != null && this.quorumVerifier.getAllMembers().size() > 0) {
            return;
        }
        ServerSocket serverSocket = new ServerSocket(0);
        int n2 = serverSocket.getLocalPort();
        ServerSocket serverSocket2 = new ServerSocket(0);
        int n3 = serverSocket2.getLocalPort();
        serverSocket.close();
        serverSocket2.close();
        QuorumPeer.QuorumServer quorumServer = new QuorumPeer.QuorumServer(0L, new InetSocketAddress(n2), new InetSocketAddress(n3), this.clientPortAddress);
        HashMap<Long, QuorumPeer.QuorumServer> hashMap = new HashMap<Long, QuorumPeer.QuorumServer>();
        hashMap.put(quorumServer.id, quorumServer);
        this.quorumVerifier = new QuorumMaj(hashMap);
    }
}

