/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.controller.ControlCommand;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;

public class CommandClient {
    private final int requestTimeoutInMs;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final foe LOG = goe.a(CommandClient.class);
    private final int hostPort;
    private final String hostName;
    private HttpClient client = new HttpClient();
    private boolean started = false;

    public CommandClient(int n2, int n3) {
        this.requestTimeoutInMs = n3;
        this.hostName = "localhost";
        this.hostPort = n2;
    }

    public CommandClient(InetSocketAddress inetSocketAddress, int n2) {
        this.requestTimeoutInMs = n2;
        this.hostName = inetSocketAddress.getHostName();
        this.hostPort = inetSocketAddress.getPort();
    }

    public CommandClient(int n2) {
        this(n2, 10000);
    }

    public synchronized void close() {
        try {
            if (this.client != null) {
                this.client.stop();
                this.client = null;
            }
        }
        catch (Exception exception) {
            LOG.c("Exception during shutdown", exception);
        }
    }

    public boolean trySendCommand(ControlCommand.Action action) {
        return this.trySendCommand(action, null);
    }

    public boolean trySendCommand(ControlCommand.Action action, String string) {
        try {
            if (!this.started) {
                this.client.start();
                this.started = true;
            }
            ContentResponse contentResponse = this.sendCommand(action, string);
            LOG.c("Received {} response from the server", (Object)contentResponse);
            return contentResponse.getStatus() == 200;
        }
        catch (IOException | InterruptedException exception) {
            LOG.c("Failed to get response from server", exception);
        }
        catch (Exception exception) {
            LOG.d("Unknown exception when sending command", exception);
        }
        return false;
    }

    public ContentResponse sendCommand(ControlCommand.Action action, String string) throws Exception {
        String string2 = String.format("%s%s:%s/%s", "http://", this.hostName, this.hostPort, ControlCommand.createCommandUri(action, string));
        ContentResponse contentResponse = this.client.newRequest(string2).timeout((long)this.requestTimeoutInMs, TimeUnit.MILLISECONDS).send();
        LOG.c("Sent command {}", (Object)string2);
        LOG.c("Response body {}", (Object)new String(contentResponse.getContent(), StandardCharsets.UTF_8));
        return contentResponse;
    }
}

