/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.command;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FourLetterCommands {
    public static final int confCmd = ByteBuffer.wrap("conf".getBytes()).getInt();
    public static final int consCmd = ByteBuffer.wrap("cons".getBytes()).getInt();
    public static final int crstCmd = ByteBuffer.wrap("crst".getBytes()).getInt();
    public static final int dirsCmd = ByteBuffer.wrap("dirs".getBytes()).getInt();
    public static final int dumpCmd = ByteBuffer.wrap("dump".getBytes()).getInt();
    public static final int enviCmd = ByteBuffer.wrap("envi".getBytes()).getInt();
    public static final int getTraceMaskCmd = ByteBuffer.wrap("gtmk".getBytes()).getInt();
    public static final int ruokCmd = ByteBuffer.wrap("ruok".getBytes()).getInt();
    public static final int setTraceMaskCmd = ByteBuffer.wrap("stmk".getBytes()).getInt();
    public static final int srvrCmd = ByteBuffer.wrap("srvr".getBytes()).getInt();
    public static final int srstCmd = ByteBuffer.wrap("srst".getBytes()).getInt();
    public static final int statCmd = ByteBuffer.wrap("stat".getBytes()).getInt();
    public static final int wchcCmd = ByteBuffer.wrap("wchc".getBytes()).getInt();
    public static final int wchpCmd = ByteBuffer.wrap("wchp".getBytes()).getInt();
    public static final int wchsCmd = ByteBuffer.wrap("wchs".getBytes()).getInt();
    public static final int mntrCmd = ByteBuffer.wrap("mntr".getBytes()).getInt();
    public static final int isroCmd = ByteBuffer.wrap("isro".getBytes()).getInt();
    protected static final int hashCmd = ByteBuffer.wrap("hash".getBytes()).getInt();
    public static final int telnetCloseCmd = -720899;
    private static final String ZOOKEEPER_4LW_COMMANDS_WHITELIST = "zookeeper.4lw.commands.whitelist";
    private static final foe LOG = goe.a(FourLetterCommands.class);
    private static final Map<Integer, String> cmd2String = new HashMap<Integer, String>();
    private static final Set<String> whiteListedCommands = new HashSet<String>();
    private static boolean whiteListInitialized = false;

    public static synchronized void resetWhiteList() {
        whiteListInitialized = false;
        whiteListedCommands.clear();
    }

    public static String getCommandString(int n2) {
        return cmd2String.get(n2);
    }

    public static boolean isKnown(int n2) {
        return cmd2String.containsKey(n2);
    }

    public static synchronized boolean isEnabled(String string) {
        if (whiteListInitialized) {
            return whiteListedCommands.contains(string);
        }
        String string2 = System.getProperty(ZOOKEEPER_4LW_COMMANDS_WHITELIST);
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                if (string3.trim().equals("*")) {
                    for (Map.Entry<Integer, String> entry : cmd2String.entrySet()) {
                        whiteListedCommands.add(entry.getValue());
                    }
                    break;
                }
                if (string3.trim().isEmpty()) continue;
                whiteListedCommands.add(string3.trim());
            }
        }
        if (System.getProperty("readonlymode.enabled", "false").equals("true")) {
            whiteListedCommands.add("isro");
        }
        whiteListedCommands.add("srvr");
        whiteListInitialized = true;
        LOG.c("The list of known four letter word commands is : {}", (Object)Arrays.asList(cmd2String));
        LOG.c("The list of enabled four letter word commands is : {}", (Object)Arrays.asList(whiteListedCommands));
        return whiteListedCommands.contains(string);
    }

    static {
        cmd2String.put(confCmd, "conf");
        cmd2String.put(consCmd, "cons");
        cmd2String.put(crstCmd, "crst");
        cmd2String.put(dirsCmd, "dirs");
        cmd2String.put(dumpCmd, "dump");
        cmd2String.put(enviCmd, "envi");
        cmd2String.put(getTraceMaskCmd, "gtmk");
        cmd2String.put(ruokCmd, "ruok");
        cmd2String.put(setTraceMaskCmd, "stmk");
        cmd2String.put(srstCmd, "srst");
        cmd2String.put(srvrCmd, "srvr");
        cmd2String.put(statCmd, "stat");
        cmd2String.put(wchcCmd, "wchc");
        cmd2String.put(wchpCmd, "wchp");
        cmd2String.put(wchsCmd, "wchs");
        cmd2String.put(mntrCmd, "mntr");
        cmd2String.put(isroCmd, "isro");
        cmd2String.put(-720899, "telnet close");
        cmd2String.put(hashCmd, "hash");
    }
}

