/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ClientX509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Exception;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.AuthenticationProvider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;

public class X509AuthenticationProvider
implements AuthenticationProvider {
    public static final String X509_CERTIFICATE_ATTRIBUTE_NAME = "javax.servlet.request.X509Certificate";
    static final String ZOOKEEPER_X509AUTHENTICATIONPROVIDER_SUPERUSER = "zookeeper.X509AuthenticationProvider.superUser";
    private static final foe LOG = goe.a(X509AuthenticationProvider.class);
    private final X509TrustManager trustManager;
    private final X509KeyManager keyManager;

    public X509AuthenticationProvider() throws X509Exception {
        ZKConfig zKConfig = new ZKConfig();
        try (ClientX509Util clientX509Util = new ClientX509Util();){
            String string = zKConfig.getProperty(clientX509Util.getSslKeystoreLocationProperty(), "");
            String string2 = clientX509Util.getPasswordFromConfigPropertyOrFile(zKConfig, clientX509Util.getSslKeystorePasswdProperty(), clientX509Util.getSslKeystorePasswdPathProperty());
            String string3 = zKConfig.getProperty(clientX509Util.getSslKeystoreTypeProperty());
            boolean bl2 = Boolean.parseBoolean(zKConfig.getProperty(clientX509Util.getSslCrlEnabledProperty()));
            boolean bl3 = Boolean.parseBoolean(zKConfig.getProperty(clientX509Util.getSslOcspEnabledProperty()));
            boolean bl4 = Boolean.parseBoolean(zKConfig.getProperty(clientX509Util.getSslHostnameVerificationEnabledProperty()));
            X509KeyManager x509KeyManager = null;
            X509TrustManager x509TrustManager = null;
            if (string.isEmpty()) {
                LOG.d("keystore not specified for client connection");
            } else {
                try {
                    x509KeyManager = X509Util.createKeyManager(string, string2, string3);
                }
                catch (X509Exception.KeyManagerException keyManagerException) {
                    LOG.d("Failed to create key manager", keyManagerException);
                }
            }
            String string4 = zKConfig.getProperty(clientX509Util.getSslTruststoreLocationProperty(), "");
            String string5 = clientX509Util.getPasswordFromConfigPropertyOrFile(zKConfig, clientX509Util.getSslTruststorePasswdProperty(), clientX509Util.getSslTruststorePasswdPathProperty());
            String string6 = zKConfig.getProperty(clientX509Util.getSslTruststoreTypeProperty());
            boolean bl5 = clientX509Util.getFipsMode(zKConfig);
            if (string4.isEmpty()) {
                LOG.d("Truststore not specified for client connection");
            } else {
                try {
                    x509TrustManager = X509Util.createTrustManager(string4, string5, string6, bl2, bl3, bl4, false, bl5);
                }
                catch (X509Exception.TrustManagerException trustManagerException) {
                    LOG.d("Failed to create trust manager", trustManagerException);
                }
            }
            this.keyManager = x509KeyManager;
            this.trustManager = x509TrustManager;
        }
    }

    public X509AuthenticationProvider(X509TrustManager x509TrustManager, X509KeyManager x509KeyManager) {
        this.trustManager = x509TrustManager;
        this.keyManager = x509KeyManager;
    }

    @Override
    public String getScheme() {
        return "x509";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn serverCnxn, byte[] byArray) {
        List<Certificate> list = Arrays.asList(serverCnxn.getClientCertificateChain());
        X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[list.size()]);
        List<Id> list2 = this.handleAuthentication(x509CertificateArray);
        if (list2.isEmpty()) {
            LOG.e("Failed to authenticate session 0x{}", (Object)Long.toHexString(serverCnxn.getSessionId()));
            return KeeperException.Code.AUTHFAILED;
        }
        for (Id id2 : list2) {
            serverCnxn.addAuthInfo(id2);
        }
        return KeeperException.Code.OK;
    }

    @Override
    public List<Id> handleAuthentication(HttpServletRequest httpServletRequest, byte[] byArray) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute(X509_CERTIFICATE_ATTRIBUTE_NAME);
        return this.handleAuthentication(x509CertificateArray);
    }

    protected String getClientId(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal().getName();
    }

    @Override
    public boolean matches(String string, String string2) {
        if (System.getProperty(ZOOKEEPER_X509AUTHENTICATIONPROVIDER_SUPERUSER) != null) {
            return string.equals(System.getProperty(ZOOKEEPER_X509AUTHENTICATIONPROVIDER_SUPERUSER)) || string.equals(string2);
        }
        return string.equals(string2);
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String string) {
        try {
            new X500Principal(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public X509TrustManager getTrustManager() throws X509Exception.TrustManagerException {
        if (this.trustManager == null) {
            throw new X509Exception.TrustManagerException("No trust manager available");
        }
        return this.trustManager;
    }

    public X509KeyManager getKeyManager() throws X509Exception.KeyManagerException {
        if (this.keyManager == null) {
            throw new X509Exception.KeyManagerException("No key manager available");
        }
        return this.keyManager;
    }

    private List<Id> handleAuthentication(X509Certificate[] x509CertificateArray) {
        ArrayList<Id> arrayList = new ArrayList<Id>();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            LOG.d("No certificate chain available to authenticate");
            return arrayList;
        }
        if (this.trustManager == null) {
            LOG.e("No trust manager available to authenticate");
            return arrayList;
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        try {
            this.trustManager.checkClientTrusted(x509CertificateArray, x509Certificate.getPublicKey().getAlgorithm());
        }
        catch (CertificateException certificateException) {
            LOG.d("Failed to trust certificate", certificateException);
            return arrayList;
        }
        String string = this.getClientId(x509Certificate);
        if (string.equals(System.getProperty(ZOOKEEPER_X509AUTHENTICATIONPROVIDER_SUPERUSER))) {
            arrayList.add(new Id("super", string));
            LOG.c("Authenticated Id '{}' as super user", (Object)string);
        }
        Id id2 = new Id(this.getScheme(), string);
        arrayList.add(id2);
        LOG.c("Authenticated Id '{}' for scheme '{}'", (Object)id2.getId(), (Object)id2.getScheme());
        return Collections.unmodifiableList(arrayList);
    }
}

