/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.AuthenticationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class IPAuthenticationProvider
implements AuthenticationProvider {
    public static final String X_FORWARDED_FOR_HEADER_NAME = "X-Forwarded-For";

    @Override
    public String getScheme() {
        return "ip";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn serverCnxn, byte[] byArray) {
        String string = serverCnxn.getRemoteSocketAddress().getAddress().getHostAddress();
        serverCnxn.addAuthInfo(new Id(this.getScheme(), string));
        return KeeperException.Code.OK;
    }

    @Override
    public List<Id> handleAuthentication(HttpServletRequest httpServletRequest, byte[] byArray) {
        ArrayList<Id> arrayList = new ArrayList<Id>();
        String string = IPAuthenticationProvider.getClientIPAddress(httpServletRequest);
        arrayList.add(new Id(this.getScheme(), string));
        return Collections.unmodifiableList(arrayList);
    }

    private byte[] addr2Bytes(String string) {
        byte[] byArray = this.v4addr2Bytes(string);
        return byArray;
    }

    private byte[] v4addr2Bytes(String string) {
        String[] stringArray = string.split("\\.", -1);
        if (stringArray.length != 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            try {
                int n2 = Integer.parseInt(stringArray[i2]);
                if (n2 < 0 || n2 > 255) {
                    return null;
                }
                byArray[i2] = (byte)n2;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return byArray;
    }

    private void mask(byte[] byArray, int n2) {
        int n3 = n2 / 8;
        int n4 = (1 << 8 - n2 % 8) - 1;
        n4 ^= 0xFFFFFFFF;
        while (n3 < byArray.length) {
            int n5 = n3++;
            byArray[n5] = (byte)(byArray[n5] & n4);
            n4 = 0;
        }
    }

    @Override
    public boolean matches(String string, String string2) {
        String[] stringArray = string2.split("/", 2);
        byte[] byArray = this.addr2Bytes(stringArray[0]);
        if (byArray == null) {
            return false;
        }
        int n2 = byArray.length * 8;
        if (stringArray.length == 2) {
            try {
                n2 = Integer.parseInt(stringArray[1]);
                if (n2 < 0 || n2 > byArray.length * 8) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        this.mask(byArray, n2);
        byte[] byArray2 = this.addr2Bytes(string);
        if (byArray2 == null) {
            return false;
        }
        this.mask(byArray2, n2);
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray2[i2] == byArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public boolean isValid(String string) {
        String[] stringArray = string.split("/", 2);
        byte[] byArray = this.addr2Bytes(stringArray[0]);
        if (byArray == null) {
            return false;
        }
        if (stringArray.length == 2) {
            try {
                int n2 = Integer.parseInt(stringArray[1]);
                if (n2 < 0 || n2 > byArray.length * 8) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public static String getClientIPAddress(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader(X_FORWARDED_FOR_HEADER_NAME);
        if (string == null) {
            return httpServletRequest.getRemoteAddr();
        }
        return new StringTokenizer(string, ",").nextToken().trim();
    }
}

