/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;

public class ReadAheadEndpoint
implements EndPoint {
    private final EndPoint endPoint;
    private final ByteBuffer start;
    private final byte[] bytes;
    private int leftToRead;
    private IOException pendingException = null;

    public InetSocketAddress getLocalAddress() {
        return this.endPoint.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.endPoint.getRemoteAddress();
    }

    public boolean isOpen() {
        return this.endPoint.isOpen();
    }

    public long getCreatedTimeStamp() {
        return this.endPoint.getCreatedTimeStamp();
    }

    public boolean isOutputShutdown() {
        return this.endPoint.isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this.endPoint.isInputShutdown();
    }

    public void shutdownOutput() {
        this.endPoint.shutdownOutput();
    }

    public void close() {
        this.endPoint.close();
    }

    public Object getTransport() {
        return this.endPoint.getTransport();
    }

    public long getIdleTimeout() {
        return this.endPoint.getIdleTimeout();
    }

    public Connection getConnection() {
        return this.endPoint.getConnection();
    }

    public void onOpen() {
        this.endPoint.onOpen();
    }

    public void onClose() {
        this.endPoint.onClose();
    }

    public boolean isOptimizedForDirectBuffers() {
        return this.endPoint.isOptimizedForDirectBuffers();
    }

    public boolean isFillInterested() {
        return this.endPoint.isFillInterested();
    }

    public boolean tryFillInterested(Callback callback) {
        return this.endPoint.tryFillInterested(callback);
    }

    public boolean flush(ByteBuffer ... byteBufferArray) throws IOException {
        return this.endPoint.flush(byteBufferArray);
    }

    public void setIdleTimeout(long l2) {
        this.endPoint.setIdleTimeout(l2);
    }

    public void write(Callback callback, ByteBuffer ... byteBufferArray) throws WritePendingException {
        this.endPoint.write(callback, byteBufferArray);
    }

    public void setConnection(Connection connection) {
        this.endPoint.setConnection(connection);
    }

    public void upgrade(Connection connection) {
        this.endPoint.upgrade(connection);
    }

    public void fillInterested(Callback callback) throws ReadPendingException {
        this.endPoint.fillInterested(callback);
    }

    public ReadAheadEndpoint(EndPoint endPoint, int n2) {
        if (endPoint == null) {
            throw new IllegalArgumentException("channel cannot be null");
        }
        this.endPoint = endPoint;
        this.bytes = new byte[n2];
        this.start = ByteBuffer.wrap(this.bytes);
        this.start.flip();
        this.leftToRead = n2;
    }

    private synchronized void readAhead() throws IOException {
        if (this.leftToRead > 0) {
            int n2 = 0;
            while ((n2 = this.endPoint.fill(this.start)) == 0 && this.endPoint.isOpen() && !this.endPoint.isInputShutdown()) {
            }
            this.leftToRead = n2 == -1 ? -1 : (this.leftToRead -= n2);
            if (this.leftToRead <= 0) {
                this.start.rewind();
            }
        }
    }

    private int readFromStart(ByteBuffer byteBuffer) throws IOException {
        int n2 = Math.min(byteBuffer.remaining(), this.start.remaining());
        if (n2 > 0) {
            byteBuffer.put(this.bytes, this.start.position(), n2);
            this.start.position(this.start.position() + n2);
            byteBuffer.flip();
        }
        return n2;
    }

    public synchronized int fill(ByteBuffer byteBuffer) throws IOException {
        this.throwPendingException();
        if (this.leftToRead > 0) {
            this.readAhead();
        }
        if (this.leftToRead > 0) {
            return 0;
        }
        int n2 = this.start.remaining();
        if (n2 > 0) {
            byteBuffer.compact();
            int n3 = this.readFromStart(byteBuffer);
            if (n3 < n2) {
                return n3;
            }
        }
        return n2 + this.endPoint.fill(byteBuffer);
    }

    public byte[] getBytes() {
        if (this.pendingException == null) {
            try {
                this.readAhead();
            }
            catch (IOException iOException) {
                this.pendingException = iOException;
            }
        }
        byte[] byArray = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, byArray, 0, byArray.length);
        return byArray;
    }

    private void throwPendingException() throws IOException {
        if (this.pendingException != null) {
            IOException iOException = this.pendingException;
            this.pendingException = null;
            throw iOException;
        }
    }
}

