/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.QuorumX509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.SecretUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.AdminServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.CommandResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.Commands;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.JsonOutputter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.StreamOutputter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.UnifiedConnectionFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.IPAuthenticationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyAdminServer
implements AdminServer {
    static final foe LOG = goe.a(JettyAdminServer.class);
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_IDLE_TIMEOUT = 30000;
    public static final String DEFAULT_COMMAND_URL = "/commands";
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    public static final int DEFAULT_STS_MAX_AGE = 86400;
    public static final int DEFAULT_HTTP_VERSION = 11;
    private final Server server;
    private final String address;
    private final int port;
    private final int idleTimeout;
    private final String commandUrl;
    private ZooKeeperServer zkServer;

    public JettyAdminServer() throws AdminServer.AdminServerException, IOException, GeneralSecurityException {
        this(System.getProperty("zookeeper.admin.serverAddress", DEFAULT_ADDRESS), Integer.getInteger("zookeeper.admin.serverPort", 8080), Integer.getInteger("zookeeper.admin.idleTimeout", 30000), System.getProperty("zookeeper.admin.commandURL", DEFAULT_COMMAND_URL), Integer.getInteger("zookeeper.admin.httpVersion", 11), Boolean.getBoolean("zookeeper.admin.portUnification"), Boolean.getBoolean("zookeeper.admin.forceHttps"), Boolean.getBoolean("zookeeper.admin.needClientAuth"));
    }

    public JettyAdminServer(String string, int n2, int n3, String string2, int n4, boolean bl2, boolean bl3, boolean bl4) throws IOException, GeneralSecurityException {
        SecureRequestCustomizer secureRequestCustomizer;
        this.port = n2;
        this.idleTimeout = n3;
        this.commandUrl = string2;
        this.address = string;
        this.server = new Server();
        ServerConnector serverConnector = null;
        if (!bl2 && !bl3) {
            serverConnector = new ServerConnector(this.server);
        } else {
            secureRequestCustomizer = new SecureRequestCustomizer();
            secureRequestCustomizer.setStsMaxAge(86400L);
            secureRequestCustomizer.setStsIncludeSubDomains(true);
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setSecureScheme("https");
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
            try (QuorumX509Util quorumX509Util = new QuorumX509Util();){
                String string3 = System.getProperty(quorumX509Util.getSslKeystoreTypeProperty(), "");
                String string4 = System.getProperty(quorumX509Util.getSslKeystoreLocationProperty(), "");
                String string5 = this.getPasswordFromSystemPropertyOrFile(quorumX509Util.getSslKeystorePasswdProperty(), quorumX509Util.getSslKeystorePasswdPathProperty());
                String string6 = System.getProperty(quorumX509Util.getSslTruststoreTypeProperty(), "");
                String string7 = System.getProperty(quorumX509Util.getSslTruststoreLocationProperty(), "");
                String string8 = this.getPasswordFromSystemPropertyOrFile(quorumX509Util.getSslTruststorePasswdProperty(), quorumX509Util.getSslTruststorePasswdPathProperty());
                KeyStore keyStore = null;
                KeyStore keyStore2 = null;
                try {
                    keyStore = X509Util.loadKeyStore(string4, string5, string3);
                    keyStore2 = X509Util.loadTrustStore(string7, string8, string6);
                    LOG.c("Successfully loaded private key from {}", (Object)string4);
                    LOG.c("Successfully loaded certificate authority from {}", (Object)string7);
                }
                catch (Exception exception) {
                    LOG.d("Failed to load authentication certificates for admin server.", exception);
                    throw exception;
                }
                SslContextFactory.Server server = new SslContextFactory.Server();
                server.setKeyStore(keyStore);
                server.setKeyStorePassword(string5);
                server.setTrustStore(keyStore2);
                server.setTrustStorePassword(string8);
                server.setNeedClientAuth(bl4);
                serverConnector = bl3 ? new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)server, HttpVersion.fromVersion((int)n4).asString()), new HttpConnectionFactory(httpConfiguration)}) : new ServerConnector(this.server, new ConnectionFactory[]{new UnifiedConnectionFactory((SslContextFactory)server, HttpVersion.fromVersion((int)n4).asString()), new HttpConnectionFactory(httpConfiguration)});
            }
        }
        serverConnector.setHost(string);
        serverConnector.setPort(n2);
        serverConnector.setIdleTimeout((long)this.idleTimeout);
        this.server.addConnector((Connector)serverConnector);
        secureRequestCustomizer = new ServletContextHandler(1);
        secureRequestCustomizer.setContextPath("/*");
        this.constrainTraceMethod((ServletContextHandler)secureRequestCustomizer);
        this.server.setHandler((Handler)secureRequestCustomizer);
        secureRequestCustomizer.addServlet(new ServletHolder((Servlet)new CommandServlet()), string2 + "/*");
    }

    @Override
    public void start() throws AdminServer.AdminServerException {
        try {
            this.server.start();
        }
        catch (Exception exception) {
            String string = String.format("Problem starting AdminServer on address %s, port %d and command URL %s", this.address, this.port, this.commandUrl);
            throw new AdminServer.AdminServerException(string, exception);
        }
        LOG.c("Started AdminServer on address {}, port {} and command URL {}", this.address, this.port, this.commandUrl);
    }

    @Override
    public void shutdown() throws AdminServer.AdminServerException {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            String string = String.format("Problem stopping AdminServer on address %s, port %d and command URL %s", this.address, this.port, this.commandUrl);
            throw new AdminServer.AdminServerException(string, exception);
        }
    }

    @Override
    public void setZooKeeperServer(ZooKeeperServer zooKeeperServer) {
        this.zkServer = zooKeeperServer;
    }

    private List<String> commandLinks() {
        return Commands.getPrimaryNames().stream().sorted().map(string -> String.format("<a href=\"%s\">%s</a>", this.commandUrl + "/" + string, string)).collect(Collectors.toList());
    }

    private void constrainTraceMethod(ServletContextHandler servletContextHandler) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setMethod("TRACE");
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler constraintSecurityHandler = new ConstraintSecurityHandler();
        constraintSecurityHandler.setConstraintMappings(new ConstraintMapping[]{constraintMapping});
        servletContextHandler.setSecurityHandler((SecurityHandler)constraintSecurityHandler);
    }

    private String getPasswordFromSystemPropertyOrFile(String string, String string2) {
        String string3 = System.getProperty(string, "");
        String string4 = System.getProperty(string2, "");
        if (!string4.isEmpty()) {
            string3 = String.valueOf(SecretUtils.readSecret(string4));
        }
        return string3;
    }

    class CommandServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private CommandServlet() {
        }

        protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String string = httpServletRequest.getPathInfo();
            if (string == null || string.equals("/")) {
                for (String string2 : JettyAdminServer.this.commandLinks()) {
                    httpServletResponse.getWriter().println(string2);
                    httpServletResponse.getWriter().println("<br/>");
                }
                return;
            }
            string = string.substring(1);
            Map map = httpServletRequest.getParameterMap();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry object22 : map.entrySet()) {
                hashMap.put((String)object22.getKey(), ((String[])object22.getValue())[0]);
            }
            String string3 = httpServletRequest.getHeader(HttpHeader.AUTHORIZATION.asString());
            CommandResponse commandResponse = Commands.runGetCommand(string, JettyAdminServer.this.zkServer, hashMap, string3, httpServletRequest);
            httpServletResponse.setStatus(commandResponse.getStatusCode());
            Map<String, String> map2 = commandResponse.getHeaders();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                httpServletResponse.addHeader(entry.getKey(), entry.getValue());
            }
            String string2 = IPAuthenticationProvider.getClientIPAddress(httpServletRequest);
            if (commandResponse.getInputStream() == null) {
                JsonOutputter jsonOutputter = new JsonOutputter(string2);
                httpServletResponse.setContentType(jsonOutputter.getContentType());
                jsonOutputter.output(commandResponse, httpServletResponse.getWriter());
            } else {
                StreamOutputter streamOutputter = new StreamOutputter(string2);
                httpServletResponse.setContentType(streamOutputter.getContentType());
                streamOutputter.output(commandResponse, (OutputStream)httpServletResponse.getOutputStream());
            }
        }

        protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String string = this.extractCommandNameFromURL(httpServletRequest, httpServletResponse);
            if (string != null) {
                String string2 = httpServletRequest.getHeader(HttpHeader.AUTHORIZATION.asString());
                CommandResponse commandResponse = Commands.runPostCommand(string, JettyAdminServer.this.zkServer, (InputStream)httpServletRequest.getInputStream(), string2, httpServletRequest);
                String string3 = IPAuthenticationProvider.getClientIPAddress(httpServletRequest);
                this.sendJSONResponse(httpServletResponse, commandResponse, string3);
            }
        }

        private String extractCommandNameFromURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
            String string = httpServletRequest.getPathInfo();
            if (string == null || string.equals("/")) {
                this.printCommandLinks(httpServletResponse);
                return null;
            }
            return string.substring(1);
        }

        private void printCommandLinks(HttpServletResponse httpServletResponse) throws IOException {
            for (String string : JettyAdminServer.this.commandLinks()) {
                httpServletResponse.getWriter().println(string);
                httpServletResponse.getWriter().println("<br/>");
            }
        }

        private void sendJSONResponse(HttpServletResponse httpServletResponse, CommandResponse commandResponse, String string) throws IOException {
            JsonOutputter jsonOutputter = new JsonOutputter(string);
            httpServletResponse.setStatus(commandResponse.getStatusCode());
            httpServletResponse.setContentType(jsonOutputter.getContentType());
            jsonOutputter.output(commandResponse, httpServletResponse.getWriter());
        }
    }
}

