/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Environment;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Version;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.AuthRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.Command;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.CommandResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.GetCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.PostCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ProviderRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapshotInfo;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Follower;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.MultipleAddresses;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.RateLimiter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.ZxidUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class Commands {
    static final foe LOG = goe.a(Commands.class);
    static final String ADMIN_RATE_LIMITER_INTERVAL = "zookeeper.admin.rateLimiterIntervalInMS";
    private static final long rateLimiterInterval = Integer.parseInt(System.getProperty("zookeeper.admin.rateLimiterIntervalInMS", "300000"));
    static final String AUTH_INFO_SEPARATOR = " ";
    static final String ROOT_PATH = "/";
    private static Map<String, Command> commands = new HashMap<String, Command>();
    private static Set<String> primaryNames = new HashSet<String>();

    public static void registerCommand(Command command) {
        for (String string : command.getNames()) {
            Command command2 = commands.put(string, command);
            if (command2 == null) continue;
            LOG.d("Re-registering command {} (primary name = {})", (Object)string, (Object)command.getPrimaryName());
        }
        primaryNames.add(command.getPrimaryName());
    }

    public static CommandResponse runGetCommand(String string, ZooKeeperServer zooKeeperServer, Map<String, String> map, String string2, HttpServletRequest httpServletRequest) {
        return Commands.runCommand(string, zooKeeperServer, map, null, string2, httpServletRequest, true);
    }

    public static CommandResponse runPostCommand(String string, ZooKeeperServer zooKeeperServer, InputStream inputStream, String string2, HttpServletRequest httpServletRequest) {
        return Commands.runCommand(string, zooKeeperServer, null, inputStream, string2, httpServletRequest, false);
    }

    private static CommandResponse runCommand(String string, ZooKeeperServer zooKeeperServer, Map<String, String> map, InputStream inputStream, String string2, HttpServletRequest httpServletRequest, boolean bl2) {
        Command command = Commands.getCommand(string);
        if (command == null) {
            LOG.d("Unknown command");
            return new CommandResponse(string, "Unknown command: " + string, 200);
        }
        if (command.isServerRequired() && (zooKeeperServer == null || !zooKeeperServer.isRunning())) {
            LOG.d("This ZooKeeper instance is not currently serving requests for command");
            return new CommandResponse(string, "This ZooKeeper instance is not currently serving requests", 200);
        }
        AuthRequest authRequest = command.getAuthRequest();
        if (authRequest != null) {
            if (string2 == null) {
                LOG.d("Auth info is missing for command");
                return new CommandResponse(string, "Auth info is missing for the command", 401);
            }
            try {
                List<Id> list = Commands.handleAuthentication(httpServletRequest, string2);
                Commands.handleAuthorization(zooKeeperServer, list, authRequest.getPermission(), authRequest.getPath());
            }
            catch (KeeperException.AuthFailedException authFailedException) {
                return new CommandResponse(string, "Not authenticated", 401);
            }
            catch (KeeperException.NoAuthException noAuthException) {
                return new CommandResponse(string, "Not authorized", 403);
            }
            catch (Exception exception) {
                LOG.c("Error occurred during auth for command", exception);
                return new CommandResponse(string, "Error occurred during auth", 500);
            }
        }
        return bl2 ? command.runGet(zooKeeperServer, map) : command.runPost(zooKeeperServer, inputStream);
    }

    private static List<Id> handleAuthentication(HttpServletRequest httpServletRequest, String string) throws KeeperException.AuthFailedException {
        String[] stringArray = string.split(AUTH_INFO_SEPARATOR);
        if (stringArray.length != 1 && stringArray.length != 2) {
            LOG.d("Invalid auth info length");
            throw new KeeperException.AuthFailedException();
        }
        String string2 = stringArray[0];
        ServerAuthenticationProvider serverAuthenticationProvider = ProviderRegistry.getServerProvider(string2);
        if (serverAuthenticationProvider != null) {
            try {
                byte[] byArray = stringArray.length == 2 ? stringArray[1].getBytes(StandardCharsets.UTF_8) : null;
                List<Id> list = serverAuthenticationProvider.handleAuthentication(httpServletRequest, byArray);
                if (list.isEmpty()) {
                    LOG.d("Auth Id list is empty");
                    throw new KeeperException.AuthFailedException();
                }
                return list;
            }
            catch (RuntimeException runtimeException) {
                LOG.c("Caught runtime exception from AuthenticationProvider", runtimeException);
                throw new KeeperException.AuthFailedException();
            }
        }
        LOG.d("Auth provider not found for schema");
        throw new KeeperException.AuthFailedException();
    }

    private static void handleAuthorization(ZooKeeperServer zooKeeperServer, List<Id> list, int n2, String string) throws KeeperException.NoNodeException, KeeperException.NoAuthException {
        DataNode dataNode = zooKeeperServer.getZKDatabase().getNode(string);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException(string);
        }
        List<ACL> list2 = zooKeeperServer.getZKDatabase().aclForNode(dataNode);
        zooKeeperServer.checkACL(null, list2, n2, list, string, null);
    }

    public static Set<String> getPrimaryNames() {
        return primaryNames;
    }

    public static Command getCommand(String string) {
        return commands.get(string);
    }

    private Commands() {
    }

    static /* synthetic */ long access$000() {
        return rateLimiterInterval;
    }

    static {
        Commands.registerCommand(new CnxnStatResetCommand());
        Commands.registerCommand(new ConfCommand());
        Commands.registerCommand(new ConsCommand());
        Commands.registerCommand(new DigestCommand());
        Commands.registerCommand(new DirsCommand());
        Commands.registerCommand(new DumpCommand());
        Commands.registerCommand(new EnvCommand());
        Commands.registerCommand(new GetTraceMaskCommand());
        Commands.registerCommand(new InitialConfigurationCommand());
        Commands.registerCommand(new IsroCommand());
        Commands.registerCommand(new LastSnapshotCommand());
        Commands.registerCommand(new LeaderCommand());
        Commands.registerCommand(new MonitorCommand());
        Commands.registerCommand(new ObserverCnxnStatResetCommand());
        Commands.registerCommand(new RestoreCommand());
        Commands.registerCommand(new RuokCommand());
        Commands.registerCommand(new SetTraceMaskCommand());
        Commands.registerCommand(new SnapshotCommand());
        Commands.registerCommand(new SrvrCommand());
        Commands.registerCommand(new StatCommand());
        Commands.registerCommand(new StatResetCommand());
        Commands.registerCommand(new SyncedObserverConsCommand());
        Commands.registerCommand(new SystemPropertiesCommand());
        Commands.registerCommand(new VotingViewCommand());
        Commands.registerCommand(new WatchCommand());
        Commands.registerCommand(new WatchesByPathCommand());
        Commands.registerCommand(new WatchSummaryCommand());
        Commands.registerCommand(new ZabStateCommand());
    }

    public static class ZabStateCommand
    extends GetCommand {
        public ZabStateCommand() {
            super(Arrays.asList("zabstate"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            if (zooKeeperServer instanceof QuorumZooKeeperServer) {
                QuorumPeer quorumPeer = ((QuorumZooKeeperServer)zooKeeperServer).self;
                QuorumPeer.ZabState zabState = quorumPeer.getZabState();
                QuorumVerifier quorumVerifier = quorumPeer.getQuorumVerifier();
                QuorumPeer.QuorumServer quorumServer = quorumVerifier.getVotingMembers().get(quorumPeer.getMyId());
                boolean bl2 = quorumServer != null && quorumServer.addr.equals(quorumPeer.getQuorumAddress()) && quorumServer.electionAddr.equals(quorumPeer.getElectionAddress());
                commandResponse.put("myid", zooKeeperServer.getConf().getServerId());
                commandResponse.put("is_leader", zooKeeperServer instanceof LeaderZooKeeperServer);
                commandResponse.put("quorum_address", quorumPeer.getQuorumAddress());
                commandResponse.put("election_address", quorumPeer.getElectionAddress());
                commandResponse.put("client_address", quorumPeer.getClientAddress());
                commandResponse.put("voting", bl2);
                long l2 = zooKeeperServer.getZKDatabase().getDataTreeLastProcessedZxid();
                commandResponse.put("last_zxid", "0x" + ZxidUtils.zxidToString(l2));
                commandResponse.put("zab_epoch", ZxidUtils.getEpochFromZxid(l2));
                commandResponse.put("zab_counter", ZxidUtils.getCounterFromZxid(l2));
                commandResponse.put("zabstate", zabState.name().toLowerCase());
            } else {
                commandResponse.put("voting", false);
                commandResponse.put("zabstate", "");
            }
            return commandResponse;
        }
    }

    public static class WatchSummaryCommand
    extends GetCommand {
        public WatchSummaryCommand() {
            super(Arrays.asList("watch_summary", "wchs"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            DataTree dataTree = zooKeeperServer.getZKDatabase().getDataTree();
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.putAll(dataTree.getWatchesSummary().toMap());
            return commandResponse;
        }
    }

    public static class WatchesByPathCommand
    extends GetCommand {
        public WatchesByPathCommand() {
            super(Arrays.asList("watches_by_path", "wchp"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            DataTree dataTree = zooKeeperServer.getZKDatabase().getDataTree();
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.put("path_to_session_ids", dataTree.getWatchesByPath().toMap());
            return commandResponse;
        }
    }

    public static class WatchCommand
    extends GetCommand {
        public WatchCommand() {
            super(Arrays.asList("watches", "wchc"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            DataTree dataTree = zooKeeperServer.getZKDatabase().getDataTree();
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.put("session_id_to_watched_paths", dataTree.getWatches().toMap());
            return commandResponse;
        }
    }

    public static class VotingViewCommand
    extends GetCommand {
        public VotingViewCommand() {
            super(Arrays.asList("voting_view"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            if (zooKeeperServer instanceof QuorumZooKeeperServer) {
                QuorumPeer quorumPeer = ((QuorumZooKeeperServer)zooKeeperServer).self;
                Map<Long, QuorumServerView> map2 = quorumPeer.getVotingView().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new QuorumServerView((QuorumPeer.QuorumServer)entry.getValue())));
                commandResponse.put("current_config", map2);
            } else {
                commandResponse.put("current_config", Collections.emptyMap());
            }
            return commandResponse;
        }

        static class QuorumServerView {
            private List<String> serverAddresses;
            private List<String> electionAddresses;
            private String clientAddress;
            private String learnerType;

            public QuorumServerView(QuorumPeer.QuorumServer quorumServer) {
                this.serverAddresses = QuorumServerView.getMultiAddressString(quorumServer.addr);
                this.electionAddresses = QuorumServerView.getMultiAddressString(quorumServer.electionAddr);
                this.learnerType = quorumServer.type.equals((Object)QuorumPeer.LearnerType.PARTICIPANT) ? "participant" : "observer";
                this.clientAddress = QuorumServerView.getAddressString(quorumServer.clientAddr);
            }

            private static List<String> getMultiAddressString(MultipleAddresses multipleAddresses) {
                if (multipleAddresses == null) {
                    return Collections.emptyList();
                }
                return multipleAddresses.getAllAddresses().stream().map(QuorumServerView::getAddressString).collect(Collectors.toList());
            }

            private static String getAddressString(InetSocketAddress inetSocketAddress) {
                if (inetSocketAddress == null) {
                    return "";
                }
                return String.format("%s:%d", QuorumPeer.QuorumServer.delimitedHostString(inetSocketAddress), inetSocketAddress.getPort());
            }
        }
    }

    public static class SystemPropertiesCommand
    extends GetCommand {
        public SystemPropertiesCommand() {
            super(Arrays.asList("system_properties", "sysp"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            Properties properties = System.getProperties();
            TreeMap treeMap = new TreeMap();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> treeMap.put(object.toString(), object2.toString())));
            commandResponse.putAll(treeMap);
            return commandResponse;
        }
    }

    public static class SyncedObserverConsCommand
    extends GetCommand {
        public SyncedObserverConsCommand() {
            super(Arrays.asList("observers", "obsr"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            Follower follower;
            Integer n2;
            CommandResponse commandResponse = this.initializeResponse();
            if (zooKeeperServer instanceof LeaderZooKeeperServer) {
                Leader leader = ((LeaderZooKeeperServer)zooKeeperServer).getLeader();
                commandResponse.put("synced_observers", leader.getObservingLearners().size());
                commandResponse.put("observers", leader.getObservingLearnersInfo());
                return commandResponse;
            }
            if (zooKeeperServer instanceof FollowerZooKeeperServer && (n2 = (follower = ((FollowerZooKeeperServer)zooKeeperServer).getFollower()).getSyncedObserverSize()) != null) {
                commandResponse.put("synced_observers", n2);
                commandResponse.put("observers", follower.getSyncedObserversInfo());
                return commandResponse;
            }
            commandResponse.put("synced_observers", 0);
            commandResponse.put("observers", Collections.emptySet());
            return commandResponse;
        }
    }

    public static class StatResetCommand
    extends GetCommand {
        public StatResetCommand() {
            super(Arrays.asList("stat_reset", "srst"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            zooKeeperServer.serverStats().reset();
            return commandResponse;
        }
    }

    public static class StatCommand
    extends SrvrCommand {
        public StatCommand() {
            super(Arrays.asList("stats", "stat"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = super.runGet(zooKeeperServer, map);
            Iterable<Object> iterable = zooKeeperServer.getServerCnxnFactory() != null ? zooKeeperServer.getServerCnxnFactory().getAllConnectionInfo(true) : Collections.emptyList();
            commandResponse.put("connections", iterable);
            Iterable<Object> iterable2 = zooKeeperServer.getSecureServerCnxnFactory() != null ? zooKeeperServer.getSecureServerCnxnFactory().getAllConnectionInfo(true) : Collections.emptyList();
            commandResponse.put("secure_connections", iterable2);
            return commandResponse;
        }
    }

    public static class SrvrCommand
    extends GetCommand {
        public SrvrCommand() {
            super(Arrays.asList("server_stats", "srvr"));
        }

        protected SrvrCommand(List<String> list) {
            super(list);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            LOG.c("running stat");
            commandResponse.put("version", Version.getFullVersion());
            commandResponse.put("read_only", zooKeeperServer instanceof ReadOnlyZooKeeperServer);
            commandResponse.put("server_stats", zooKeeperServer.serverStats());
            commandResponse.put("client_response", zooKeeperServer.serverStats().getClientResponseStats());
            if (zooKeeperServer instanceof LeaderZooKeeperServer) {
                Leader leader = ((LeaderZooKeeperServer)zooKeeperServer).getLeader();
                commandResponse.put("proposal_stats", leader.getProposalStats());
            }
            commandResponse.put("node_count", zooKeeperServer.getZKDatabase().getNodeCount());
            return commandResponse;
        }
    }

    public static class SnapshotCommand
    extends GetCommand {
        static final String REQUEST_QUERY_PARAM_STREAMING = "streaming";
        static final String RESPONSE_HEADER_LAST_ZXID = "last_zxid";
        static final String RESPONSE_HEADER_SNAPSHOT_SIZE = "snapshot_size";
        static final String ADMIN_SNAPSHOT_ENABLED = "zookeeper.admin.snapshot.enabled";
        private final RateLimiter rateLimiter = new RateLimiter(1, Commands.access$000(), TimeUnit.MICROSECONDS);

        public SnapshotCommand() {
            super(Arrays.asList("snapshot", "snap"), true, new AuthRequest(31, Commands.ROOT_PATH));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            boolean bl2 = Boolean.parseBoolean(System.getProperty(ADMIN_SNAPSHOT_ENABLED, "true"));
            if (!bl2) {
                commandResponse.setStatusCode(503);
                LOG.d("Snapshot command is disabled");
                return commandResponse;
            }
            if (!zooKeeperServer.isSerializeLastProcessedZxidEnabled()) {
                commandResponse.setStatusCode(500);
                LOG.d("Snapshot command requires serializeLastProcessedZxidEnable flag is set to true");
                return commandResponse;
            }
            if (!this.rateLimiter.allow()) {
                commandResponse.setStatusCode(429);
                ServerMetrics.getMetrics().SNAPSHOT_RATE_LIMITED_COUNT.add(1L);
                LOG.d("Snapshot request was rate limited");
                return commandResponse;
            }
            boolean bl3 = true;
            if (map.containsKey(REQUEST_QUERY_PARAM_STREAMING)) {
                bl3 = Boolean.parseBoolean(map.get(REQUEST_QUERY_PARAM_STREAMING));
            }
            try {
                File file = zooKeeperServer.takeSnapshot(false, false, true);
                long l2 = Util.getZxidFromName(file.getName(), "snapshot");
                commandResponse.addHeader(RESPONSE_HEADER_LAST_ZXID, "0x" + ZxidUtils.zxidToString(l2));
                long l3 = file.length();
                commandResponse.addHeader(RESPONSE_HEADER_SNAPSHOT_SIZE, String.valueOf(l3));
                if (l3 == 0L) {
                    commandResponse.setStatusCode(500);
                    ServerMetrics.getMetrics().SNAPSHOT_ERROR_COUNT.add(1L);
                    LOG.d("Snapshot file {} is empty", (Object)file);
                } else if (bl3) {
                    commandResponse.setInputStream(new FileInputStream(file));
                }
            }
            catch (Exception exception) {
                commandResponse.setStatusCode(500);
                ServerMetrics.getMetrics().SNAPSHOT_ERROR_COUNT.add(1L);
                LOG.c("Exception occurred when taking the snapshot via the snapshot admin command", exception);
            }
            return commandResponse;
        }
    }

    public static class SetTraceMaskCommand
    extends GetCommand {
        public SetTraceMaskCommand() {
            super(Arrays.asList("set_trace_mask", "stmk"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            long l2;
            CommandResponse commandResponse = this.initializeResponse();
            if (!map.containsKey("traceMask")) {
                commandResponse.put("error", "setTraceMask requires long traceMask argument");
                return commandResponse;
            }
            try {
                l2 = Long.parseLong(map.get("traceMask"));
            }
            catch (NumberFormatException numberFormatException) {
                commandResponse.put("error", "setTraceMask requires long traceMask argument, got " + map.get("traceMask"));
                return commandResponse;
            }
            ZooTrace.setTextTraceLevel(l2);
            commandResponse.put("tracemask", l2);
            return commandResponse;
        }
    }

    public static class RuokCommand
    extends GetCommand {
        public RuokCommand() {
            super(Arrays.asList("ruok"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            return this.initializeResponse();
        }
    }

    public static class RestoreCommand
    extends PostCommand {
        static final String RESPONSE_DATA_LAST_ZXID = "last_zxid";
        static final String ADMIN_RESTORE_ENABLED = "zookeeper.admin.restore.enabled";
        private RateLimiter rateLimiter = new RateLimiter(1, Commands.access$000(), TimeUnit.MILLISECONDS);

        public RestoreCommand() {
            super(Arrays.asList("restore", "rest"), true, new AuthRequest(31, Commands.ROOT_PATH));
        }

        @Override
        public CommandResponse runPost(ZooKeeperServer zooKeeperServer, InputStream inputStream) {
            CommandResponse commandResponse = this.initializeResponse();
            boolean bl2 = Boolean.parseBoolean(System.getProperty(ADMIN_RESTORE_ENABLED, "true"));
            if (!bl2) {
                commandResponse.setStatusCode(503);
                LOG.d("Restore command is disabled");
                return commandResponse;
            }
            if (!zooKeeperServer.isSerializeLastProcessedZxidEnabled()) {
                commandResponse.setStatusCode(500);
                LOG.d("Restore command requires serializeLastProcessedZxidEnable flag is set to true");
                return commandResponse;
            }
            if (inputStream == null) {
                commandResponse.setStatusCode(400);
                LOG.d("InputStream from restore request is null");
                return commandResponse;
            }
            if (!this.rateLimiter.allow()) {
                commandResponse.setStatusCode(429);
                ServerMetrics.getMetrics().RESTORE_RATE_LIMITED_COUNT.add(1L);
                LOG.d("Restore request was rate limited");
                return commandResponse;
            }
            try {
                long l2 = zooKeeperServer.restoreFromSnapshot(inputStream);
                commandResponse.put(RESPONSE_DATA_LAST_ZXID, l2);
            }
            catch (Exception exception) {
                commandResponse.setStatusCode(500);
                ServerMetrics.getMetrics().RESTORE_ERROR_COUNT.add(1L);
                LOG.c("Exception occurred when restore snapshot via the restore command", exception);
            }
            return commandResponse;
        }
    }

    public static class ObserverCnxnStatResetCommand
    extends GetCommand {
        public ObserverCnxnStatResetCommand() {
            super(Arrays.asList("observer_connection_stat_reset", "orst"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            if (zooKeeperServer instanceof LeaderZooKeeperServer) {
                Leader leader = ((LeaderZooKeeperServer)zooKeeperServer).getLeader();
                leader.resetObserverConnectionStats();
            } else if (zooKeeperServer instanceof FollowerZooKeeperServer) {
                Follower follower = ((FollowerZooKeeperServer)zooKeeperServer).getFollower();
                follower.resetObserverConnectionStats();
            }
            return commandResponse;
        }
    }

    public static class MonitorCommand
    extends GetCommand {
        public MonitorCommand() {
            super(Arrays.asList("monitor", "mntr"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            zooKeeperServer.dumpMonitorValues(commandResponse::put);
            ServerMetrics.getMetrics().getMetricsProvider().dump(commandResponse::put);
            return commandResponse;
        }
    }

    public static class LeaderCommand
    extends GetCommand {
        public LeaderCommand() {
            super(Arrays.asList("leader", "lead"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            if (zooKeeperServer instanceof QuorumZooKeeperServer) {
                commandResponse.put("is_leader", zooKeeperServer instanceof LeaderZooKeeperServer);
                QuorumPeer quorumPeer = ((QuorumZooKeeperServer)zooKeeperServer).self;
                commandResponse.put("leader_id", quorumPeer.getLeaderId());
                String string = quorumPeer.getLeaderAddress();
                commandResponse.put("leader_ip", string != null ? string : "");
            } else {
                commandResponse.put("error", "server is not initialized");
            }
            return commandResponse;
        }
    }

    public static class LastSnapshotCommand
    extends GetCommand {
        public LastSnapshotCommand() {
            super(Arrays.asList("last_snapshot", "lsnp"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            SnapshotInfo snapshotInfo = zooKeeperServer.getTxnLogFactory().getLastSnapshotInfo();
            commandResponse.put("zxid", Long.toHexString(snapshotInfo == null ? -1L : snapshotInfo.zxid));
            commandResponse.put("timestamp", snapshotInfo == null ? -1L : snapshotInfo.timestamp);
            return commandResponse;
        }
    }

    public static class IsroCommand
    extends GetCommand {
        public IsroCommand() {
            super(Arrays.asList("is_read_only", "isro"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.put("read_only", zooKeeperServer instanceof ReadOnlyZooKeeperServer);
            return commandResponse;
        }
    }

    public static class InitialConfigurationCommand
    extends GetCommand {
        public InitialConfigurationCommand() {
            super(Arrays.asList("initial_configuration", "icfg"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.put("initial_configuration", zooKeeperServer.getInitialConfig());
            return commandResponse;
        }
    }

    public static class GetTraceMaskCommand
    extends GetCommand {
        public GetTraceMaskCommand() {
            super(Arrays.asList("get_trace_mask", "gtmk"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.put("tracemask", ZooTrace.getTextTraceLevel());
            return commandResponse;
        }
    }

    public static class DigestCommand
    extends GetCommand {
        public DigestCommand() {
            super(Arrays.asList("hash"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.put("digests", zooKeeperServer.getZKDatabase().getDataTree().getDigestLog());
            return commandResponse;
        }
    }

    public static class EnvCommand
    extends GetCommand {
        public EnvCommand() {
            super(Arrays.asList("environment", "env", "envi"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            for (Environment.Entry entry : Environment.list()) {
                commandResponse.put(entry.getKey(), entry.getValue());
            }
            return commandResponse;
        }
    }

    public static class DumpCommand
    extends GetCommand {
        public DumpCommand() {
            super(Arrays.asList("dump"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.put("expiry_time_to_session_ids", zooKeeperServer.getSessionExpiryMap());
            commandResponse.put("session_id_to_ephemeral_paths", zooKeeperServer.getEphemerals());
            return commandResponse;
        }
    }

    public static class DirsCommand
    extends GetCommand {
        public DirsCommand() {
            super(Arrays.asList("dirs"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.put("datadir_size", zooKeeperServer.getDataDirSize());
            commandResponse.put("logdir_size", zooKeeperServer.getLogDirSize());
            return commandResponse;
        }
    }

    public static class ConsCommand
    extends GetCommand {
        public ConsCommand() {
            super(Arrays.asList("connections", "cons"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            ServerCnxnFactory serverCnxnFactory = zooKeeperServer.getServerCnxnFactory();
            if (serverCnxnFactory != null) {
                commandResponse.put("connections", serverCnxnFactory.getAllConnectionInfo(false));
            } else {
                commandResponse.put("connections", Collections.emptyList());
            }
            ServerCnxnFactory serverCnxnFactory2 = zooKeeperServer.getSecureServerCnxnFactory();
            if (serverCnxnFactory2 != null) {
                commandResponse.put("secure_connections", serverCnxnFactory2.getAllConnectionInfo(false));
            } else {
                commandResponse.put("secure_connections", Collections.emptyList());
            }
            return commandResponse;
        }
    }

    public static class ConfCommand
    extends GetCommand {
        public ConfCommand() {
            super(Arrays.asList("configuration", "conf", "config"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            commandResponse.putAll(zooKeeperServer.getConf().toMap());
            return commandResponse;
        }
    }

    public static class CnxnStatResetCommand
    extends GetCommand {
        public CnxnStatResetCommand() {
            super(Arrays.asList("connection_stat_reset", "crst"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zooKeeperServer, Map<String, String> map) {
            CommandResponse commandResponse = this.initializeResponse();
            zooKeeperServer.getServerCnxnFactory().resetAllConnectionStats();
            return commandResponse;
        }
    }
}

