/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.AuthRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.Command;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.admin.CommandResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CommandBase
implements Command {
    private final String primaryName;
    private final Set<String> names;
    private final boolean serverRequired;
    private final AuthRequest authRequest;

    protected CommandBase(List<String> list) {
        this(list, true);
    }

    protected CommandBase(List<String> list, boolean bl2) {
        this(list, bl2, null);
    }

    protected CommandBase(List<String> list, boolean bl2, AuthRequest authRequest) {
        if (authRequest != null && !bl2) {
            throw new IllegalArgumentException("An active server is required for auth check");
        }
        this.primaryName = list.get(0);
        this.names = new HashSet<String>(list);
        this.serverRequired = bl2;
        this.authRequest = authRequest;
    }

    @Override
    public String getPrimaryName() {
        return this.primaryName;
    }

    @Override
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public boolean isServerRequired() {
        return this.serverRequired;
    }

    @Override
    public AuthRequest getAuthRequest() {
        return this.authRequest;
    }

    protected CommandResponse initializeResponse() {
        return new CommandResponse(this.primaryName);
    }
}

