/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.hme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Version;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.ZKMBeanInfo;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestThrottler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnHelper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerStats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerMXBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.CommitProcessor;
import java.util.Date;

public class ZooKeeperServerBean
implements ZKMBeanInfo,
ZooKeeperServerMXBean {
    private final Date startTime = new Date();
    private final String name;
    public final ZooKeeperServer zks;

    public ZooKeeperServerBean(ZooKeeperServer zooKeeperServer) {
        this.zks = zooKeeperServer;
        this.name = "StandaloneServer_port" + zooKeeperServer.getClientPort();
    }

    @Override
    public String getClientPort() {
        return Integer.toString(this.zks.getClientPort());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getStartTime() {
        return this.startTime.toString();
    }

    @Override
    public String getVersion() {
        return Version.getFullVersion();
    }

    @Override
    public double getAvgRequestLatency() {
        return this.zks.serverStats().getAvgLatency();
    }

    @Override
    public long getMaxRequestLatency() {
        return this.zks.serverStats().getMaxLatency();
    }

    @Override
    public long getMinRequestLatency() {
        return this.zks.serverStats().getMinLatency();
    }

    @Override
    public long getOutstandingRequests() {
        return this.zks.serverStats().getOutstandingRequests();
    }

    @Override
    public int getTickTime() {
        return this.zks.getTickTime();
    }

    @Override
    public void setTickTime(int n2) {
        this.zks.setTickTime(n2);
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.zks.getMaxClientCnxnsPerHost();
    }

    @Override
    public void setMaxClientCnxnsPerHost(int n2) {
        if (this.zks.serverCnxnFactory != null) {
            this.zks.serverCnxnFactory.setMaxClientCnxnsPerHost(n2);
        }
        if (this.zks.secureServerCnxnFactory != null) {
            this.zks.secureServerCnxnFactory.setMaxClientCnxnsPerHost(n2);
        }
    }

    @Override
    public int getMinSessionTimeout() {
        return this.zks.getMinSessionTimeout();
    }

    @Override
    public void setMinSessionTimeout(int n2) {
        this.zks.setMinSessionTimeout(n2);
    }

    @Override
    public int getMaxSessionTimeout() {
        return this.zks.getMaxSessionTimeout();
    }

    @Override
    public void setMaxSessionTimeout(int n2) {
        this.zks.setMaxSessionTimeout(n2);
    }

    @Override
    public long getDataDirSize() {
        return this.zks.getDataDirSize();
    }

    @Override
    public long getLogDirSize() {
        return this.zks.getLogDirSize();
    }

    @Override
    public long getPacketsReceived() {
        return this.zks.serverStats().getPacketsReceived();
    }

    @Override
    public long getPacketsSent() {
        return this.zks.serverStats().getPacketsSent();
    }

    @Override
    public long getFsyncThresholdExceedCount() {
        return this.zks.serverStats().getFsyncThresholdExceedCount();
    }

    @Override
    public long getAuthFailedCount() {
        return this.zks.serverStats().getAuthFailedCount();
    }

    @Override
    public long getNonMTLSRemoteConnCount() {
        return this.zks.serverStats().getNonMTLSRemoteConnCount();
    }

    @Override
    public long getNonMTLSLocalConnCount() {
        return this.zks.serverStats().getNonMTLSLocalConnCount();
    }

    @Override
    public void resetLatency() {
        this.zks.serverStats().resetLatency();
    }

    @Override
    public void resetMaxLatency() {
        this.zks.serverStats().resetMaxLatency();
    }

    @Override
    public void resetFsyncThresholdExceedCount() {
        this.zks.serverStats().resetFsyncThresholdExceedCount();
    }

    @Override
    public void resetAuthFailedCount() {
        this.zks.serverStats().resetAuthFailedCount();
    }

    @Override
    public void resetNonMTLSConnCount() {
        this.zks.serverStats().resetNonMTLSRemoteConnCount();
        this.zks.serverStats().resetNonMTLSLocalConnCount();
    }

    @Override
    public void resetStatistics() {
        ServerStats serverStats = this.zks.serverStats();
        serverStats.resetRequestCounters();
        serverStats.resetLatency();
        serverStats.resetFsyncThresholdExceedCount();
        serverStats.resetAuthFailedCount();
        serverStats.resetNonMTLSRemoteConnCount();
        serverStats.resetNonMTLSLocalConnCount();
    }

    @Override
    public long getNumAliveConnections() {
        return this.zks.getNumAliveConnections();
    }

    @Override
    public String getSecureClientPort() {
        if (this.zks.secureServerCnxnFactory != null) {
            return Integer.toString(this.zks.secureServerCnxnFactory.getLocalPort());
        }
        return "";
    }

    @Override
    public String getSecureClientAddress() {
        if (this.zks.secureServerCnxnFactory != null) {
            return String.format("%s:%d", this.zks.secureServerCnxnFactory.getLocalAddress().getHostString(), this.zks.secureServerCnxnFactory.getLocalPort());
        }
        return "";
    }

    @Override
    public long getTxnLogElapsedSyncTime() {
        return this.zks.getTxnLogElapsedSyncTime();
    }

    @Override
    public int getJuteMaxBufferSize() {
        return hme.a;
    }

    @Override
    public int getLastClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getLastBufferSize();
    }

    @Override
    public int getMinClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getMinBufferSize();
    }

    @Override
    public int getMaxClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getMaxBufferSize();
    }

    @Override
    public boolean getResponseCachingEnabled() {
        return this.zks.isResponseCachingEnabled();
    }

    @Override
    public void setResponseCachingEnabled(boolean bl2) {
        this.zks.setResponseCachingEnabled(bl2);
    }

    @Override
    public int getConnectionMaxTokens() {
        return this.zks.connThrottle().getMaxTokens();
    }

    @Override
    public void setConnectionMaxTokens(int n2) {
        this.zks.connThrottle().setMaxTokens(n2);
    }

    @Override
    public int getConnectionTokenFillTime() {
        return this.zks.connThrottle().getFillTime();
    }

    @Override
    public void setConnectionTokenFillTime(int n2) {
        this.zks.connThrottle().setFillTime(n2);
    }

    @Override
    public int getConnectionTokenFillCount() {
        return this.zks.connThrottle().getFillCount();
    }

    @Override
    public void setConnectionTokenFillCount(int n2) {
        this.zks.connThrottle().setFillCount(n2);
    }

    @Override
    public int getConnectionFreezeTime() {
        return this.zks.connThrottle().getFreezeTime();
    }

    @Override
    public void setConnectionFreezeTime(int n2) {
        this.zks.connThrottle().setFreezeTime(n2);
    }

    @Override
    public double getConnectionDropIncrease() {
        return this.zks.connThrottle().getDropIncrease();
    }

    @Override
    public void setConnectionDropIncrease(double d2) {
        this.zks.connThrottle().setDropIncrease(d2);
    }

    @Override
    public double getConnectionDropDecrease() {
        return this.zks.connThrottle().getDropDecrease();
    }

    @Override
    public void setConnectionDropDecrease(double d2) {
        this.zks.connThrottle().setDropDecrease(d2);
    }

    @Override
    public double getConnectionDecreaseRatio() {
        return this.zks.connThrottle().getDecreasePoint();
    }

    @Override
    public void setConnectionDecreaseRatio(double d2) {
        this.zks.connThrottle().setDecreasePoint(d2);
    }

    @Override
    public int getCommitProcMaxReadBatchSize() {
        return CommitProcessor.getMaxReadBatchSize();
    }

    @Override
    public void setCommitProcMaxReadBatchSize(int n2) {
        CommitProcessor.setMaxReadBatchSize(n2);
    }

    @Override
    public int getCommitProcMaxCommitBatchSize() {
        return CommitProcessor.getMaxCommitBatchSize();
    }

    @Override
    public void setCommitProcMaxCommitBatchSize(int n2) {
        CommitProcessor.setMaxCommitBatchSize(n2);
    }

    @Override
    public long getFlushDelay() {
        return this.zks.getFlushDelay();
    }

    @Override
    public void setFlushDelay(long l2) {
        ZooKeeperServer.setFlushDelay(l2);
    }

    @Override
    public int getThrottledOpWaitTime() {
        return ZooKeeperServer.getThrottledOpWaitTime();
    }

    @Override
    public void setThrottledOpWaitTime(int n2) {
        ZooKeeperServer.setThrottledOpWaitTime(n2);
    }

    @Override
    public int getRequestThrottleLimit() {
        return RequestThrottler.getMaxRequests();
    }

    @Override
    public void setRequestThrottleLimit(int n2) {
        RequestThrottler.setMaxRequests(n2);
    }

    @Override
    public int getRequestThrottleStallTime() {
        return RequestThrottler.getStallTime();
    }

    @Override
    public void setRequestThrottleStallTime(int n2) {
        RequestThrottler.setStallTime(n2);
    }

    @Override
    public boolean getRequestThrottleDropStale() {
        return RequestThrottler.getDropStaleRequests();
    }

    @Override
    public void setRequestThrottleDropStale(boolean bl2) {
        RequestThrottler.setDropStaleRequests(bl2);
    }

    @Override
    public long getMaxWriteQueuePollTime() {
        return this.zks.getMaxWriteQueuePollTime();
    }

    @Override
    public void setMaxWriteQueuePollTime(long l2) {
        ZooKeeperServer.setMaxWriteQueuePollTime(l2);
    }

    @Override
    public boolean getRequestStaleLatencyCheck() {
        return Request.getStaleLatencyCheck();
    }

    @Override
    public void setRequestStaleLatencyCheck(boolean bl2) {
        Request.setStaleLatencyCheck(bl2);
    }

    @Override
    public int getMaxBatchSize() {
        return this.zks.getMaxBatchSize();
    }

    @Override
    public void setMaxBatchSize(int n2) {
        ZooKeeperServer.setMaxBatchSize(n2);
    }

    @Override
    public boolean getRequestStaleConnectionCheck() {
        return Request.getStaleConnectionCheck();
    }

    @Override
    public void setRequestStaleConnectionCheck(boolean bl2) {
        Request.setStaleConnectionCheck(bl2);
    }

    @Override
    public int getLargeRequestMaxBytes() {
        return this.zks.getLargeRequestMaxBytes();
    }

    @Override
    public void setLargeRequestMaxBytes(int n2) {
        this.zks.setLargeRequestMaxBytes(n2);
    }

    @Override
    public int getLargeRequestThreshold() {
        return this.zks.getLargeRequestThreshold();
    }

    @Override
    public void setLargeRequestThreshold(int n2) {
        this.zks.setLargeRequestThreshold(n2);
    }

    @Override
    public int getMaxCnxns() {
        return ServerCnxnHelper.getMaxCnxns(this.zks.secureServerCnxnFactory, this.zks.serverCnxnFactory);
    }
}

